/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.sensors;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimSensor;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimIMUSensor
extends SimSensor {
    private final YoFrameQuaternion orientation;
    private final YoFrameVector3D angularVelocity;
    private final YoFrameVector3D linearAcceleration;
    private final YoDouble filterBreakFrequency;
    private final YoBoolean filterInitialized;
    private final YoFrameQuaternion orientationFiltered;
    private final YoFrameVector3D angularVelocityFiltered;
    private final YoFrameVector3D linearAccelerationFiltered;
    private final FramePoint3D bodyFixedPoint = new FramePoint3D();
    private final FrameVector3D intermediateAcceleration = new FrameVector3D();

    public SimIMUSensor(IMUSensorDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToJoint());
        this.setSamplingRate(SimIMUSensor.toSamplingRate(definition.getUpdatePeriod()));
    }

    public SimIMUSensor(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        super(name, parentJoint, transformToParent);
        ReferenceFrame rootFrame = parentJoint.getFrameAfterJoint().getRootFrame();
        YoRegistry registry = parentJoint.getRegistry();
        this.orientation = new YoFrameQuaternion(name + "Orientation", rootFrame, registry);
        this.angularVelocity = new YoFrameVector3D(name + "AngularVelocity", (ReferenceFrame)this.getFrame(), registry);
        this.linearAcceleration = new YoFrameVector3D(name + "LinearAcceleration", (ReferenceFrame)this.getFrame(), registry);
        this.filterBreakFrequency = new YoDouble(name + "FilterBreakFrequency", registry);
        this.filterBreakFrequency.set(Double.POSITIVE_INFINITY);
        this.getSamplingRate().addListener(v -> this.filterBreakFrequency.set(this.getSamplingRate().getValue() * 0.25));
        this.filterInitialized = new YoBoolean(name + "FilterInitialized", registry);
        this.orientationFiltered = new YoFrameQuaternion(name + "OrientationFiltered", rootFrame, registry);
        this.angularVelocityFiltered = new YoFrameVector3D(name + "AngularVelocityFiltered", (ReferenceFrame)this.getFrame(), registry);
        this.linearAccelerationFiltered = new YoFrameVector3D(name + "LinearAccelerationFiltered", (ReferenceFrame)this.getFrame(), registry);
    }

    @Override
    public void update(RobotPhysicsOutput robotPhysicsOutput) {
        super.update(robotPhysicsOutput);
        this.orientation.setFromReferenceFrame((ReferenceFrame)this.getFrame());
        this.angularVelocity.set((FrameTuple3DReadOnly)this.getFrame().getTwistOfFrame().getAngularPart());
        double dt = robotPhysicsOutput.getDT();
        RigidBodyTwistProvider deltaTwistProvider = robotPhysicsOutput.getDeltaTwistProvider();
        RigidBodyAccelerationProvider accelerationProvider = robotPhysicsOutput.getAccelerationProvider();
        SimRigidBodyBasics body = this.getParentJoint().getSuccessor();
        MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
        this.bodyFixedPoint.setIncludingFrame((FrameTuple3DReadOnly)this.getOffset().getPosition());
        this.bodyFixedPoint.changeFrame((ReferenceFrame)bodyFrame);
        accelerationProvider.getAccelerationOfBody((RigidBodyReadOnly)body).getLinearAccelerationAt(bodyFrame.getTwistOfFrame(), (FramePoint3DReadOnly)this.bodyFixedPoint, (FrameVector3DBasics)this.intermediateAcceleration);
        if (dt != 0.0 && deltaTwistProvider != null) {
            this.intermediateAcceleration.scaleAdd(1.0 / dt, (FrameTuple3DReadOnly)deltaTwistProvider.getLinearVelocityOfBodyFixedPoint((RigidBodyReadOnly)body, (FramePoint3DReadOnly)this.bodyFixedPoint), (FrameTuple3DReadOnly)this.intermediateAcceleration);
        }
        this.linearAcceleration.setMatchingFrame((FrameTuple3DReadOnly)this.intermediateAcceleration);
        if (dt <= 0.0) {
            this.filterInitialized.set(false);
        }
        if (!this.filterInitialized.getValue()) {
            this.orientationFiltered.set((FrameQuaternionReadOnly)this.orientation);
            this.angularVelocityFiltered.set((FrameTuple3DReadOnly)this.angularVelocity);
            this.linearAccelerationFiltered.set((FrameTuple3DReadOnly)this.linearAcceleration);
            this.filterInitialized.set(true);
        } else {
            if (Double.isInfinite(this.filterBreakFrequency.getValue())) {
                this.filterBreakFrequency.set(0.25 / dt);
            }
            double alpha = 1.0 - SimIMUSensor.computeLowPassFilterAlpha(this.filterBreakFrequency.getValue(), dt);
            this.orientationFiltered.interpolate((FrameQuaternionReadOnly)this.orientation, alpha);
            this.angularVelocityFiltered.interpolate((FrameTuple3DReadOnly)this.angularVelocity, alpha);
            this.linearAccelerationFiltered.interpolate((FrameTuple3DReadOnly)this.linearAcceleration, alpha);
        }
    }

    public void setFilterBreakFrequency(double breakFrequency) {
        this.filterBreakFrequency.set(breakFrequency);
    }

    public YoFrameQuaternion getOrientation() {
        return this.orientation;
    }

    public YoFrameVector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    public YoFrameVector3D getLinearAcceleration() {
        return this.linearAcceleration;
    }

    public YoDouble getFilterBreakFrequency() {
        return this.filterBreakFrequency;
    }

    public YoBoolean getFilterInitialized() {
        return this.filterInitialized;
    }

    public YoFrameQuaternion getOrientationFiltered() {
        return this.orientationFiltered;
    }

    public YoFrameVector3D getAngularVelocityFiltered() {
        return this.angularVelocityFiltered;
    }

    public YoFrameVector3D getLinearAccelerationFiltered() {
        return this.linearAccelerationFiltered;
    }
}

