/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.trackers;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.trackers.ExternalWrenchPoint;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class GroundContactPoint
extends ExternalWrenchPoint {
    private final YoFramePose3D touchdownPose;
    private final YoFrameVector3D contactNormal;
    private final YoBoolean inContact;
    private final YoBoolean isSlipping;

    public GroundContactPoint(KinematicPointDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public GroundContactPoint(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        super(name, parentJoint, transformToParent);
        ReferenceFrame rootFrame = parentJoint.getFrameAfterJoint().getRootFrame();
        YoRegistry registry = parentJoint.getRegistry();
        this.touchdownPose = new YoFramePose3D(name + "Touchdown", rootFrame, registry);
        this.contactNormal = new YoFrameVector3D(name + "ContactNormal", rootFrame, registry);
        this.inContact = new YoBoolean(name + "InContact", registry);
        this.isSlipping = new YoBoolean(name + "IsSlipping", registry);
    }

    public YoFramePose3D getTouchdownPose() {
        return this.touchdownPose;
    }

    public YoFrameVector3D getContactNormal() {
        return this.contactNormal;
    }

    public YoBoolean getInContact() {
        return this.inContact;
    }

    public YoBoolean getIsSlipping() {
        return this.isSlipping;
    }
}

