/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoSixDoFJoint;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.simulation.robot.SimJointAuxiliaryData;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimSixDoFJoint
extends YoSixDoFJoint
implements SimJointBasics,
SimFloatingJointBasics {
    private final YoRegistry registry;
    private final SimJointAuxiliaryData auxiliaryData;
    private final FixedFrameTwistBasics jointDeltaTwist;
    private final YoBoolean isPinned;

    public SimSixDoFJoint(SixDoFJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public SimSixDoFJoint(String name, SimRigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public SimSixDoFJoint(String name, SimRigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, (RigidBodyBasics)predecessor, transformToParent, predecessor.getRegistry());
        this.registry = predecessor.getRegistry();
        this.auxiliaryData = new SimJointAuxiliaryData(this);
        Object varName = !name.isEmpty() ? "_" + name + "_" : "_";
        this.jointDeltaTwist = new YoFixedFrameTwist((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, new YoFrameVector3D("qd_delta" + (String)varName + "w", (ReferenceFrame)this.afterJointFrame, this.registry), new YoFrameVector3D("qd_delta" + (String)varName, (ReferenceFrame)this.afterJointFrame, this.registry));
        this.isPinned = new YoBoolean("is" + (String)varName + "pinned", this.registry);
        this.getJointPose().getOrientation().attachVariableChangedListener(v -> {
            if (!Double.isFinite(((YoDouble)v).getValue())) {
                throw new IllegalStateException("Invalid joint configuration: " + this.getJointPose());
            }
        });
        this.getJointPose().getPosition().attachVariableChangedListener(v -> {
            if (Double.isNaN(((YoDouble)v).getValue())) {
                throw new IllegalStateException("Invalid joint configuration: " + this.getJointPose());
            }
        });
        this.getJointTwist().getAngularPart().attachVariableChangedListener(v -> {
            if (!Double.isFinite(((YoDouble)v).getValue())) {
                throw new IllegalStateException("Invalid joint twist: " + this.getJointTwist());
            }
        });
        this.getJointTwist().getLinearPart().attachVariableChangedListener(v -> {
            if (!Double.isFinite(((YoDouble)v).getValue())) {
                throw new IllegalStateException("Invalid joint twist: " + this.getJointTwist());
            }
        });
        this.getJointAcceleration().getAngularPart().attachVariableChangedListener(v -> {
            if (!Double.isFinite(((YoDouble)v).getValue())) {
                throw new IllegalStateException("Invalid joint acceleration: " + this.getJointAcceleration());
            }
        });
        this.getJointAcceleration().getLinearPart().attachVariableChangedListener(v -> {
            if (!Double.isFinite(((YoDouble)v).getValue())) {
                throw new IllegalStateException("Invalid joint acceleration: " + this.getJointAcceleration());
            }
        });
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public SimJointAuxiliaryData getAuxiliaryData() {
        return this.auxiliaryData;
    }

    public void setSuccessor(RigidBodyBasics successor) {
        if (!(successor instanceof SimRigidBodyBasics)) {
            throw new IllegalArgumentException("Can only set a " + SimRigidBodyBasics.class.getSimpleName() + " as successor of a " + this.getClass().getSimpleName());
        }
        super.setSuccessor(successor);
    }

    @Override
    public SimRigidBodyBasics getPredecessor() {
        return (SimRigidBodyBasics)super.getPredecessor();
    }

    @Override
    public SimRigidBodyBasics getSuccessor() {
        return (SimRigidBodyBasics)super.getSuccessor();
    }

    @Override
    public void resetState() {
        this.getJointPose().setToZero();
        this.getJointTwist().setToZero();
        this.getJointDeltaTwist().setToZero();
        this.getJointAcceleration().setToZero();
        this.getJointWrench().setToZero();
    }

    @Override
    public FixedFrameTwistBasics getJointDeltaTwist() {
        return this.jointDeltaTwist;
    }

    @Override
    public int getJointDeltaVelocity(int rowStart, DMatrix matrixToPack) {
        this.getJointTwist().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setJointDeltaTwist(JointReadOnly other) {
        this.setJointDeltaTwist((SimSixDoFJoint)MecanoTools.checkTypeAndCast((JointReadOnly)other, SimSixDoFJoint.class));
    }

    public void setJointDeltaTwist(SimSixDoFJoint other) {
        FixedFrameVector3DBasics otherAngularDeltaVelocity = other.getJointDeltaTwist().getAngularPart();
        FixedFrameVector3DBasics otherLinearDeltaVelocity = other.getJointDeltaTwist().getLinearPart();
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)otherAngularDeltaVelocity);
        this.setJointLinearDeltaVelocity((Vector3DReadOnly)otherLinearDeltaVelocity);
    }

    @Override
    public int setJointDeltaVelocity(int rowStart, DMatrix matrix) {
        this.getJointDeltaTwist().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setPinned(boolean isPinned) {
        this.isPinned.set(isPinned);
    }

    @Override
    public boolean isPinned() {
        return this.isPinned.getValue();
    }
}

