/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;

public class RigidBodyWrenchRegistry
implements Function<RigidBodyReadOnly, WrenchReadOnly> {
    private final Map<RigidBodyReadOnly, Wrench> rigidBodyWrenchMap = new HashMap<RigidBodyReadOnly, Wrench>();
    private final List<Wrench> wrenchCache = new ArrayList<Wrench>();
    private final Function<RigidBodyReadOnly, Wrench> wrenchFactory = body -> {
        Wrench wrench = new Wrench((ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame());
        this.wrenchCache.add(wrench);
        return wrench;
    };

    public void reset() {
        for (int i = 0; i < this.wrenchCache.size(); ++i) {
            this.wrenchCache.get(i).setToZero();
        }
    }

    public void addWrench(RigidBodyReadOnly target, WrenchReadOnly wrenchToAdd) {
        Wrench wrench = this.rigidBodyWrenchMap.computeIfAbsent(target, this.wrenchFactory);
        wrench.setMatchingFrame(wrenchToAdd);
    }

    @Override
    public WrenchReadOnly apply(RigidBodyReadOnly query) {
        return (WrenchReadOnly)this.rigidBodyWrenchMap.get(query);
    }
}

