/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoPlanarJoint;
import us.ihmc.mecano.yoVariables.tools.YoMecanoFactories;
import us.ihmc.scs2.definition.robot.PlanarJointDefinition;
import us.ihmc.scs2.simulation.robot.SimJointAuxiliaryData;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimPlanarJoint
extends YoPlanarJoint
implements SimJointBasics,
SimFloatingJointBasics {
    private final YoRegistry registry;
    private final SimJointAuxiliaryData auxiliaryData;
    private final FixedFrameTwistBasics jointDeltaTwist;
    private final YoBoolean isPinned;

    public SimPlanarJoint(PlanarJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public SimPlanarJoint(String name, SimRigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public SimPlanarJoint(String name, SimRigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, (RigidBodyBasics)predecessor, transformToParent, predecessor.getRegistry());
        this.registry = predecessor.getRegistry();
        this.auxiliaryData = new SimJointAuxiliaryData(this);
        Object varName = !name.isEmpty() ? "_" + name + "_" : "_";
        YoDouble angularDeltaVelocityY = new YoDouble("qd_delta" + (String)varName + "wy", this.registry);
        YoDouble linearDeltaVelocityX = new YoDouble("qd_delta" + (String)varName + "x", this.registry);
        YoDouble linearDeltaVelocityZ = new YoDouble("qd_delta" + (String)varName + "z", this.registry);
        this.jointDeltaTwist = YoMecanoFactories.newPlanarYoFixedFrameTwistBasics((YoDouble)angularDeltaVelocityY, (YoDouble)linearDeltaVelocityX, (YoDouble)linearDeltaVelocityZ, (ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
        this.isPinned = new YoBoolean("is" + (String)varName + "pinned", this.registry);
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public SimJointAuxiliaryData getAuxiliaryData() {
        return this.auxiliaryData;
    }

    public void setSuccessor(RigidBodyBasics successor) {
        if (!(successor instanceof SimRigidBodyBasics)) {
            throw new IllegalArgumentException("Can only set a " + SimRigidBodyBasics.class.getSimpleName() + " as successor of a " + this.getClass().getSimpleName());
        }
        super.setSuccessor(successor);
    }

    @Override
    public SimRigidBodyBasics getPredecessor() {
        return (SimRigidBodyBasics)super.getPredecessor();
    }

    @Override
    public SimRigidBodyBasics getSuccessor() {
        return (SimRigidBodyBasics)super.getSuccessor();
    }

    @Override
    public FixedFrameTwistBasics getJointDeltaTwist() {
        return this.jointDeltaTwist;
    }

    @Override
    public int getJointDeltaVelocity(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart + 0, 0, this.getJointTwist().getAngularPartY());
        matrixToPack.set(rowStart + 1, 0, this.getJointTwist().getLinearPartX());
        matrixToPack.set(rowStart + 2, 0, this.getJointTwist().getLinearPartZ());
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setJointDeltaTwist(JointReadOnly other) {
        this.setJointDeltaTwist((SimPlanarJoint)MecanoTools.checkTypeAndCast((JointReadOnly)other, SimPlanarJoint.class));
    }

    public void setJointDeltaTwist(SimPlanarJoint other) {
        FixedFrameVector3DBasics otherAngularDeltaVelocity = other.getJointDeltaTwist().getAngularPart();
        FixedFrameVector3DBasics otherLinearDeltaVelocity = other.getJointDeltaTwist().getLinearPart();
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)otherAngularDeltaVelocity);
        this.setJointLinearDeltaVelocity((Vector3DReadOnly)otherLinearDeltaVelocity);
    }

    @Override
    public int setJointDeltaVelocity(int rowStart, DMatrix matrix) {
        int index = rowStart;
        double qdRot = matrix.get(index++, 0);
        double xd = matrix.get(index++, 0);
        double zd = matrix.get(index++, 0);
        this.getJointDeltaTwist().setToZero();
        this.getJointDeltaTwist().setAngularPartY(qdRot);
        this.getJointDeltaTwist().getLinearPart().set(xd, 0.0, zd);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setPinned(boolean isPinned) {
        this.isPinned.set(isPinned);
    }

    @Override
    public boolean isPinned() {
        return this.isPinned.getValue();
    }
}

