/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;

public class RigidBodyWrenchRegistry
implements Function<RigidBodyReadOnly, WrenchReadOnly> {
    private final Map<RigidBodyReadOnly, Wrench> rigidBodyWrenchMap = new HashMap<RigidBodyReadOnly, Wrench>();
    private final Function<RigidBodyReadOnly, Wrench> wrenchFactory = body -> new Wrench((ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame());

    public void reset() {
        this.rigidBodyWrenchMap.clear();
    }

    public void addWrench(RigidBodyReadOnly target, WrenchReadOnly wrenchToAdd) {
        Wrench wrench = this.rigidBodyWrenchMap.computeIfAbsent(target, this.wrenchFactory);
        wrench.setMatchingFrame(wrenchToAdd);
    }

    @Override
    public WrenchReadOnly apply(RigidBodyReadOnly query) {
        return (WrenchReadOnly)this.rigidBodyWrenchMap.get(query);
    }
}

