/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Iterator;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameUnitVector3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollidableHolder;
import us.ihmc.scs2.simulation.collision.CollisionListResult;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.collision.PhysicsEngineTools;

public class SimpleCollisionDetection {
    private final ReferenceFrame rootFrame;
    private double minimumPenetration = 5.0E-5;
    private final CollisionListResult allCollisions = new CollisionListResult();
    private final TIntObjectMap<CollisionListResult> previousCollisionMap = new TIntObjectHashMap();

    public SimpleCollisionDetection(ReferenceFrame rootFrame) {
        this.rootFrame = rootFrame;
    }

    public void setMinimumPenetration(double minimumPenetration) {
        this.minimumPenetration = minimumPenetration;
    }

    public CollisionListResult evaluationCollisions(List<? extends CollidableHolder> dynamicCollidableHolders, CollidableHolder staticCollidableHolder, double dt) {
        this.allCollisions.clear();
        for (int i = 0; i < dynamicCollidableHolders.size(); ++i) {
            int j;
            CollidableHolder dynamicCollidableHolder = dynamicCollidableHolders.get(i);
            CollisionListResult collisionResults = new CollisionListResult();
            List<Collidable> dynamicCollidables = dynamicCollidableHolder.getCollidables();
            for (j = 0; j < dynamicCollidables.size(); ++j) {
                Collidable collidableA = dynamicCollidables.get(j);
                for (int k = j + 1; k < dynamicCollidables.size(); ++k) {
                    Collidable collidableB = dynamicCollidables.get(k);
                    this.evaluateCollision(collidableA, collidableB, collisionResults, dt);
                }
            }
            for (Collidable collidableRigidBody : dynamicCollidables) {
                for (Collidable staticCollidable : staticCollidableHolder.getCollidables()) {
                    this.evaluateCollision(collidableRigidBody, staticCollidable, collisionResults, dt);
                }
            }
            for (j = i + 1; j < dynamicCollidableHolders.size(); ++j) {
                CollidableHolder otherDynamicCollidableHolder = dynamicCollidableHolders.get(j);
                for (Collidable collidableRigidBody : dynamicCollidables) {
                    for (Collidable otherCollidableRigidBody : otherDynamicCollidableHolder.getCollidables()) {
                        this.evaluateCollision(collidableRigidBody, otherCollidableRigidBody, collisionResults, dt);
                    }
                }
            }
        }
        return this.allCollisions;
    }

    private void evaluateCollision(Collidable collidableA, Collidable collidableB, CollisionListResult collisionListResultToPack, double dt) {
        if (!collidableA.isCollidableWith(collidableB)) {
            return;
        }
        CollisionResult collision = this.pollCollision(collidableA, collidableB);
        collidableA.evaluateCollision(dt, collidableB, collision);
        if (!collision.getCollisionData().areShapesColliding()) {
            return;
        }
        boolean success = this.postCollisionDetection(collision);
        if (success) {
            this.allCollisions.add(collision);
            collisionListResultToPack.add(collision);
            this.registerCollision(collision);
        }
    }

    private boolean postCollisionDetection(CollisionResult collisionResult) {
        EuclidFrameShape3DCollisionResult collisionData = collisionResult.getCollisionData();
        if (collisionData.getDistance() < this.minimumPenetration) {
            return false;
        }
        FramePoint3D pointOnA = collisionData.getPointOnA();
        FramePoint3D pointOnB = collisionData.getPointOnB();
        FramePoint3D pointOnARootFrame = collisionResult.getPointOnARootFrame();
        FramePoint3D pointOnBRootFrame = collisionResult.getPointOnBRootFrame();
        pointOnARootFrame.setIncludingFrame((FrameTuple3DReadOnly)pointOnA);
        pointOnBRootFrame.setIncludingFrame((FrameTuple3DReadOnly)pointOnB);
        pointOnARootFrame.changeFrame(this.rootFrame);
        pointOnBRootFrame.changeFrame(this.rootFrame);
        FrameUnitVector3D collisionAxis = collisionResult.getCollisionAxisForA();
        FrameVector3D normalOnA = collisionData.getNormalOnA();
        FrameVector3D normalOnB = collisionData.getNormalOnB();
        if (!normalOnA.containsNaN()) {
            collisionAxis.setIncludingFrame((FrameTuple3DReadOnly)normalOnA);
            collisionAxis.negate();
        } else if (!normalOnB.containsNaN()) {
            collisionAxis.setIncludingFrame((FrameTuple3DReadOnly)normalOnB);
        } else {
            collisionAxis.setReferenceFrame(this.rootFrame);
            collisionAxis.sub((FrameTuple3DReadOnly)pointOnBRootFrame, (FrameTuple3DReadOnly)pointOnARootFrame);
        }
        if (collisionAxis.containsNaN()) {
            return false;
        }
        collisionAxis.changeFrame(this.rootFrame);
        pointOnA.changeFrame(collisionData.getShapeA().getReferenceFrame());
        normalOnA.changeFrame(collisionData.getShapeA().getReferenceFrame());
        pointOnB.changeFrame(collisionData.getShapeB().getReferenceFrame());
        normalOnB.changeFrame(collisionData.getShapeB().getReferenceFrame());
        return true;
    }

    private void registerCollision(CollisionResult collision) {
        CollisionListResult previousCollisionList = (CollisionListResult)this.previousCollisionMap.get(collision.hashCode());
        if (previousCollisionList == null) {
            previousCollisionList = new CollisionListResult();
            previousCollisionList.add(collision);
            this.previousCollisionMap.put(collision.hashCode(), (Object)previousCollisionList);
        } else {
            previousCollisionList.add(collision);
        }
    }

    private CollisionResult pollCollision(Collidable collidableA, Collidable collidableB) {
        int collisionID = PhysicsEngineTools.computeCollisionHashCode(collidableA, collidableB);
        CollisionListResult previousCollisionList = (CollisionListResult)this.previousCollisionMap.get(collisionID);
        if (previousCollisionList == null) {
            return this.newCollisionResult(collidableA, collidableB, collisionID);
        }
        Iterator<CollisionResult> iterator = previousCollisionList.iterator();
        while (iterator.hasNext()) {
            CollisionResult candidate = iterator.next();
            if (!candidate.isCollisionOf(collidableA, collidableB)) continue;
            iterator.remove();
            if (previousCollisionList.isEmpty()) {
                this.previousCollisionMap.remove(collisionID);
            }
            if (candidate.getCollidableA() != collidableA) {
                candidate.swapCollidables();
            }
            return candidate;
        }
        return this.newCollisionResult(collidableA, collidableB, collisionID);
    }

    private CollisionResult newCollisionResult(Collidable collidableA, Collidable collidableB, int collisionID) {
        CollisionResult collisionResult = new CollisionResult();
        collisionResult.setCollidableA(collidableA);
        collisionResult.setCollidableB(collidableB);
        collisionResult.setCollisionID(collisionID);
        return collisionResult;
    }

    public CollisionListResult getAllCollisions() {
        return this.allCollisions;
    }
}

