/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.contactPointBased;

import java.util.List;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.FrameShapePosePredictor;
import us.ihmc.scs2.simulation.physicsEngine.contactPointBased.RobotOneDoFJointSoftLimitCalculator;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.controller.RobotOneDoFJointDampingCalculator;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;
import us.ihmc.scs2.simulation.screwTools.SingleRobotFirstOrderIntegrator;

public class ContactPointBasedRobotPhysics {
    private final RobotInterface owner;
    private final ReferenceFrame inertialFrame;
    private final RobotOneDoFJointDampingCalculator robotOneDoFJointDampingCalculator;
    private final RobotOneDoFJointSoftLimitCalculator robotOneDoFJointSoftLimitCalculator;
    private final RigidBodyWrenchRegistry rigidBodyWrenchRegistry = new RigidBodyWrenchRegistry();
    private final List<Collidable> collidables;
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;
    private final SingleRobotFirstOrderIntegrator integrator;
    private final RobotPhysicsOutput physicsOutput;

    public ContactPointBasedRobotPhysics(RobotInterface owner) {
        this.owner = owner;
        this.inertialFrame = owner.getInertialFrame();
        this.robotOneDoFJointDampingCalculator = new RobotOneDoFJointDampingCalculator(owner);
        owner.getRegistry().addChild(this.robotOneDoFJointDampingCalculator.getRegistry());
        this.robotOneDoFJointSoftLimitCalculator = new RobotOneDoFJointSoftLimitCalculator(owner);
        owner.getRegistry().addChild(this.robotOneDoFJointSoftLimitCalculator.getRegistry());
        SimRigidBodyBasics rootBody = owner.getRootBody();
        this.collidables = rootBody.subtreeStream().flatMap(body -> body.getCollidables().stream()).collect(Collectors.toList());
        this.forwardDynamicsCalculator = new ForwardDynamicsCalculator((MultiBodySystemReadOnly)owner);
        FrameShapePosePredictor frameShapePosePredictor = new FrameShapePosePredictor(this.forwardDynamicsCalculator);
        this.collidables.forEach(collidable -> collidable.setFrameShapePosePredictor(frameShapePosePredictor));
        this.integrator = new SingleRobotFirstOrderIntegrator();
        this.physicsOutput = new RobotPhysicsOutput(this.forwardDynamicsCalculator.getAccelerationProvider(), null, this.rigidBodyWrenchRegistry, null);
    }

    public void resetCalculators() {
        this.forwardDynamicsCalculator.setExternalWrenchesToZero();
        this.rigidBodyWrenchRegistry.reset();
    }

    public void computeJointDamping() {
        this.robotOneDoFJointDampingCalculator.compute();
    }

    public void computeJointSoftLimits() {
        this.robotOneDoFJointSoftLimitCalculator.compute();
    }

    public void addRigidBodyExternalWrench(RigidBodyReadOnly target, WrenchReadOnly wrenchToAdd) {
        this.rigidBodyWrenchRegistry.addWrench(target, wrenchToAdd);
    }

    public void updateCollidableBoundingBoxes() {
        this.collidables.forEach(collidable -> collidable.updateBoundingBox(this.inertialFrame));
    }

    public List<Collidable> getCollidables() {
        return this.collidables;
    }

    public ForwardDynamicsCalculator getForwardDynamicsCalculator() {
        return this.forwardDynamicsCalculator;
    }

    public void doForwardDynamics(Vector3DReadOnly gravity) {
        this.forwardDynamicsCalculator.setGravitionalAcceleration((Tuple3DReadOnly)gravity);
        this.forwardDynamicsCalculator.setJointSourceModes(joint -> {
            SimJointBasics simJoint = (SimJointBasics)joint;
            if (simJoint.isPinned()) {
                simJoint.setJointTwistToZero();
                simJoint.setJointAccelerationToZero();
            }
            return simJoint.isPinned() ? ForwardDynamicsCalculator.JointSourceMode.ACCELERATION_SOURCE : ForwardDynamicsCalculator.JointSourceMode.EFFORT_SOURCE;
        });
        this.forwardDynamicsCalculator.compute();
    }

    public void writeJointAccelerations() {
        List<? extends SimJointBasics> joints = this.owner.getJointsToConsider();
        DMatrixRMaj jointAccelerationMatrix = this.forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj jointTauMatrix = this.forwardDynamicsCalculator.getJointTauMatrix();
        int startIndex = 0;
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            SimJointBasics joint = joints.get(jointIndex);
            startIndex = !joint.isPinned() ? joint.setJointAcceleration(startIndex, (DMatrix)jointAccelerationMatrix) : joint.setJointTau(startIndex, (DMatrix)jointTauMatrix);
        }
    }

    public void integrateState(double dt) {
        this.physicsOutput.setDT(dt);
        this.integrator.integrate(dt, this.owner);
    }

    public RobotPhysicsOutput getPhysicsOutput() {
        return this.physicsOutput;
    }
}

