/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimCameraSensor;
import us.ihmc.scs2.simulation.robot.sensors.SimIMUSensor;
import us.ihmc.scs2.simulation.robot.sensors.SimWrenchSensor;
import us.ihmc.scs2.simulation.robot.trackers.ExternalWrenchPoint;
import us.ihmc.scs2.simulation.robot.trackers.GroundContactPoint;
import us.ihmc.scs2.simulation.robot.trackers.KinematicPoint;

public class SimJointAuxiliaryData {
    private final SimJointBasics joint;
    private final List<KinematicPoint> kinematicPoints = new ArrayList<KinematicPoint>();
    private final List<ExternalWrenchPoint> externalWrenchPoints = new ArrayList<ExternalWrenchPoint>();
    private final List<GroundContactPoint> groundContactPoints = new ArrayList<GroundContactPoint>();
    private final List<SimIMUSensor> imuSensors = new ArrayList<SimIMUSensor>();
    private final List<SimWrenchSensor> wrenchSensors = new ArrayList<SimWrenchSensor>();
    private final List<SimCameraSensor> cameraSensors = new ArrayList<SimCameraSensor>();

    public SimJointAuxiliaryData(SimJointBasics joint) {
        this.joint = joint;
    }

    public void update(RobotPhysicsOutput physicsOutput) {
        this.kinematicPoints.forEach(kp -> kp.update());
        this.externalWrenchPoints.forEach(ewp -> ewp.update());
        this.groundContactPoints.forEach(gcp -> gcp.update());
        this.imuSensors.forEach(imu -> imu.update(physicsOutput));
        this.wrenchSensors.forEach(wrench -> wrench.update(physicsOutput));
        this.cameraSensors.forEach(camera -> camera.update(physicsOutput));
    }

    public KinematicPoint addKinematicPoint(KinematicPointDefinition definition) {
        KinematicPoint kinematicPoint = new KinematicPoint(definition, this.joint);
        this.kinematicPoints.add(kinematicPoint);
        return kinematicPoint;
    }

    public ExternalWrenchPoint addExternalWrenchPoint(ExternalWrenchPointDefinition definition) {
        ExternalWrenchPoint externalWrenchPoint = new ExternalWrenchPoint((KinematicPointDefinition)definition, this.joint);
        this.externalWrenchPoints.add(externalWrenchPoint);
        return externalWrenchPoint;
    }

    public GroundContactPoint addGroundContactPoint(GroundContactPointDefinition definition) {
        GroundContactPoint groundContactPoint = new GroundContactPoint((KinematicPointDefinition)definition, this.joint);
        this.groundContactPoints.add(groundContactPoint);
        return groundContactPoint;
    }

    public SimIMUSensor addIMUSensor(IMUSensorDefinition definition) {
        SimIMUSensor newSensor = new SimIMUSensor(definition, this.joint);
        this.imuSensors.add(newSensor);
        return newSensor;
    }

    public SimWrenchSensor addWrenchSensor(WrenchSensorDefinition definition) {
        SimWrenchSensor newSensor = new SimWrenchSensor(definition, this.joint);
        this.wrenchSensors.add(newSensor);
        return newSensor;
    }

    public SimCameraSensor addCameraSensor(CameraSensorDefinition definition) {
        SimCameraSensor newSensor = new SimCameraSensor(definition, this.joint);
        this.cameraSensors.add(newSensor);
        return newSensor;
    }

    public SimJointBasics getJoint() {
        return this.joint;
    }

    public List<KinematicPoint> getKinematicPoints() {
        return this.kinematicPoints;
    }

    public List<ExternalWrenchPoint> getExternalWrenchPoints() {
        return this.externalWrenchPoints;
    }

    public List<GroundContactPoint> getGroundContactPoints() {
        return this.groundContactPoints;
    }

    public List<SimIMUSensor> getIMUSensors() {
        return this.imuSensors;
    }

    public List<SimWrenchSensor> getWrenchSensors() {
        return this.wrenchSensors;
    }

    public List<SimCameraSensor> getCameraSensors() {
        return this.cameraSensors;
    }
}

