/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.state;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.SphericalJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.SphericalJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SphericalJointStateReadOnly;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSphericalJointState
implements SphericalJointStateBasics {
    private final YoQuaternion orientation;
    private final YoVector3D angularVelocity;
    private final YoVector3D angularAcceleration;
    private final YoVector3D torque;
    private final DMatrixRMaj temp = new DMatrixRMaj(4, 1);

    public YoSphericalJointState(String namePrefix, String nameSuffix, YoRegistry registry) {
        if (namePrefix == null) {
            namePrefix = "";
        } else if (!namePrefix.isEmpty() && !namePrefix.endsWith("_")) {
            namePrefix = namePrefix + "_";
        }
        if (nameSuffix == null) {
            nameSuffix = "";
        } else if (!nameSuffix.isEmpty() && !nameSuffix.startsWith("_")) {
            nameSuffix = "_" + nameSuffix;
        }
        this.orientation = new YoQuaternion(namePrefix + "q_", nameSuffix, registry);
        this.angularVelocity = new YoVector3D(namePrefix + "qd_w", nameSuffix, registry);
        this.angularAcceleration = new YoVector3D(namePrefix + "qdd_w", nameSuffix, registry);
        this.torque = new YoVector3D(namePrefix + "tau_w", nameSuffix, registry);
    }

    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof SphericalJointStateReadOnly) {
            super.set((SphericalJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            } else {
                this.orientation.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            } else {
                this.angularVelocity.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            } else {
                this.angularAcceleration.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            } else {
                this.torque.setToNaN();
            }
        }
    }

    public SphericalJointState copy() {
        return new SphericalJointState((JointStateReadOnly)this);
    }

    public YoQuaternion getOrientation() {
        return this.orientation;
    }

    public YoVector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    public YoVector3D getAngularAcceleration() {
        return this.angularAcceleration;
    }

    public YoVector3D getTorque() {
        return this.torque;
    }

    public String toString() {
        String ret = "Spherical joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = ret + ", orientaiton: " + this.orientation.toStringAsYawPitchRoll();
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = ret + ", angular velocity: " + this.angularVelocity;
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = ret + ", angular acceleration: " + this.angularAcceleration;
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = ret + ", torque: " + this.torque;
        }
        return ret;
    }
}

