/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.controller;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.controller.interfaces.ControllerDefinition;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.simulation.robot.controller.SimControllerInput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimMultiBodySystemBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RobotControllerManager {
    private final YoRegistry registry;
    private final SimControllerInput controllerInput;
    private final ControllerOutput controllerOutput;
    private final List<Controller> controllers = new ArrayList<Controller>();
    private final SimMultiBodySystemBasics input;

    public RobotControllerManager(SimMultiBodySystemBasics input, YoRegistry registry) {
        this.input = input;
        this.registry = registry;
        this.controllerInput = new SimControllerInput(input);
        this.controllerOutput = new ControllerOutput((MultiBodySystemReadOnly)input);
    }

    public SimControllerInput getControllerInput() {
        return this.controllerInput;
    }

    public ControllerOutput getControllerOutput() {
        return this.controllerOutput;
    }

    public void addController(Controller controller) {
        if (this.controllers.add(controller)) {
            this.registry.addChild(controller.getYoRegistry());
        }
    }

    public void addController(ControllerDefinition controllerDefinition) {
        this.addController(controllerDefinition.newController((ControllerInput)this.controllerInput, this.controllerOutput));
    }

    public void initializeControllers() {
        this.controllerInput.setTime(0.0);
        for (Controller controller : this.controllers) {
            controller.initialize();
        }
    }

    public void updateControllers(double time) {
        this.controllerInput.setTime(time);
        for (Controller controller : this.controllers) {
            controller.doControl();
        }
    }

    public void pauseControllers() {
        for (Controller controller : this.controllers) {
            controller.pause();
        }
    }

    public void writeControllerOutput(JointStateType ... statesToWrite) {
        for (JointStateType stateToWrite : statesToWrite) {
            this.writeControllerOutput(stateToWrite);
        }
    }

    public void writeControllerOutput(JointStateType stateToWrite) {
        for (JointBasics jointBasics : this.input.getJointsToConsider()) {
            JointStateBasics jointOutput = this.controllerOutput.getJointOutput((JointReadOnly)jointBasics);
            if (!jointOutput.hasOutputFor(stateToWrite)) continue;
            if (stateToWrite == JointStateType.CONFIGURATION) {
                jointOutput.getConfiguration(jointBasics);
                continue;
            }
            if (stateToWrite == JointStateType.VELOCITY) {
                jointOutput.getVelocity(jointBasics);
                continue;
            }
            if (stateToWrite == JointStateType.ACCELERATION) {
                jointOutput.getAcceleration(jointBasics);
                continue;
            }
            if (stateToWrite != JointStateType.EFFORT) continue;
            jointOutput.getEffort(jointBasics);
        }
    }

    public void writeControllerOutputForJointsToIgnore(JointStateType ... statesToWrite) {
        for (JointBasics jointBasics : this.input.getJointsToIgnore()) {
            JointStateBasics jointOutput = this.controllerOutput.getJointOutput((JointReadOnly)jointBasics);
            for (JointStateType stateToWrite : statesToWrite) {
                if (!jointOutput.hasOutputFor(stateToWrite)) continue;
                if (stateToWrite == JointStateType.CONFIGURATION) {
                    jointOutput.getConfiguration(jointBasics);
                    continue;
                }
                if (stateToWrite == JointStateType.VELOCITY) {
                    jointOutput.getVelocity(jointBasics);
                    continue;
                }
                if (stateToWrite == JointStateType.ACCELERATION) {
                    jointOutput.getAcceleration(jointBasics);
                    continue;
                }
                if (stateToWrite != JointStateType.EFFORT) continue;
                jointOutput.getEffort(jointBasics);
            }
        }
    }
}

