/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.physicsEngine.CombinedRigidBodyTwistProviders;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.SimJointStateType;
import us.ihmc.scs2.simulation.screwTools.SimMultiBodySystemRandomTools;

public class CombinedRigidBodyTwistProvidersTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testAgainstMovingReferenceFrame() {
        Random random = new Random(365754L);
        for (int i = 0; i < 1000; ++i) {
            int j;
            List jointChain = SimMultiBodySystemRandomTools.nextJointChain((Random)random, (int)10);
            SimMultiBodySystemRandomTools.nextState((Random)random, (SimJointStateType)SimJointStateType.CONFIGURATION, (Iterable)jointChain);
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((SimJointBasics)jointChain.get(0)).getPredecessor());
            int numberOfProviders = random.nextInt(10) + 1;
            int nDoFs = SubtreeStreams.fromChildren((RigidBodyBasics)rootBody).mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
            DMatrixRMaj totalJointVelocities = new DMatrixRMaj(nDoFs, 1);
            CombinedRigidBodyTwistProviders combinedRigidBodyTwistProviders = new CombinedRigidBodyTwistProviders(ReferenceFrame.getWorldFrame());
            for (j = 0; j < numberOfProviders; ++j) {
                TestHelper helper = new TestHelper(rootBody, "test" + i);
                helper.update(random);
                CommonOps_DDRM.addEquals((DMatrixD1)totalJointVelocities, (DMatrixD1)helper.jointVelocities);
                combinedRigidBodyTwistProviders.add(helper.toProvider());
            }
            MultiBodySystemTools.insertJointsState((List)jointChain, (JointStateType)JointStateType.VELOCITY, (DMatrix)totalJointVelocities);
            rootBody.updateFramesRecursively();
            for (j = 0; j < 10; ++j) {
                SimRigidBodyBasics body = ((SimJointBasics)jointChain.get(random.nextInt(jointChain.size()))).getSuccessor();
                Twist expectedTwist = new Twist((SpatialMotionReadOnly)body.getBodyFixedFrame().getTwistOfFrame());
                TwistReadOnly actualTwist = combinedRigidBodyTwistProviders.getTwistOfBody((RigidBodyReadOnly)body);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
                SimRigidBodyBasics base = ((SimJointBasics)jointChain.get(random.nextInt(jointChain.size()))).getPredecessor();
                body.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)base.getBodyFixedFrame(), (TwistBasics)expectedTwist);
                actualTwist = combinedRigidBodyTwistProviders.getRelativeTwist((RigidBodyReadOnly)base, (RigidBodyReadOnly)body);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
                FramePoint3D bodyFixedPoint = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)body.getBodyFixedFrame());
                FrameVector3D expectedLinearVelocity = new FrameVector3D();
                expectedTwist.getLinearVelocityAt((FramePoint3DReadOnly)bodyFixedPoint, (FrameVector3DBasics)expectedLinearVelocity);
                FrameVector3DReadOnly actualLinearVelocity = combinedRigidBodyTwistProviders.getLinearVelocityOfBodyFixedPoint((RigidBodyReadOnly)base, (RigidBodyReadOnly)body, (FramePoint3DReadOnly)bodyFixedPoint);
                EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expectedLinearVelocity, (FrameTuple3DReadOnly)actualLinearVelocity, (double)1.0E-12);
            }
        }
    }

    private static class TestHelper {
        private final ReferenceFrame inertialFrame;
        private final RigidBodyBasics originalRootBody;
        private final List<JointBasics> originalJoints;
        private final RigidBodyBasics cloneRootBody;
        private final List<JointBasics> cloneJoints;
        private final DMatrixRMaj jointVelocities;
        private final Map<RigidBodyBasics, RigidBodyBasics> fromOriginalToCloneMap = new HashMap<RigidBodyBasics, RigidBodyBasics>();

        public TestHelper(RigidBodyBasics rootBody, String name) {
            this.originalRootBody = rootBody;
            this.originalJoints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{this.originalRootBody}));
            this.inertialFrame = rootBody.getBodyFixedFrame().getRootFrame();
            this.cloneRootBody = MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)rootBody, (ReferenceFrame)this.inertialFrame, (String)name);
            this.cloneJoints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{this.cloneRootBody}));
            int nDoFs = SubtreeStreams.fromChildren((RigidBodyBasics)rootBody).mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
            this.jointVelocities = new DMatrixRMaj(nDoFs, 1);
            List originalRigidBodies = this.originalRootBody.subtreeList();
            List cloneRigidBodies = this.cloneRootBody.subtreeList();
            for (int i = 0; i < originalRigidBodies.size(); ++i) {
                this.fromOriginalToCloneMap.put((RigidBodyBasics)originalRigidBodies.get(i), (RigidBodyBasics)cloneRigidBodies.get(i));
            }
        }

        public void update(Random random) {
            MultiBodySystemTools.copyJointsState(this.originalJoints, this.cloneJoints, (JointStateType)JointStateType.CONFIGURATION);
            for (int i = 0; i < this.jointVelocities.getNumElements(); ++i) {
                this.jointVelocities.data[i] = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            }
            MultiBodySystemTools.insertJointsState(this.cloneJoints, (JointStateType)JointStateType.VELOCITY, (DMatrix)this.jointVelocities);
            this.cloneRootBody.updateFramesRecursively();
        }

        public RigidBodyTwistProvider toProvider() {
            Twist twist = new Twist();
            return RigidBodyTwistProvider.toRigidBodyTwistProvider(body -> {
                twist.setIncludingFrame((SpatialMotionReadOnly)this.fromOriginalToCloneMap.get(body).getBodyFixedFrame().getTwistOfFrame());
                twist.setReferenceFrame((ReferenceFrame)body.getBodyFixedFrame());
                twist.setBodyFrame((ReferenceFrame)body.getBodyFixedFrame());
                return twist;
            }, (ReferenceFrame)this.inertialFrame);
        }
    }
}

