/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.screwTools.SingleRobotFirstOrderIntegrator;

public class SingleRobotFirstOrderIntegratorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testAgainstMecanoIntegrator() {
        Random random = new Random(3465467567L);
        for (int i = 0; i < 1000; ++i) {
            double dt = random.nextDouble();
            MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain robotOriginal = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, 20);
            MultiBodySystemBasics robotClone = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)robotOriginal.getElevator()), (ReferenceFrame)worldFrame);
            MultiBodySystemStateIntegrator mecanoIntegrator = new MultiBodySystemStateIntegrator(dt);
            SingleRobotFirstOrderIntegrator integrator = new SingleRobotFirstOrderIntegrator();
            for (JointStateType stateSelection : Arrays.asList(JointStateType.CONFIGURATION, JointStateType.VELOCITY, JointStateType.ACCELERATION)) {
                robotOriginal.nextState(random, new JointStateType[]{stateSelection});
                MultiBodySystemTools.copyJointsState((List)robotOriginal.getJoints(), (List)robotClone.getAllJoints(), (JointStateType)stateSelection);
            }
            mecanoIntegrator.doubleIntegrateFromAccelerationSubtree((RigidBodyBasics)robotOriginal.getElevator());
            integrator.integrate(dt, null, robotClone);
            for (int jointIndex = 0; jointIndex < robotOriginal.getJoints().size(); ++jointIndex) {
                JointBasics originalJoint = (JointBasics)robotOriginal.getJoints().get(jointIndex);
                JointBasics cloneJoint = (JointBasics)robotClone.getAllJoints().get(jointIndex);
                if (originalJoint instanceof FloatingJointBasics) {
                    FloatingJointBasics originalFloatingJoint = (FloatingJointBasics)originalJoint;
                    FloatingJointBasics cloneFloatingJoint = (FloatingJointBasics)cloneJoint;
                    EuclidGeometryTestTools.assertPose3DEquals((Pose3DReadOnly)originalFloatingJoint.getJointPose(), (Pose3DReadOnly)cloneFloatingJoint.getJointPose(), (double)1.0E-12);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)originalFloatingJoint.getJointTwist().getAngularPart(), (Tuple3DReadOnly)cloneFloatingJoint.getJointTwist().getAngularPart(), (double)1.0E-12);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)originalFloatingJoint.getJointTwist().getLinearPart(), (Tuple3DReadOnly)cloneFloatingJoint.getJointTwist().getLinearPart(), (double)1.0E-12);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)originalFloatingJoint.getJointAcceleration().getAngularPart(), (Tuple3DReadOnly)cloneFloatingJoint.getJointAcceleration().getAngularPart(), (double)1.0E-12);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)originalFloatingJoint.getJointAcceleration().getLinearPart(), (Tuple3DReadOnly)cloneFloatingJoint.getJointAcceleration().getLinearPart(), (double)1.0E-12);
                    continue;
                }
                OneDoFJointBasics originalOneDoFJoint = (OneDoFJointBasics)originalJoint;
                OneDoFJointBasics cloneOneDoFJoint = (OneDoFJointBasics)cloneJoint;
                Assertions.assertEquals((double)originalOneDoFJoint.getQ(), (double)cloneOneDoFJoint.getQ(), (double)1.0E-12);
                Assertions.assertEquals((double)originalOneDoFJoint.getQd(), (double)cloneOneDoFJoint.getQd(), (double)1.0E-12);
                Assertions.assertEquals((double)originalOneDoFJoint.getQdd(), (double)cloneOneDoFJoint.getQdd(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testVelocityChangeIntegration() {
        Random random = new Random(3465467567L);
        for (int i = 0; i < 1000; ++i) {
            double dt = random.nextDouble();
            MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain randomRobot = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, 20);
            MultiBodySystemBasics robotOriginal = MultiBodySystemBasics.toMultiBodySystemBasics((RigidBodyBasics)randomRobot.getElevator());
            MultiBodySystemBasics robotClone = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)robotOriginal, (ReferenceFrame)worldFrame);
            SingleRobotFirstOrderIntegrator integrator = new SingleRobotFirstOrderIntegrator();
            SingleRobotFirstOrderIntegrator integratorWithVelocity = new SingleRobotFirstOrderIntegrator();
            for (JointStateType stateSelection : Arrays.asList(JointStateType.CONFIGURATION, JointStateType.VELOCITY, JointStateType.ACCELERATION)) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateSelection, (Iterable)robotOriginal.getAllJoints());
                MultiBodySystemTools.copyJointsState((List)robotOriginal.getAllJoints(), (List)robotClone.getAllJoints(), (JointStateType)stateSelection);
            }
            int numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((List)robotOriginal.getAllJoints());
            DMatrixRMaj velocityChange = RandomMatrices_DDRM.rectangle((int)numberOfDoFs, (int)1, (double)-10.0, (double)10.0, (Random)random);
            DMatrixRMaj originalJointAcceleration = new DMatrixRMaj(numberOfDoFs, 1);
            MultiBodySystemTools.extractJointsState((List)robotOriginal.getAllJoints(), (JointStateType)JointStateType.ACCELERATION, (DMatrix)originalJointAcceleration);
            DMatrixRMaj accelerationChange = new DMatrixRMaj(velocityChange);
            CommonOps_DDRM.scale((double)(1.0 / dt), (DMatrixD1)accelerationChange);
            CommonOps_DDRM.addEquals((DMatrixD1)originalJointAcceleration, (DMatrixD1)accelerationChange);
            MultiBodySystemTools.insertJointsState((List)robotOriginal.getAllJoints(), (JointStateType)JointStateType.ACCELERATION, (DMatrix)originalJointAcceleration);
            integrator.integrate(dt, null, robotOriginal);
            integratorWithVelocity.integrate(dt, velocityChange, robotClone);
            for (int jointIndex = 0; jointIndex < robotOriginal.getAllJoints().size(); ++jointIndex) {
                JointBasics originalJoint = (JointBasics)robotOriginal.getAllJoints().get(jointIndex);
                JointBasics cloneJoint = (JointBasics)robotClone.getAllJoints().get(jointIndex);
                if (originalJoint instanceof FloatingJointBasics) {
                    FloatingJointBasics originalFloatingJoint = (FloatingJointBasics)originalJoint;
                    FloatingJointBasics cloneFloatingJoint = (FloatingJointBasics)cloneJoint;
                    EuclidGeometryTestTools.assertPose3DEquals((Pose3DReadOnly)originalFloatingJoint.getJointPose(), (Pose3DReadOnly)cloneFloatingJoint.getJointPose(), (double)1.0E-12);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)originalFloatingJoint.getJointTwist().getAngularPart(), (Tuple3DReadOnly)cloneFloatingJoint.getJointTwist().getAngularPart(), (double)1.0E-12);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)originalFloatingJoint.getJointTwist().getLinearPart(), (Tuple3DReadOnly)cloneFloatingJoint.getJointTwist().getLinearPart(), (double)1.0E-12);
                    continue;
                }
                OneDoFJointBasics originalOneDoFJoint = (OneDoFJointBasics)originalJoint;
                OneDoFJointBasics cloneOneDoFJoint = (OneDoFJointBasics)cloneJoint;
                Assertions.assertEquals((double)originalOneDoFJoint.getQ(), (double)cloneOneDoFJoint.getQ(), (double)1.0E-12);
                Assertions.assertEquals((double)originalOneDoFJoint.getQd(), (double)cloneOneDoFJoint.getQd(), (double)1.0E-12);
            }
        }
    }
}

