/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;

public class YoVariableBufferList
extends AbstractList<YoVariableBuffer<?>> {
    private int size = 0;
    private YoVariableBuffer<?>[] yoVariableBuffers = new YoVariableBuffer[8];
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    @Override
    public int size() {
        return this.size;
    }

    public YoVariableBuffer<?>[] toArray() {
        return Arrays.copyOf(this.yoVariableBuffers, this.size);
    }

    @Override
    public boolean add(YoVariableBuffer<?> e) {
        ++this.size;
        this.ensureCapacity(this.size);
        this.yoVariableBuffers[this.size - 1] = e;
        return true;
    }

    @Override
    public YoVariableBuffer<?> get(int index) {
        return this.yoVariableBuffers[index];
    }

    public void resizeBuffer(int from, int length) {
        for (int i = 0; i < this.size; ++i) {
            this.yoVariableBuffers[i].resizeBuffer(from, length);
        }
    }

    public void fillBuffer(boolean zeroFill, int from, int length) {
        if (length <= 0) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.yoVariableBuffers[i].fillBuffer(zeroFill, from, length);
        }
    }

    public void writeBufferAt(int index) {
        ((Stream)Arrays.stream(this.yoVariableBuffers, 0, this.size).parallel()).forEach(buffer -> buffer.writeBufferAt(index));
    }

    public void readBufferAt(int index) {
        for (int i = 0; i < this.size; ++i) {
            this.yoVariableBuffers[i].readBufferAt(index);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.yoVariableBuffers.length; ++i) {
            if (this.yoVariableBuffers[i] == null) continue;
            this.yoVariableBuffers[i].dispose();
            this.yoVariableBuffers[i] = null;
        }
        this.yoVariableBuffers = null;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends YoVariableBuffer<?>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends YoVariableBuffer<?>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public YoVariableBuffer<?> set(int index, YoVariableBuffer<?> element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, YoVariableBuffer<?> element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public YoVariableBuffer<?> remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.positiveIndexCheck(index);
    }

    protected void positiveIndexCheck(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
    }

    protected void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.yoVariableBuffers.length) {
            return;
        }
        int previousArraySize = this.yoVariableBuffers.length;
        int newArraySize = previousArraySize + (previousArraySize >> 1);
        if (newArraySize - minCapacity < 0) {
            newArraySize = minCapacity;
        }
        if (newArraySize - 0x7FFFFFF7 > 0) {
            newArraySize = YoVariableBufferList.checkWithMaxCapacity(minCapacity);
        }
        this.yoVariableBuffers = Arrays.copyOf(this.yoVariableBuffers, newArraySize);
    }

    private static int checkWithMaxCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

