/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public class YoBufferProperties
implements YoBufferPropertiesReadOnly {
    private int inPoint = 0;
    private int outPoint = 0;
    private int currentIndex = 0;
    private int size = 0;

    public YoBufferProperties() {
    }

    public YoBufferProperties(int index, int size) {
        this.setSize(size);
        this.setCurrentIndexUnsafe(index);
    }

    public YoBufferProperties(YoBufferPropertiesReadOnly other) {
        this.set(other);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public int getInPoint() {
        return this.inPoint;
    }

    @Override
    public int getOutPoint() {
        return this.outPoint;
    }

    public int incrementIndex(boolean updateBufferBounds) {
        this.currentIndex = SharedMemoryTools.increment(this.currentIndex, 1, this.getSize());
        if (updateBufferBounds) {
            this.outPoint = this.currentIndex;
            if (this.outPoint == this.inPoint) {
                this.inPoint = SharedMemoryTools.increment(this.inPoint, 1, this.getSize());
            }
        } else if (!this.isIndexBetweenBounds(this.currentIndex)) {
            this.currentIndex = this.inPoint;
        }
        return this.currentIndex;
    }

    public int decrementIndex() {
        this.currentIndex = SharedMemoryTools.decrement(this.currentIndex, 1, this.getSize());
        if (!this.isIndexBetweenBounds(this.currentIndex)) {
            this.currentIndex = this.outPoint;
        }
        return this.currentIndex;
    }

    public int incrementIndex(boolean updateBufferBounds, int stepSize) {
        if (stepSize < 0) {
            return this.decrementIndex(-stepSize);
        }
        for (int i = 0; i < stepSize; ++i) {
            this.incrementIndex(updateBufferBounds);
        }
        return this.currentIndex;
    }

    public int decrementIndex(int stepSize) {
        if (stepSize < 0) {
            return this.incrementIndex(false, -stepSize);
        }
        for (int i = 0; i < stepSize; ++i) {
            this.decrementIndex();
        }
        return this.currentIndex;
    }

    public void set(YoBufferPropertiesReadOnly other) {
        this.inPoint = other.getInPoint();
        this.outPoint = other.getOutPoint();
        this.currentIndex = other.getCurrentIndex();
        this.size = other.getSize();
    }

    public boolean setCurrentIndex(int newCurrentIndex) {
        if (newCurrentIndex < 0 || newCurrentIndex >= this.size || newCurrentIndex == this.currentIndex) {
            return false;
        }
        this.currentIndex = newCurrentIndex;
        return true;
    }

    public void setCurrentIndexUnsafe(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public void setSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size has to be strictly greater than 0.");
        }
        this.size = size;
    }

    public boolean setInPointIndex(int newInPointIndex) {
        if (newInPointIndex < 0 || newInPointIndex >= this.size || newInPointIndex == this.inPoint) {
            return false;
        }
        this.inPoint = newInPointIndex;
        return true;
    }

    public boolean setOutPointIndex(int newOutPointIndex) {
        if (newOutPointIndex < 0 || newOutPointIndex >= this.size || newOutPointIndex == this.outPoint) {
            return false;
        }
        this.outPoint = newOutPointIndex;
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoBufferPropertiesReadOnly) {
            return this.equals((YoBufferPropertiesReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return "Size " + this.size + ", index " + this.currentIndex + ", in-point " + this.inPoint + ", out-point " + this.outPoint;
    }
}

