/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.scs2.sharedMemory.LinkedBuffer;
import us.ihmc.scs2.sharedMemory.LinkedBufferArray;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.YoRegistryBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class LinkedYoRegistry
extends LinkedBuffer {
    private final YoRegistry rootRegistry;
    private final YoRegistryBuffer yoRegistryBuffer;
    private final ReentrantLock lock;
    private final LinkedBufferArray linkedYoVariables = new LinkedBufferArray();
    private final Map<YoVariable, LinkedYoVariable> linkedYoVariableMap = new HashMap<YoVariable, LinkedYoVariable>();
    private final List<LinkedBuffer.PushRequestListener> listeners = new ArrayList<LinkedBuffer.PushRequestListener>();
    private final LinkedBuffer.PushRequestListener pushRequestForwarder = target -> this.listeners.forEach(listener -> listener.pushRequested(this));
    private YoRegistryChangedListener rootRegistryListener;
    private YoRegistryChangedListener bufferRootRegistryListener;
    private YoRegistry bufferRootRegistry;
    private boolean isDisposed = false;

    LinkedYoRegistry(YoRegistry rootRegistry, YoRegistryBuffer yoRegistryBuffer) {
        this.rootRegistry = rootRegistry;
        this.yoRegistryBuffer = yoRegistryBuffer;
        this.lock = yoRegistryBuffer.getLock();
        this.setup();
    }

    private void setup() {
        this.linkedYoVariables.addChangeListener(change -> {
            if (change.getTarget() instanceof LinkedYoVariable) {
                LinkedYoVariable target = (LinkedYoVariable)change.getTarget();
                if (change.wasLinkedBufferAdded()) {
                    this.linkedYoVariableMap.put((YoVariable)target.getLinkedYoVariable(), target);
                }
                if (change.wasLinkedBufferRemoved()) {
                    this.linkedYoVariableMap.remove(target.getLinkedYoVariable());
                }
            }
        });
        this.bufferRootRegistry = this.yoRegistryBuffer.getRootRegistry().findRegistry(this.rootRegistry.getNamespace());
        SharedMemoryTools.duplicateMissingYoVariablesInTarget(this.bufferRootRegistry, this.rootRegistry);
        this.bufferRootRegistryListener = change -> {
            this.lock.lock();
            try {
                YoVariable newBufferVariable1;
                YoRegistry registry1;
                if (change.wasVariableAdded() && (registry1 = SharedMemoryTools.ensurePathExists(this.rootRegistry, (newBufferVariable1 = change.getTargetVariable()).getNamespace())).getVariable(newBufferVariable1.getName()) == null) {
                    newBufferVariable1.duplicate(registry1);
                }
                if (change.wasRegistryAdded()) {
                    for (YoVariable newBufferVariable2 : change.getTargetRegistry().collectSubtreeVariables()) {
                        YoRegistry registry2 = SharedMemoryTools.ensurePathExists(this.rootRegistry, newBufferVariable2.getNamespace());
                        if (registry2.getVariable(newBufferVariable2.getName()) != null) continue;
                        newBufferVariable2.duplicate(registry2);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        };
        this.bufferRootRegistry.addListener(this.bufferRootRegistryListener);
        this.rootRegistryListener = change -> {
            this.lock.lock();
            try {
                if (change.wasVariableAdded()) {
                    this.yoRegistryBuffer.findOrCreateYoVariableBuffer(change.getTargetVariable());
                }
                if (change.wasRegistryAdded()) {
                    change.getTargetRegistry().collectSubtreeVariables().forEach(var -> this.yoRegistryBuffer.findOrCreateYoVariableBuffer((YoVariable)var));
                }
            }
            finally {
                this.lock.unlock();
            }
        };
        this.rootRegistry.addListener(this.rootRegistryListener);
    }

    public <L extends LinkedYoVariable<T>, T extends YoVariable> L linkYoVariable(T variableToLink) {
        if (this.isDisposed) {
            return null;
        }
        LinkedYoVariable<?> linkedYoVariable = this.linkedYoVariableMap.get(variableToLink);
        if (linkedYoVariable == null) {
            YoVariableBuffer<?> yoVariableBuffer = this.yoRegistryBuffer.findYoVariableBuffer(variableToLink);
            linkedYoVariable = yoVariableBuffer.newLinkedYoVariable(variableToLink);
            linkedYoVariable.addPushRequestListener(this.pushRequestForwarder);
            this.linkedYoVariables.add(linkedYoVariable);
        }
        return (L)linkedYoVariable;
    }

    @Override
    public void push() {
        if (this.isDisposed) {
            return;
        }
        this.lock.lock();
        try {
            this.linkedYoVariables.push();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean pull() {
        if (this.isDisposed) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl = this.linkedYoVariables.pull();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    boolean processPush(boolean writeBuffer) {
        if (this.isDisposed) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl = this.linkedYoVariables.processPush(writeBuffer);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    void flushPush() {
        if (this.isDisposed) {
            return;
        }
        this.lock.lock();
        try {
            this.linkedYoVariables.flushPush();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    void addPushRequestListener(LinkedBuffer.PushRequestListener listener) {
        if (this.isDisposed) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    boolean removePushRequestListener(LinkedBuffer.PushRequestListener listener) {
        if (this.isDisposed) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    @Override
    void prepareForPull() {
        if (this.isDisposed) {
            return;
        }
        this.lock.lock();
        try {
            this.linkedYoVariables.prepareForPull();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    boolean hasRequestPending() {
        if (this.isDisposed) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl = this.linkedYoVariables.hasRequestPending();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public YoRegistry getRootRegistry() {
        return this.rootRegistry;
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.linkedYoVariables.dispose();
        this.linkedYoVariableMap.clear();
        this.listeners.clear();
        this.rootRegistry.removeListener(this.rootRegistryListener);
        this.bufferRootRegistry.removeListener(this.bufferRootRegistryListener);
        this.rootRegistryListener = null;
        this.bufferRootRegistryListener = null;
        this.bufferRootRegistry = null;
    }
}

