/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sharedMemory.EnumPullRequest;
import us.ihmc.scs2.sharedMemory.EnumPushRequest;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.LinkedYoVariableTest;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class LinkedYoEnumTest<E extends Enum<E>>
extends LinkedYoVariableTest<YoEnum<E>> {
    @Override
    YoEnum<E> copy(YoEnum<E> original) {
        YoEnum copy = new YoEnum(original.getName() + "Copy", new YoRegistry("Dummy"), original.getEnumType(), original.isNullAllowed());
        copy.set(original.getOrdinal());
        return copy;
    }

    @Override
    YoEnum<E> nextYoVariable(Random random, int iteration) {
        YoEnum next = SharedMemoryRandomTools.nextYoEnum((Random)new Random(iteration), (YoRegistry)new YoRegistry("Dummy"));
        SharedMemoryRandomTools.randomizeYoEnum((Random)random, (YoEnum)next);
        return next;
    }

    @Test
    public void testConstructor() {
        YoEnumBuffer buffer;
        LinkedYoEnum linkedYoEnum;
        YoEnum linkedVariable;
        int i;
        Random random = new Random(76267L);
        for (i = 0; i < 1000; ++i) {
            linkedVariable = SharedMemoryRandomTools.nextYoEnum((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((linkedVariable == (linkedYoEnum = new LinkedYoEnum(linkedVariable, buffer = SharedMemoryRandomTools.nextYoEnumBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy")))).getLinkedYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((buffer == linkedYoEnum.getBuffer() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            linkedVariable = SharedMemoryRandomTools.nextYoEnum((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((linkedVariable == (linkedYoEnum = (LinkedYoEnum)LinkedYoVariable.newLinkedYoVariable((YoVariable)linkedVariable, (YoVariableBuffer)(buffer = SharedMemoryRandomTools.nextYoEnumBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"))))).getLinkedYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((buffer == linkedYoEnum.getBuffer() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testToPullRequest() {
        Random random = new Random(349785L);
        for (int i = 0; i < 1000; ++i) {
            YoEnumBuffer buffer;
            LinkedYoEnum linkedYoEnum;
            EnumPullRequest pullRequest;
            YoEnum<E> linkedVariable = this.nextYoVariable(random, i);
            Assertions.assertTrue((linkedVariable == (pullRequest = (linkedYoEnum = new LinkedYoEnum(linkedVariable, buffer = (YoEnumBuffer)SharedMemoryRandomTools.nextYoVariableBuffer((Random)random, this.nextYoVariable(random, i)))).toPullRequest()).getVariableToUpdate() ? 1 : 0) != 0);
            Assertions.assertEquals((int)((YoEnum)buffer.getYoVariable()).getOrdinal(), (int)pullRequest.getValueToPull());
            pullRequest.pull();
            Assertions.assertEquals((int)linkedVariable.getOrdinal(), (int)((YoEnum)buffer.getYoVariable()).getOrdinal());
        }
    }

    @Test
    public void testToPushRequest() {
        Random random = new Random(349785L);
        for (int i = 0; i < 1000; ++i) {
            YoEnum<E> linkedVariable = this.nextYoVariable(random, i);
            YoEnumBuffer buffer = (YoEnumBuffer)SharedMemoryRandomTools.nextYoVariableBuffer((Random)random, this.nextYoVariable(random, i));
            LinkedYoEnum linkedYoEnum = new LinkedYoEnum(linkedVariable, buffer);
            EnumPushRequest pullRequest = linkedYoEnum.toPushRequest();
            Assertions.assertTrue((buffer.getYoVariable() == pullRequest.getVariableToUpdate() ? 1 : 0) != 0);
            Assertions.assertEquals((int)linkedVariable.getOrdinal(), (int)pullRequest.getValueToPush());
            pullRequest.push();
            Assertions.assertEquals((int)linkedVariable.getOrdinal(), (int)((YoEnum)buffer.getYoVariable()).getOrdinal());
        }
    }
}

