/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.YoBooleanBuffer;
import us.ihmc.scs2.sharedMemory.YoDoubleBuffer;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoIntegerBuffer;
import us.ihmc.scs2.sharedMemory.YoLongBuffer;
import us.ihmc.scs2.sharedMemory.YoRegistryBuffer;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoSharedBufferTest {
    private static final int ITERATIONS = 200;

    @Test
    public void testCropBuffer() {
        Random random = new Random(6234L);
        for (int i = 0; i < 200; ++i) {
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            YoBufferPropertiesReadOnly newProperties = yoSharedBuffer.getProperties();
            YoBufferPropertiesReadOnly initialProperties = newProperties.copy();
            CropBufferRequest cropBufferRequest = new CropBufferRequest(random.nextInt(initialProperties.getSize()), random.nextInt(initialProperties.getSize()));
            yoSharedBuffer.cropBuffer(cropBufferRequest);
            Assertions.assertEquals((int)cropBufferRequest.getCroppedSize(initialProperties.getSize()), (int)newProperties.getSize());
            Assertions.assertEquals((int)0, (int)newProperties.getInPoint());
            Assertions.assertEquals((int)(newProperties.getSize() - 1), (int)newProperties.getOutPoint());
            Assertions.assertEquals((int)newProperties.getInPoint(), (int)newProperties.getCurrentIndex());
        }
    }

    @Test
    public void testResizeBuffer() {
        int expectedNewCurrentIndex;
        int newSize;
        YoBufferPropertiesReadOnly initialProperties;
        YoBufferPropertiesReadOnly newProperties;
        YoSharedBuffer yoSharedBuffer;
        int i;
        Random random = new Random(6234L);
        YoSharedBuffer yoSharedBuffer2 = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
        Assertions.assertFalse((boolean)yoSharedBuffer2.resizeBuffer(0));
        Assertions.assertFalse((boolean)yoSharedBuffer2.resizeBuffer(-1));
        Assertions.assertFalse((boolean)yoSharedBuffer2.resizeBuffer(yoSharedBuffer2.getProperties().getSize()));
        for (i = 0; i < 200; ++i) {
            yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            newProperties = yoSharedBuffer.getProperties();
            initialProperties = newProperties.copy();
            newSize = initialProperties.getSize() + random.nextInt(1000) + 1;
            Assertions.assertTrue((boolean)yoSharedBuffer.resizeBuffer(newSize));
            Assertions.assertEquals((int)newSize, (int)newProperties.getSize());
            Assertions.assertEquals((int)0, (int)newProperties.getInPoint());
            Assertions.assertEquals((int)(initialProperties.getActiveBufferLength() - 1), (int)newProperties.getOutPoint());
            if (initialProperties.isIndexBetweenBounds(initialProperties.getCurrentIndex())) {
                expectedNewCurrentIndex = initialProperties.getCurrentIndex() - initialProperties.getInPoint();
                if (expectedNewCurrentIndex < 0) {
                    expectedNewCurrentIndex += initialProperties.getSize();
                }
                Assertions.assertEquals((int)expectedNewCurrentIndex, (int)newProperties.getCurrentIndex());
                continue;
            }
            Assertions.assertEquals((int)newProperties.getOutPoint(), (int)newProperties.getCurrentIndex());
        }
        for (i = 0; i < 200; ++i) {
            yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            newProperties = yoSharedBuffer.getProperties();
            while (newProperties.getActiveBufferLength() == newProperties.getSize()) {
                yoSharedBuffer.setOutPoint(random.nextInt(newProperties.getSize()));
            }
            initialProperties = newProperties.copy();
            newSize = RandomNumbers.nextInt((Random)random, (int)initialProperties.getActiveBufferLength(), (int)(initialProperties.getSize() - 1));
            Assertions.assertTrue((boolean)yoSharedBuffer.resizeBuffer(newSize));
            Assertions.assertEquals((int)newSize, (int)newProperties.getSize());
            Assertions.assertEquals((int)0, (int)newProperties.getInPoint());
            Assertions.assertEquals((int)(initialProperties.getActiveBufferLength() - 1), (int)newProperties.getOutPoint());
            if (initialProperties.isIndexBetweenBounds(initialProperties.getCurrentIndex())) {
                expectedNewCurrentIndex = initialProperties.getCurrentIndex() - initialProperties.getInPoint();
                if (expectedNewCurrentIndex < 0) {
                    expectedNewCurrentIndex += initialProperties.getSize();
                }
                Assertions.assertEquals((int)expectedNewCurrentIndex, (int)newProperties.getCurrentIndex());
                continue;
            }
            Assertions.assertEquals((int)newProperties.getOutPoint(), (int)newProperties.getCurrentIndex());
        }
        for (i = 0; i < 200; ++i) {
            yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            newProperties = yoSharedBuffer.getProperties();
            initialProperties = newProperties.copy();
            newSize = random.nextInt(initialProperties.getActiveBufferLength()) + 1;
            if (newSize == newProperties.getSize()) {
                --i;
                continue;
            }
            Assertions.assertTrue((boolean)yoSharedBuffer.resizeBuffer(newSize));
            Assertions.assertEquals((int)newSize, (int)newProperties.getSize());
            Assertions.assertEquals((int)0, (int)newProperties.getInPoint());
            Assertions.assertEquals((int)(newSize - 1), (int)newProperties.getOutPoint());
            expectedNewCurrentIndex = initialProperties.getCurrentIndex() - initialProperties.getInPoint();
            if (expectedNewCurrentIndex < 0) {
                expectedNewCurrentIndex += initialProperties.getSize();
            }
            if ((expectedNewCurrentIndex += -initialProperties.getActiveBufferLength() + newSize) < 0 || expectedNewCurrentIndex >= newSize) {
                Assertions.assertEquals((int)newProperties.getOutPoint(), (int)newProperties.getCurrentIndex());
                continue;
            }
            Assertions.assertEquals((int)expectedNewCurrentIndex, (int)newProperties.getCurrentIndex());
        }
    }

    @Test
    public void testSetCurrentIndex() {
        Random random = new Random(4566L);
        for (int i = 0; i < 200; ++i) {
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            yoSharedBuffer.readBuffer();
            YoBufferPropertiesReadOnly properties = yoSharedBuffer.getProperties();
            Assertions.assertFalse((boolean)yoSharedBuffer.setCurrentIndex(-1));
            Assertions.assertFalse((boolean)yoSharedBuffer.setCurrentIndex(properties.getSize()));
            int newCurrentIndex = random.nextInt(properties.getSize());
            Assertions.assertEquals((Object)(newCurrentIndex != properties.getCurrentIndex() ? 1 : 0), (Object)yoSharedBuffer.setCurrentIndex(newCurrentIndex));
            Assertions.assertEquals((int)newCurrentIndex, (int)properties.getCurrentIndex());
            Assertions.assertFalse((boolean)yoSharedBuffer.setCurrentIndex(newCurrentIndex));
        }
    }

    @Test
    public void testSetInOutPoint() {
        Random random = new Random(4566L);
        for (int i = 0; i < 200; ++i) {
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            yoSharedBuffer.readBuffer();
            YoBufferPropertiesReadOnly properties = yoSharedBuffer.getProperties();
            Assertions.assertFalse((boolean)yoSharedBuffer.setInPoint(-1));
            Assertions.assertFalse((boolean)yoSharedBuffer.setInPoint(properties.getSize()));
            int newInPoint = random.nextInt(properties.getSize());
            Assertions.assertEquals((Object)(newInPoint != properties.getInPoint() ? 1 : 0), (Object)yoSharedBuffer.setInPoint(newInPoint));
            Assertions.assertEquals((int)newInPoint, (int)properties.getInPoint());
            Assertions.assertFalse((boolean)yoSharedBuffer.setInPoint(newInPoint));
            Assertions.assertFalse((boolean)yoSharedBuffer.setOutPoint(-1));
            Assertions.assertFalse((boolean)yoSharedBuffer.setOutPoint(properties.getSize()));
            int newOutPoint = random.nextInt(properties.getSize());
            Assertions.assertEquals((Object)(newOutPoint != properties.getOutPoint() ? 1 : 0), (Object)yoSharedBuffer.setOutPoint(newOutPoint));
            Assertions.assertEquals((int)newOutPoint, (int)properties.getOutPoint());
            Assertions.assertFalse((boolean)yoSharedBuffer.setOutPoint(newOutPoint));
        }
    }

    @Test
    public void testApplyProcessor() {
        final Random random = new Random(2348273L);
        for (int i = 0; i < 200; ++i) {
            final YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            final YoBufferPropertiesReadOnly properties = yoSharedBuffer.getProperties();
            int initialIndex = properties.getCurrentIndex();
            final List variables = yoSharedBuffer.getRootRegistry().collectSubtreeVariables();
            final MutableInt processorLastIndex = new MutableInt(-1);
            YoBufferProcessor processor = new YoBufferProcessor(){
                boolean initialized = false;
                boolean forward = random.nextBoolean();

                public void initialize(YoVariableHolder yoVariableHolder) {
                    Assertions.assertTrue((yoVariableHolder == yoSharedBuffer.getRootRegistry() ? 1 : 0) != 0);
                    this.initialized = true;
                }

                public void process(int startIndex, int endIndex, int currentIndex) {
                    Assertions.assertTrue((boolean)this.initialized);
                    if (this.forward) {
                        Assertions.assertEquals((int)startIndex, (int)properties.getInPoint());
                        Assertions.assertEquals((int)endIndex, (int)properties.getOutPoint());
                    } else {
                        Assertions.assertEquals((int)startIndex, (int)properties.getOutPoint());
                        Assertions.assertEquals((int)endIndex, (int)properties.getInPoint());
                    }
                    for (YoVariable variable : variables) {
                        YoSharedBufferTest.assertVariableEqualsBufferAt(variable, yoSharedBuffer.getRegistryBuffer().findYoVariableBuffer(variable), currentIndex);
                        variable.setValueFromDouble(0.0);
                    }
                    if (processorLastIndex.intValue() != -1) {
                        if (this.forward) {
                            Assertions.assertEquals((int)SharedMemoryTools.increment((int)processorLastIndex.intValue(), (int)1, (int)properties.getSize()), (int)currentIndex);
                        } else {
                            Assertions.assertEquals((int)SharedMemoryTools.decrement((int)processorLastIndex.intValue(), (int)1, (int)properties.getSize()), (int)currentIndex);
                        }
                        Assertions.assertNotEquals((int)startIndex, (int)currentIndex);
                        Assertions.assertEquals((int)properties.getCurrentIndex(), (int)currentIndex);
                    } else {
                        Assertions.assertEquals((int)startIndex, (int)currentIndex);
                    }
                    processorLastIndex.setValue(currentIndex);
                }

                public boolean goForward() {
                    return this.forward;
                }
            };
            yoSharedBuffer.applyProcessor(processor);
            Assertions.assertEquals((int)initialIndex, (int)properties.getCurrentIndex());
            yoSharedBuffer.setCurrentIndex(properties.getInPoint());
            for (int j = 0; j < properties.getActiveBufferLength(); ++j) {
                yoSharedBuffer.readBuffer();
                for (YoVariable variable : variables) {
                    Assertions.assertEquals((double)0.0, (double)variable.getValueAsDouble());
                }
                yoSharedBuffer.incrementBufferIndex(false);
            }
        }
    }

    @Test
    public void testProcessLinkedPushRequests() {
        Random random = new Random(4566L);
        for (int i = 0; i < 200; ++i) {
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            yoSharedBuffer.readBuffer();
            YoBufferPropertiesReadOnly properties = yoSharedBuffer.getProperties();
            YoRegistry bufferRootRegistry = yoSharedBuffer.getRootRegistry();
            List allBufferYoVariables = bufferRootRegistry.collectSubtreeVariables();
            if (allBufferYoVariables.isEmpty()) {
                --i;
                continue;
            }
            YoVariable bufferYoVariable = (YoVariable)allBufferYoVariables.get(random.nextInt(allBufferYoVariables.size()));
            YoRegistry consumerRegistry = SharedMemoryTools.newEmptyCloneRegistry((YoRegistry)bufferYoVariable.getRegistry());
            YoVariable consumerYoVariable = bufferYoVariable.duplicate(consumerRegistry);
            LinkedYoVariable linkedYoVariable = yoSharedBuffer.newLinkedYoVariable(consumerYoVariable);
            SharedMemoryRandomTools.randomizeYoVariable((Random)random, (YoVariable)consumerYoVariable);
            linkedYoVariable.push();
            boolean writeBuffer = random.nextBoolean();
            yoSharedBuffer.processLinkedPushRequests(writeBuffer);
            YoSharedBufferTest.assertYoEquals(consumerYoVariable, bufferYoVariable);
            if (!writeBuffer) continue;
            YoSharedBufferTest.assertVariableEqualsBufferAt(bufferYoVariable, yoSharedBuffer.getRegistryBuffer().findYoVariableBuffer(bufferYoVariable), properties.getCurrentIndex());
        }
    }

    @Test
    public void testFlushLinkedPushRequests() {
        Random random = new Random(4566L);
        for (int i = 0; i < 200; ++i) {
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            yoSharedBuffer.readBuffer();
            YoRegistry bufferRootRegistry = yoSharedBuffer.getRootRegistry();
            List allBufferYoVariables = bufferRootRegistry.collectSubtreeVariables();
            if (allBufferYoVariables.isEmpty()) {
                --i;
                continue;
            }
            YoVariable bufferYoVariable = (YoVariable)allBufferYoVariables.get(random.nextInt(allBufferYoVariables.size()));
            YoRegistry consumerRegistry = SharedMemoryTools.newEmptyCloneRegistry((YoRegistry)bufferYoVariable.getRegistry());
            YoVariable consumerYoVariable = bufferYoVariable.duplicate(consumerRegistry);
            LinkedYoVariable linkedYoVariable = yoSharedBuffer.newLinkedYoVariable(consumerYoVariable);
            SharedMemoryRandomTools.randomizeYoVariable((Random)random, (YoVariable)consumerYoVariable);
            linkedYoVariable.push();
            yoSharedBuffer.flushLinkedPushRequests();
            Assertions.assertFalse((boolean)linkedYoVariable.processPush(true));
        }
    }

    @Test
    public void testReadBuffer() {
        Random random = new Random(4566L);
        for (int i = 0; i < 200; ++i) {
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            YoRegistry bufferRootRegistry = yoSharedBuffer.getRootRegistry();
            YoRegistryBuffer registryBuffer = yoSharedBuffer.getRegistryBuffer();
            YoBufferPropertiesReadOnly properties = yoSharedBuffer.getProperties();
            List allBufferYoVariables = bufferRootRegistry.collectSubtreeVariables();
            if (allBufferYoVariables.isEmpty()) {
                --i;
                continue;
            }
            long[] bufferBackedUp = allBufferYoVariables.stream().map(v -> registryBuffer.findYoVariableBuffer(v)).mapToLong(b -> b.getValueAsLongBits()).toArray();
            yoSharedBuffer.readBuffer();
            for (int j = 0; j < allBufferYoVariables.size(); ++j) {
                YoVariable bufferYoVariable = (YoVariable)allBufferYoVariables.get(j);
                YoVariableBuffer buffer = registryBuffer.findYoVariableBuffer(bufferYoVariable);
                YoSharedBufferTest.assertVariableEqualsBufferAt(bufferYoVariable, buffer, properties.getCurrentIndex());
                Assertions.assertEquals((long)bufferBackedUp[j], (long)buffer.getValueAsLongBits());
            }
        }
    }

    @Test
    public void testWriteBuffer() {
        Random random = new Random(4566L);
        for (int i = 0; i < 200; ++i) {
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            YoRegistry bufferRootRegistry = yoSharedBuffer.getRootRegistry();
            YoRegistryBuffer registryBuffer = yoSharedBuffer.getRegistryBuffer();
            YoBufferPropertiesReadOnly properties = yoSharedBuffer.getProperties();
            List allBufferYoVariables = bufferRootRegistry.collectSubtreeVariables();
            if (allBufferYoVariables.isEmpty()) {
                --i;
                continue;
            }
            long[] variableBackedUp = allBufferYoVariables.stream().mapToLong(YoVariable::getValueAsLongBits).toArray();
            yoSharedBuffer.writeBuffer();
            for (int j = 0; j < allBufferYoVariables.size(); ++j) {
                YoVariable bufferYoVariable = (YoVariable)allBufferYoVariables.get(j);
                YoVariableBuffer buffer = registryBuffer.findYoVariableBuffer(bufferYoVariable);
                YoSharedBufferTest.assertVariableEqualsBufferAt(bufferYoVariable, buffer, properties.getCurrentIndex());
                Assertions.assertEquals((long)variableBackedUp[j], (long)bufferYoVariable.getValueAsLongBits());
            }
        }
    }

    @Test
    public void testPrepareLinkedBuffersForPull() {
        Random random = new Random(2356L);
        for (int i = 0; i < 200; ++i) {
            YoVariable bufferYoVariable;
            int j;
            YoSharedBuffer yoSharedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)2, (int)5);
            YoRegistry bufferRootRegistry = yoSharedBuffer.getRootRegistry();
            List allBufferYoVariables = bufferRootRegistry.collectSubtreeVariables();
            if (allBufferYoVariables.isEmpty()) {
                --i;
                continue;
            }
            LinkedYoRegistry linkedYoRegistry = yoSharedBuffer.newLinkedYoRegistry();
            List allConsumerYoVariables = linkedYoRegistry.getRootRegistry().collectSubtreeVariables();
            allConsumerYoVariables.forEach(var -> linkedYoRegistry.linkYoVariable(var).addUser((Object)this));
            allBufferYoVariables.forEach(v -> SharedMemoryRandomTools.randomizeYoVariable((Random)random, (YoVariable)v));
            long[] bufferVariableBackedUp = allBufferYoVariables.stream().mapToLong(YoVariable::getValueAsLongBits).toArray();
            yoSharedBuffer.prepareLinkedBuffersForPull();
            for (j = 0; j < allBufferYoVariables.size(); ++j) {
                bufferYoVariable = (YoVariable)allBufferYoVariables.get(j);
                Assertions.assertEquals((long)bufferVariableBackedUp[j], (long)bufferYoVariable.getValueAsLongBits());
            }
            linkedYoRegistry.pull();
            for (j = 0; j < allBufferYoVariables.size(); ++j) {
                bufferYoVariable = (YoVariable)allBufferYoVariables.get(j);
                YoVariable consumerYoVariable = (YoVariable)allConsumerYoVariables.get(j);
                Assertions.assertEquals((long)bufferVariableBackedUp[j], (long)bufferYoVariable.getValueAsLongBits());
                YoSharedBufferTest.assertYoEquals(bufferYoVariable, consumerYoVariable);
            }
        }
    }

    private static void assertYoEquals(YoVariable expected, YoVariable actual) {
        Assertions.assertTrue((expected.getClass() == actual.getClass() ? 1 : 0) != 0);
        Assertions.assertEquals((long)expected.getValueAsLongBits(), (long)actual.getValueAsLongBits());
    }

    private static void assertVariableEqualsBufferAt(YoVariable yoVariable, YoVariableBuffer<?> buffer, int index) {
        if (yoVariable instanceof YoBoolean) {
            Assertions.assertEquals((Object)((YoBoolean)yoVariable).getValue(), (Object)((YoBooleanBuffer)buffer).getBuffer()[index]);
        } else if (yoVariable instanceof YoDouble) {
            Assertions.assertEquals((double)((YoDouble)yoVariable).getValue(), (double)((YoDoubleBuffer)buffer).getBuffer()[index]);
        } else if (yoVariable instanceof YoInteger) {
            Assertions.assertEquals((int)((YoInteger)yoVariable).getValue(), (int)((YoIntegerBuffer)buffer).getBuffer()[index]);
        } else if (yoVariable instanceof YoLong) {
            Assertions.assertEquals((long)((YoLong)yoVariable).getValue(), (long)((YoLongBuffer)buffer).getBuffer()[index]);
        } else if (yoVariable instanceof YoEnum) {
            Assertions.assertEquals((int)((YoEnum)yoVariable).getOrdinal(), (int)((YoEnumBuffer)buffer).getBuffer()[index]);
        } else {
            throw new IllegalStateException("Type not handled: " + String.valueOf(yoVariable.getClass()));
        }
    }
}

