/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.YoBooleanBuffer;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.YoDoubleBuffer;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoIntegerBuffer;
import us.ihmc.scs2.sharedMemory.YoLongBuffer;
import us.ihmc.scs2.sharedMemory.YoRegistryBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoRegistryBufferTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testConstructor() {
        Random random = new Random(62825L);
        for (int i = 0; i < 1000; ++i) {
            YoBufferProperties bufferProperties;
            YoRegistryBuffer YoRegistryBuffer2;
            YoRegistry[] allRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)10, (int)15);
            YoRegistry rootRegistry = allRegistries[0];
            Assertions.assertTrue((rootRegistry == (YoRegistryBuffer2 = new YoRegistryBuffer(rootRegistry, (YoBufferPropertiesReadOnly)(bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getRootRegistry() ? 1 : 0) != 0);
            List allYoVariables = rootRegistry.collectSubtreeVariables();
            for (YoVariable yoVariable : allYoVariables) {
                YoVariableBuffer yoVariableBuffer = YoRegistryBuffer2.findYoVariableBuffer(yoVariable);
                Assertions.assertNotNull((Object)yoVariableBuffer);
                Assertions.assertTrue((yoVariable == yoVariableBuffer.getYoVariable() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testRegisterMissingBuffers() {
        Random random = new Random(74586L);
        for (int i = 0; i < 1000; ++i) {
            YoRegistry[] allRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)5, (int)5);
            YoRegistry rootRegistry = allRegistries[0];
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoRegistryBuffer yoRegistryBuffer = new YoRegistryBuffer(rootRegistry, (YoBufferPropertiesReadOnly)bufferProperties);
            for (int j = 0; j < allRegistries.length; ++j) {
                YoRegistry yoRegistry = allRegistries[j];
                SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (YoRegistry)yoRegistry, (String)("new" + j), (int)5, (int)5);
            }
            List allYoVariables = rootRegistry.collectSubtreeVariables();
            for (YoVariable yoVariable : allYoVariables) {
                YoVariableBuffer yoVariableBuffer = yoRegistryBuffer.findYoVariableBuffer(yoVariable);
                Assertions.assertNotNull((Object)yoVariableBuffer);
                Assertions.assertTrue((yoVariable == yoVariableBuffer.getYoVariable() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testResizeBuffer() {
        Random random = new Random(734259L);
        for (int i = 0; i < 1000; ++i) {
            YoRegistry[] allRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)2, (int)2);
            YoRegistry rootRegistry = allRegistries[0];
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoRegistryBuffer YoRegistryBuffer2 = new YoRegistryBuffer(rootRegistry, (YoBufferPropertiesReadOnly)bufferProperties);
            SharedMemoryRandomTools.randomizeYoRegistryBuffer((Random)random, (YoRegistryBuffer)YoRegistryBuffer2);
            List allYoVariables = rootRegistry.collectSubtreeVariables();
            ArrayList<YoVariableBuffer> allYoVariableBuffers = new ArrayList<YoVariableBuffer>();
            ArrayList<BufferSample> allSamples = new ArrayList<BufferSample>();
            int from = random.nextInt(bufferProperties.getSize());
            int length = random.nextInt(bufferProperties.getSize() - 1) + 1;
            for (YoVariable yoVariable : allYoVariables) {
                YoVariableBuffer yoVariableBuffer = YoRegistryBuffer2.findYoVariableBuffer(yoVariable);
                allYoVariableBuffers.add(yoVariableBuffer);
                allSamples.add(new BufferSample(0, yoVariableBuffer.copy(from, length, bufferProperties.copy()).getSample(), length, (YoBufferPropertiesReadOnly)bufferProperties));
            }
            YoRegistryBuffer2.resizeBuffer(from, length);
            for (int j = 0; j < allYoVariables.size(); ++j) {
                BufferSample expected = ((YoVariableBuffer)allYoVariableBuffers.get(j)).copy(0, length, bufferProperties.copy());
                expected = new BufferSample(expected.getFrom(), expected.getSample(), expected.getSampleLength(), (YoBufferPropertiesReadOnly)bufferProperties);
                BufferSample actual = (BufferSample)allSamples.get(j);
                Assertions.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void testWriteBuffer() {
        Random random = new Random(734259L);
        for (int i = 0; i < 1000; ++i) {
            YoRegistry[] allRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)5, (int)5);
            YoRegistry rootRegistry = allRegistries[0];
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoRegistryBuffer YoRegistryBuffer2 = new YoRegistryBuffer(rootRegistry, (YoBufferPropertiesReadOnly)bufferProperties);
            List allYoVariables = rootRegistry.collectSubtreeVariables();
            for (int j = 0; j < 10; ++j) {
                allYoVariables.forEach(v -> SharedMemoryRandomTools.randomizeYoVariable((Random)random, (YoVariable)v));
                YoRegistryBuffer2.writeBuffer();
                for (YoVariable yoVariable : allYoVariables) {
                    YoRegistryBufferTest.assertBufferCurrentValueEquals(bufferProperties.getCurrentIndex(), yoVariable, YoRegistryBuffer2.findYoVariableBuffer(yoVariable));
                }
            }
        }
    }

    @Test
    public void testReadBuffer() {
        Random random = new Random(734259L);
        for (int i = 0; i < 1000; ++i) {
            YoRegistry[] allRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)5, (int)5);
            YoRegistry rootRegistry = allRegistries[0];
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoRegistryBuffer YoRegistryBuffer2 = new YoRegistryBuffer(rootRegistry, (YoBufferPropertiesReadOnly)bufferProperties);
            List allYoVariables = rootRegistry.collectSubtreeVariables();
            List<YoVariableBuffer> allYoVariableBuffers = allYoVariables.stream().map(arg_0 -> ((YoRegistryBuffer)YoRegistryBuffer2).findYoVariableBuffer(arg_0)).collect(Collectors.toList());
            for (int j = 0; j < 10; ++j) {
                allYoVariableBuffers.forEach(b -> YoRegistryBufferTest.randomizeBuffer(random, bufferProperties.getCurrentIndex(), b));
                YoRegistryBuffer2.readBuffer();
                for (YoVariable yoVariable : allYoVariables) {
                    YoRegistryBufferTest.assertBufferCurrentValueEquals(bufferProperties.getCurrentIndex(), yoVariable, YoRegistryBuffer2.findYoVariableBuffer(yoVariable));
                }
            }
        }
    }

    @Test
    public void testFindOrCreateYoVariableBuffer() {
        Random random = new Random(78924L);
        for (int i = 0; i < 1000; ++i) {
            YoRegistry[] allRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)5, (int)5);
            YoRegistry rootRegistry = allRegistries[0];
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoRegistryBuffer yoRegistryBuffer = new YoRegistryBuffer(rootRegistry, (YoBufferPropertiesReadOnly)bufferProperties);
            YoRegistry rootMirrorRegistry = new YoRegistry(rootRegistry.getName());
            SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)rootRegistry, (YoRegistry)rootMirrorRegistry);
            YoRegistry yoRegistry = (YoRegistry)rootMirrorRegistry.collectSubtreeRegistries().get(random.nextInt(allRegistries.length - 1));
            YoVariable newYoVariable = SharedMemoryRandomTools.nextYoVariable((Random)random, (YoRegistry)yoRegistry);
            Assertions.assertNull((Object)yoRegistryBuffer.findYoVariableBuffer(newYoVariable));
            Assertions.assertNull((Object)rootRegistry.findVariable(newYoVariable.getFullNameString()));
            YoVariableBuffer newBuffer = yoRegistryBuffer.findOrCreateYoVariableBuffer(newYoVariable);
            Assertions.assertEquals((Object)newYoVariable.getFullNameString(), (Object)newBuffer.getYoVariable().getFullNameString());
            Assertions.assertNotNull((Object)yoRegistryBuffer.findYoVariableBuffer(newYoVariable));
            Assertions.assertNotNull((Object)rootRegistry.findVariable(newYoVariable.getFullNameString()));
            Assertions.assertEquals(newYoVariable.getClass(), rootRegistry.findVariable(newYoVariable.getFullNameString()).getClass());
            ArrayList<YoRegistry> newRegistries = new ArrayList<YoRegistry>();
            for (int j = 0; j < random.nextInt(10) + 1; ++j) {
                YoRegistry newChild = new YoRegistry(SharedMemoryRandomTools.nextAvailableRegistryName((Random)random, (int)10, (int)20, (YoRegistry)yoRegistry));
                yoRegistry.addChild(newChild);
                newRegistries.add(newChild);
                yoRegistry = newChild;
            }
            newYoVariable = SharedMemoryRandomTools.nextYoVariable((Random)random, (YoRegistry)yoRegistry);
            Assertions.assertNull((Object)yoRegistryBuffer.findYoVariableBuffer(newYoVariable));
            Assertions.assertNull((Object)rootRegistry.findVariable(newYoVariable.getFullNameString()));
            newBuffer = yoRegistryBuffer.findOrCreateYoVariableBuffer(newYoVariable);
            Assertions.assertEquals((Object)newYoVariable.getFullNameString(), (Object)newBuffer.getYoVariable().getFullNameString());
            Assertions.assertNotNull((Object)yoRegistryBuffer.findYoVariableBuffer(newYoVariable));
            Assertions.assertNotNull((Object)rootRegistry.findVariable(newYoVariable.getFullNameString()));
            Assertions.assertEquals(newYoVariable.getClass(), rootRegistry.findVariable(newYoVariable.getFullNameString()).getClass());
            newRegistries.forEach(newRegistry -> Assertions.assertNotNull((Object)rootRegistry.findRegistry(newRegistry.getNamespace())));
        }
    }

    @Test
    public void testNewLinkedYoRegistry() {
        Random random = new Random(978345L);
        for (int i = 0; i < 1000; ++i) {
            LinkedYoRegistry linkedSubTreeRegistry;
            YoRegistry[] allRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)5, (int)5);
            YoRegistry rootRegistry = allRegistries[0];
            YoBufferProperties bufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoRegistryBuffer yoRegistryBuffer = new YoRegistryBuffer(rootRegistry, (YoBufferPropertiesReadOnly)bufferProperties);
            LinkedYoRegistry linkedRootRegistry = yoRegistryBuffer.newLinkedYoRegistry();
            Assertions.assertEquals((Object)rootRegistry.getName(), (Object)linkedRootRegistry.getRootRegistry().getName());
            for (YoRegistry registry : allRegistries) {
                YoRegistry linkedRegistry = linkedRootRegistry.getRootRegistry().findRegistry(registry.getNamespace());
                Assertions.assertNotNull((Object)linkedRegistry);
                Assertions.assertEquals((int)linkedRegistry.getChildren().size(), (int)registry.getChildren().size());
                Assertions.assertEquals((int)linkedRegistry.getVariables().size(), (int)registry.getVariables().size());
            }
            YoRegistry subTreeRootRegistry = allRegistries[random.nextInt(allRegistries.length)];
            YoRegistry linkedSubTreeRootRegistry = SharedMemoryTools.newEmptyCloneRegistry((YoRegistry)subTreeRootRegistry);
            Assertions.assertTrue((linkedSubTreeRootRegistry == (linkedSubTreeRegistry = yoRegistryBuffer.newLinkedYoRegistry(linkedSubTreeRootRegistry)).getRootRegistry() ? 1 : 0) != 0);
            for (YoRegistry registry : subTreeRootRegistry.collectSubtreeRegistries()) {
                YoRegistry linkedRegistry = linkedSubTreeRootRegistry.findRegistry(registry.getNamespace());
                Assertions.assertNotNull((Object)linkedRegistry);
                Assertions.assertEquals((int)linkedRegistry.getChildren().size(), (int)registry.getChildren().size());
                Assertions.assertEquals((int)linkedRegistry.getVariables().size(), (int)registry.getVariables().size());
            }
        }
    }

    private static void assertBufferCurrentValueEquals(int currentIndex, YoVariable expectedValue, YoVariableBuffer<?> yoVariableBuffer) {
        if (expectedValue instanceof YoBoolean) {
            Assertions.assertEquals((Object)((YoBoolean)expectedValue).getValue(), (Object)((YoBooleanBuffer)yoVariableBuffer).getBuffer()[currentIndex]);
        } else if (expectedValue instanceof YoDouble) {
            Assertions.assertEquals((double)((YoDouble)expectedValue).getValue(), (double)((YoDoubleBuffer)yoVariableBuffer).getBuffer()[currentIndex]);
        } else if (expectedValue instanceof YoInteger) {
            Assertions.assertEquals((int)((YoInteger)expectedValue).getValue(), (int)((YoIntegerBuffer)yoVariableBuffer).getBuffer()[currentIndex]);
        } else if (expectedValue instanceof YoLong) {
            Assertions.assertEquals((long)((YoLong)expectedValue).getValue(), (long)((YoLongBuffer)yoVariableBuffer).getBuffer()[currentIndex]);
        } else if (expectedValue instanceof YoEnum) {
            Assertions.assertEquals((int)((YoEnum)expectedValue).getOrdinal(), (int)((YoEnumBuffer)yoVariableBuffer).getBuffer()[currentIndex]);
        } else {
            throw new IllegalStateException("Unhandled variable type.");
        }
    }

    private static void randomizeBuffer(Random random, int index, YoVariableBuffer<?> yoVariableBuffer) {
        if (yoVariableBuffer instanceof YoBooleanBuffer) {
            ((YoBooleanBuffer)yoVariableBuffer).getBuffer()[index] = random.nextBoolean();
        } else if (yoVariableBuffer instanceof YoDoubleBuffer) {
            ((YoDoubleBuffer)yoVariableBuffer).getBuffer()[index] = random.nextDouble();
        } else if (yoVariableBuffer instanceof YoIntegerBuffer) {
            ((YoIntegerBuffer)yoVariableBuffer).getBuffer()[index] = random.nextInt();
        } else if (yoVariableBuffer instanceof YoLongBuffer) {
            ((YoLongBuffer)yoVariableBuffer).getBuffer()[index] = random.nextLong();
        } else if (yoVariableBuffer instanceof YoEnumBuffer) {
            YoEnumBuffer yoEnumBuffer = (YoEnumBuffer)yoVariableBuffer;
            yoEnumBuffer.getBuffer()[index] = ((YoEnum)yoEnumBuffer.getYoVariable()).isNullAllowed() ? (byte)(random.nextInt(((YoEnum)yoEnumBuffer.getYoVariable()).getEnumSize() + 1) - 1) : (byte)random.nextInt(((YoEnum)yoEnumBuffer.getYoVariable()).getEnumSize());
        } else {
            throw new IllegalStateException("Unhandled buffer type.");
        }
    }
}

