/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.security.AccessController;
import java.util.Properties;
import us.ihmc.log.LogTools;

public class SessionPropertiesHelper {
    private static final Properties systemProperties = (Properties)AccessController.doPrivileged(() -> System.getProperties());

    public static boolean loadBooleanProperty(String key, boolean defaultValue) {
        return SessionPropertiesHelper.loadBooleanProperty(systemProperties, key, defaultValue);
    }

    public static boolean loadBooleanProperty(Properties properties, String key, boolean defaultValue) {
        String stringValue = properties.getProperty(key);
        if (stringValue != null) {
            return Boolean.parseBoolean(stringValue);
        }
        return defaultValue;
    }

    public static boolean loadBooleanProperty(String key, boolean defaultValue, boolean definedNotSetValue) {
        return SessionPropertiesHelper.loadBooleanProperty(systemProperties, key, defaultValue);
    }

    public static boolean loadBooleanProperty(Properties properties, String key, boolean defaultValue, boolean definedNotSetValue) {
        String stringValue = properties.getProperty(key);
        if (stringValue != null && stringValue.isEmpty()) {
            return definedNotSetValue;
        }
        if (stringValue != null) {
            return Boolean.parseBoolean(stringValue);
        }
        return defaultValue;
    }

    public static double loadDoubleProperty(String key, double defaultValue) {
        return SessionPropertiesHelper.loadDoubleProperty(systemProperties, key, defaultValue);
    }

    public static double loadDoubleProperty(Properties properties, String key, double defaultValue) {
        String stringValue = properties.getProperty(key);
        if (stringValue != null) {
            try {
                return Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e) {
                LogTools.error((String)"Exception while loading property {}: {}. Using default value.", (Object)key, (Object)e.getMessage());
            }
        }
        return defaultValue;
    }

    public static int loadIntegerProperty(String key, int defaultValue) {
        return SessionPropertiesHelper.loadIntegerProperty(systemProperties, key, defaultValue);
    }

    public static int loadIntegerProperty(Properties properties, String key, int defaultValue) {
        String stringValue = properties.getProperty(key);
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                LogTools.error((String)"Exception while loading property {}: {}. Using default value.", (Object)key, (Object)e.getMessage());
            }
        }
        return defaultValue;
    }

    public static long loadLongProperty(String key, long defaultValue) {
        return SessionPropertiesHelper.loadLongProperty(systemProperties, key, defaultValue);
    }

    public static long loadLongProperty(Properties properties, String key, long defaultValue) {
        String stringValue = properties.getProperty(key);
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                LogTools.error((String)"Exception while loading property {}: {}. Using default value.", (Object)key, (Object)e.getMessage());
            }
        }
        return defaultValue;
    }
}

