/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import us.ihmc.log.LogTools;

public class BehringerMidiHelpers {
    public static boolean DEBUG = false;

    public static Transmitter connectToMidiInDevice(MidiDevice.Info info) {
        MidiDevice midiDevice = BehringerMidiHelpers.getDevice(info);
        if (midiDevice == null) {
            return null;
        }
        if (midiDevice.getMaxTransmitters() == 0 && DEBUG) {
            LogTools.error((String)("Cannot add transmitter to the device: " + String.valueOf(midiDevice)));
            return null;
        }
        if (!BehringerMidiHelpers.openDevice(midiDevice)) {
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)"Device is Now open trying to obtain the transmitter.");
        }
        Transmitter midiIn = null;
        try {
            midiIn = midiDevice.getTransmitter();
        }
        catch (MidiUnavailableException e) {
            midiDevice = null;
            midiIn = null;
            if (DEBUG) {
                LogTools.error((String)"Error getting the device's transmitter.");
                e.printStackTrace();
            }
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)("Obtained a handle to the device transmitter: " + info.getName() + ", description: " + info.getDescription() + ", class name: " + midiDevice.getClass().getSimpleName()));
        }
        return midiIn;
    }

    public static Receiver connectToMidiOutDevice(MidiDevice.Info info) {
        MidiDevice midiDevice = BehringerMidiHelpers.getDevice(info);
        if (midiDevice == null) {
            return null;
        }
        if (midiDevice.getMaxReceivers() == 0 && DEBUG) {
            LogTools.error((String)("Cannot add receiver to the device: " + String.valueOf(midiDevice)));
            return null;
        }
        if (!BehringerMidiHelpers.openDevice(midiDevice)) {
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)"Device is Now open trying to obtain the receiver.");
        }
        Receiver midiOut = null;
        try {
            midiOut = midiDevice.getReceiver();
        }
        catch (MidiUnavailableException e) {
            midiDevice = null;
            midiOut = null;
            if (DEBUG) {
                LogTools.error((String)"Error getting the device's receiver.");
                e.printStackTrace();
            }
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)("Obtained a handle to the devices receiver: " + info.getName() + ", description: " + info.getDescription()));
        }
        return midiOut;
    }

    public static boolean openDevice(MidiDevice midiDevice) {
        if (midiDevice.isOpen()) {
            return true;
        }
        if (DEBUG) {
            LogTools.info((String)("Opening Device: " + String.valueOf(midiDevice)));
        }
        try {
            midiDevice.open();
            return true;
        }
        catch (MidiUnavailableException e) {
            midiDevice = null;
            if (DEBUG) {
                LogTools.error((String)("Unable to open device: " + String.valueOf(midiDevice)));
                e.printStackTrace();
            }
            return false;
        }
    }

    public static MidiDevice getDevice(MidiDevice.Info info) {
        MidiDevice midiDevice;
        try {
            midiDevice = MidiSystem.getMidiDevice(info);
        }
        catch (MidiUnavailableException e) {
            if (DEBUG) {
                LogTools.error((String)"Unable to get a handle to this Midi Device.");
                e.printStackTrace();
            }
            return null;
        }
        return midiDevice;
    }
}

