/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public class BCF2000KnobController {
    private final BCF2000SliderboardController.Knob knob;
    private final Receiver midiOut;
    private final SliderboardVariable controlVariable;
    private int currentKnobValue = -1;
    private int newKnobValue = -1;

    public BCF2000KnobController(BCF2000SliderboardController.Knob knob, Receiver midiOut) {
        this.knob = knob;
        this.midiOut = midiOut;
        this.controlVariable = new SliderboardVariable(knob.getMin(), knob.getMax());
    }

    public boolean handleMessage(ShortMessage message, long timestamp) {
        if (this.knob.getChannel() != message.getData1()) {
            return false;
        }
        this.newKnobValue = MathTools.clamp((int)message.getData2(), (int)this.knob.getMin(), (int)this.knob.getMax());
        return true;
    }

    public void moveSlider(int value) {
        if (value == -1) {
            return;
        }
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(176, 0, this.knob.getChannel(), value);
            this.midiOut.send(message, -1L);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void update() {
        if (this.newKnobValue != -1) {
            this.currentKnobValue = this.newKnobValue;
        }
        if (this.newKnobValue != -1) {
            this.controlVariable.setValue(this.newKnobValue);
            this.newKnobValue = -1;
        } else if (this.controlVariable.getValue() != this.currentKnobValue) {
            this.currentKnobValue = this.controlVariable.getValue();
            this.moveSlider(this.controlVariable.getValue());
        }
    }

    public SliderboardVariable getControlVariable() {
        return this.controlVariable;
    }
}

