/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.messager.Messager;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartDoubleBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIntegerBounds;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeries;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.FillBufferRequest;
import us.ihmc.scs2.sharedMemory.LinkedYoBoolean;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableChartData {
    private final LinkedYoVariable<?> linkedYoVariable;
    private SessionMode lastSessionModeStatus = null;
    private final AtomicReference<SessionMode> currentSessionMode;
    private YoBufferPropertiesReadOnly lastProperties = null;
    private final AtomicReference<BufferSample> rawDataProperty = new AtomicReference<Object>(null);
    private final AtomicBoolean hasChartData = new AtomicBoolean(false);
    private int lastUpdateEndIndex = -1;
    private DoubleArray lastDataSet;
    private ChartDataUpdate lastChartDataUpdate;
    private final Queue<Object> callerIDs = new ConcurrentLinkedQueue<Object>();
    private final Map<Object, ChartDataUpdate> newChartDataUpdate = new ConcurrentHashMap<Object, ChartDataUpdate>();
    private final AtomicBoolean requestEntireBuffer = new AtomicBoolean(true);
    private final AtomicBoolean requestUpdateBounds = new AtomicBoolean(false);
    private final Function<BufferSample<double[]>, BufferSample> bufferConverterFunction;
    private final TopicListener<CropBufferRequest> cropRequestListener = m -> this.requestEntireBuffer.set(true);
    private final TopicListener<FillBufferRequest> fillRequestListener = m -> this.requestEntireBuffer.set(true);
    private final TopicListener<YoBufferPropertiesReadOnly> propertiesListener;
    private final Messager messager;
    private final SessionVisualizerTopics topics;

    public YoVariableChartData(Messager messager, SessionVisualizerTopics topics, LinkedYoVariable<?> linkedYoVariable) {
        this.messager = messager;
        this.topics = topics;
        this.linkedYoVariable = linkedYoVariable;
        linkedYoVariable.addUser((Object)this);
        this.currentSessionMode = messager.createInput(topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
        if (linkedYoVariable instanceof LinkedYoBoolean) {
            this.bufferConverterFunction = in -> YoVariableChartData.booleanToDoubleBuffer(in);
        } else if (linkedYoVariable instanceof LinkedYoDouble) {
            this.bufferConverterFunction = in -> in;
        } else if (linkedYoVariable instanceof LinkedYoEnum) {
            this.bufferConverterFunction = in -> YoVariableChartData.byteToDoubleBuffer(in);
        } else if (linkedYoVariable instanceof LinkedYoInteger) {
            this.bufferConverterFunction = in -> YoVariableChartData.integerToDoubleBuffer(in);
        } else if (linkedYoVariable instanceof LinkedYoLong) {
            this.bufferConverterFunction = in -> YoVariableChartData.longToDoubleBuffer(in);
        } else {
            throw new UnsupportedOperationException("Unsupported YoVariable type: " + linkedYoVariable.getLinkedYoVariable().getClass().getSimpleName());
        }
        this.propertiesListener = m -> {
            if (this.lastProperties == null) {
                this.requestEntireBuffer.set(true);
            } else if (this.lastProperties.getSize() != m.getSize()) {
                this.requestEntireBuffer.set(true);
            } else if (m.getInPoint() != this.lastProperties.getInPoint()) {
                if (m.getOutPoint() != this.lastProperties.getOutPoint()) {
                    linkedYoVariable.requestEntireBuffer();
                } else {
                    this.requestUpdateBounds.set(this.lastDataSet != null);
                }
            } else if (m.getOutPoint() != this.lastProperties.getOutPoint()) {
                this.requestUpdateBounds.set(this.lastDataSet != null);
            }
            this.lastProperties = m;
        };
        messager.registerTopicListener(topics.getYoBufferCropRequest(), this.cropRequestListener);
        messager.registerTopicListener(topics.getYoBufferFillRequest(), this.fillRequestListener);
        messager.registerTopicListener(topics.getYoBufferCurrentProperties(), this.propertiesListener);
    }

    public void dispose() {
        this.linkedYoVariable.removeUser((Object)this);
        this.messager.removeInput(this.topics.getSessionCurrentMode(), this.currentSessionMode);
        this.messager.removeTopicListener(this.topics.getYoBufferCropRequest(), this.cropRequestListener);
        this.messager.removeTopicListener(this.topics.getYoBufferFillRequest(), this.fillRequestListener);
        this.messager.removeTopicListener(this.topics.getYoBufferCurrentProperties(), this.propertiesListener);
    }

    public boolean updateVariableData() {
        return this.linkedYoVariable.pull();
    }

    public void updateBufferData() {
        BufferSample newRawData = this.linkedYoVariable.pollRequestedBufferSample();
        if (newRawData != null) {
            this.rawDataProperty.set(newRawData);
            this.hasChartData.set(true);
            this.lastUpdateEndIndex = newRawData.getBufferProperties().getOutPoint();
        }
        if (this.lastSessionModeStatus == SessionMode.RUNNING && this.currentSessionMode.get() != SessionMode.RUNNING) {
            this.linkedYoVariable.requestBufferStartingFrom(this.lastUpdateEndIndex);
        } else if (this.callerIDs.stream().anyMatch(callerID -> !this.hasNewChartData(callerID))) {
            if (this.requestEntireBuffer.getAndSet(false)) {
                this.linkedYoVariable.requestEntireBuffer();
            } else if (this.lastSessionModeStatus != SessionMode.RUNNING && this.currentSessionMode.get() == SessionMode.RUNNING) {
                this.linkedYoVariable.requestActiveBufferOnly();
            } else if (this.currentSessionMode.get() == SessionMode.RUNNING) {
                if (this.lastUpdateEndIndex == -1) {
                    this.linkedYoVariable.requestActiveBufferOnly();
                } else {
                    this.linkedYoVariable.requestBufferStartingFrom(this.lastUpdateEndIndex);
                }
            }
        }
        this.lastSessionModeStatus = this.currentSessionMode.get();
        this.publishForCharts();
    }

    private void publishForCharts() {
        ChartDataUpdate chartDataUpdate;
        DoubleArray dataSet;
        boolean updateBounds = this.requestUpdateBounds.getAndSet(false);
        if (!this.hasChartData.get() && !updateBounds) {
            return;
        }
        BufferSample rawData = this.rawDataProperty.get();
        if (rawData == null || rawData.getSampleLength() == 0) {
            return;
        }
        BufferSample newBufferSample = this.bufferConverterFunction.apply((BufferSample<double[]>)rawData);
        if (this.lastDataSet != null && newBufferSample.getBufferProperties().getSize() != this.lastDataSet.size) {
            this.lastDataSet = null;
        }
        if (this.hasChartData.get()) {
            dataSet = YoVariableChartData.updateDataSet(this.lastDataSet, (BufferSample<double[]>)newBufferSample);
        } else if (updateBounds) {
            dataSet = YoVariableChartData.updateBounds(this.lastProperties, this.lastDataSet);
        } else {
            throw new IllegalStateException("Should not get here.");
        }
        this.lastChartDataUpdate = chartDataUpdate = new ChartDataUpdate(dataSet, rawData.getBufferProperties());
        if (dataSet != null) {
            this.callerIDs.forEach(callerID -> this.newChartDataUpdate.put(callerID, chartDataUpdate));
            this.lastDataSet = dataSet;
        }
        this.hasChartData.set(false);
    }

    public void registerCaller(Object callerID) {
        this.callerIDs.add(callerID);
        if (this.lastDataSet != null) {
            this.newChartDataUpdate.put(callerID, this.lastChartDataUpdate);
        }
    }

    public void removeCaller(Object callerID) {
        this.callerIDs.remove(callerID);
        this.newChartDataUpdate.remove(callerID);
    }

    public boolean hasNewChartData(Object callerID) {
        return this.newChartDataUpdate.get(callerID) != null;
    }

    public ChartDataUpdate pollChartData(Object callerID) {
        if (this.newChartDataUpdate.isEmpty()) {
            return null;
        }
        return this.newChartDataUpdate.remove(callerID);
    }

    public YoVariable getYoVariable() {
        return this.linkedYoVariable.getLinkedYoVariable();
    }

    public boolean isCurrentlyInUse() {
        return !this.callerIDs.isEmpty();
    }

    public static DoubleArray updateDataSet(DoubleArray lastDataSet, BufferSample<double[]> bufferSample) {
        int sampleLength = bufferSample.getSampleLength();
        YoBufferPropertiesReadOnly bufferProperties = bufferSample.getBufferProperties();
        int bufferSize = bufferProperties.getSize();
        if (bufferSample == null || sampleLength == 0) {
            return null;
        }
        DoubleArray dataSet = new DoubleArray(bufferSize);
        dataSet.values[0] = YoVariableChartData.getValueAt(0, lastDataSet, bufferSample);
        for (int i = 1; i < bufferSize; ++i) {
            dataSet.values[i] = YoVariableChartData.getValueAt(i, lastDataSet, bufferSample);
        }
        return YoVariableChartData.updateBounds(bufferProperties, dataSet);
    }

    private static DoubleArray updateBounds(YoBufferPropertiesReadOnly bufferProperties, DoubleArray dataSet) {
        double yCurrent;
        if (bufferProperties.getSize() != dataSet.size) {
            return null;
        }
        int index = bufferProperties.getInPoint();
        double yMin = yCurrent = dataSet.values[index];
        double yMax = yCurrent;
        for (int i = 1; i < bufferProperties.getActiveBufferLength(); ++i) {
            index = SharedMemoryTools.increment((int)index, (int)1, (int)bufferProperties.getSize());
            yCurrent = dataSet.values[index];
            yMin = Math.min(yMin, yCurrent);
            yMax = Math.max(yMax, yCurrent);
        }
        dataSet.valueMin = yMin;
        dataSet.valueMax = yMax;
        return dataSet;
    }

    private static double getValueAt(int index, DoubleArray completeDataSet, BufferSample<double[]> partialBufferSample) {
        double[] sample = (double[])partialBufferSample.getSample();
        int sampleStart = partialBufferSample.getFrom();
        int sampleEnd = partialBufferSample.getTo();
        int bufferSize = partialBufferSample.getBufferProperties().getSize();
        double y = 0.0;
        if (sampleStart <= sampleEnd) {
            if (index >= sampleStart && index <= sampleEnd) {
                y = sample[index - sampleStart];
            } else if (completeDataSet != null) {
                y = completeDataSet.values[index];
            }
        } else if (index <= sampleEnd) {
            y = sample[index - sampleStart + bufferSize];
        } else if (index >= sampleStart) {
            y = sample[index - sampleStart];
        } else if (completeDataSet != null) {
            y = completeDataSet.values[index];
        }
        if (!Double.isFinite(y)) {
            y = 0.0;
        }
        return y;
    }

    private static BufferSample<double[]> booleanToDoubleBuffer(BufferSample<?> yoVariableBuffer) {
        int from = yoVariableBuffer.getFrom();
        YoBufferPropertiesReadOnly bufferProperties = yoVariableBuffer.getBufferProperties();
        double[] sample = SharedMemoryTools.toDoubleArray((boolean[])((boolean[])yoVariableBuffer.getSample()));
        int sampleLength = yoVariableBuffer.getSampleLength();
        return new BufferSample(from, (Object)sample, sampleLength, bufferProperties);
    }

    private static BufferSample<double[]> byteToDoubleBuffer(BufferSample<?> yoVariableBuffer) {
        int from = yoVariableBuffer.getFrom();
        YoBufferPropertiesReadOnly bufferProperties = yoVariableBuffer.getBufferProperties();
        double[] sample = SharedMemoryTools.toDoubleArray((byte[])((byte[])yoVariableBuffer.getSample()));
        int sampleLength = yoVariableBuffer.getSampleLength();
        return new BufferSample(from, (Object)sample, sampleLength, bufferProperties);
    }

    private static BufferSample<double[]> integerToDoubleBuffer(BufferSample<?> yoVariableBuffer) {
        int from = yoVariableBuffer.getFrom();
        YoBufferPropertiesReadOnly bufferProperties = yoVariableBuffer.getBufferProperties();
        double[] sample = SharedMemoryTools.toDoubleArray((int[])((int[])yoVariableBuffer.getSample()));
        int sampleLength = yoVariableBuffer.getSampleLength();
        return new BufferSample(from, (Object)sample, sampleLength, bufferProperties);
    }

    private static BufferSample<double[]> longToDoubleBuffer(BufferSample<?> yoVariableBuffer) {
        int from = yoVariableBuffer.getFrom();
        YoBufferPropertiesReadOnly bufferProperties = yoVariableBuffer.getBufferProperties();
        double[] sample = SharedMemoryTools.toDoubleArray((long[])((long[])yoVariableBuffer.getSample()));
        int sampleLength = yoVariableBuffer.getSampleLength();
        return new BufferSample(from, (Object)sample, sampleLength, bufferProperties);
    }

    private static class DoubleArray {
        private final int size;
        private final double[] values;
        private double valueMin;
        private double valueMax;

        public DoubleArray(int size) {
            this.size = size;
            this.values = new double[size];
        }
    }

    public static class ChartDataUpdate {
        private final DoubleArray dataSet;
        private final YoBufferPropertiesReadOnly bufferProperties;

        public ChartDataUpdate(DoubleArray dataSet, YoBufferPropertiesReadOnly bufferProperties) {
            this.dataSet = dataSet;
            this.bufferProperties = bufferProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readUpdate(NumberSeries chartDataSet, int lastUpdateEndIndex) {
            chartDataSet.getLock().writeLock().lock();
            try {
                while (chartDataSet.getData().size() < this.dataSet.size) {
                    chartDataSet.getData().add(new Point2D());
                }
                while (chartDataSet.getData().size() > this.dataSet.size) {
                    chartDataSet.getData().remove(chartDataSet.getData().size() - 1);
                }
                for (int i = 0; i < this.dataSet.size; ++i) {
                    chartDataSet.getData().get(i).set((double)i, this.dataSet.values[i]);
                }
                chartDataSet.bufferCurrentIndexProperty().set(this.bufferProperties.getCurrentIndex());
                chartDataSet.xBoundsProperty().setValue((Object)new ChartIntegerBounds(0, this.dataSet.size));
                chartDataSet.yBoundsProperty().setValue((Object)new ChartDoubleBounds(this.dataSet.valueMin, this.dataSet.valueMax));
            }
            finally {
                chartDataSet.getLock().writeLock().unlock();
                chartDataSet.markDirty();
            }
        }

        public int getUpdateEndIndex() {
            return this.bufferProperties.getOutPoint();
        }
    }
}

