/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.SearchEngines;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search.YoRegistryTreeCell;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ContextMenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TreeViewTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableTools;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoRegistrySearchPaneController
extends ObservedAnimationTimer {
    @FXML
    private TextField searchTextField;
    @FXML
    private TreeView<YoRegistry> registryTreeView;
    private List<YoRegistry> allRegistries;
    private TreeItem<YoRegistry> defaultRootItem;
    private TreeItem<YoRegistry> searchResult = null;
    private boolean showRoot = true;
    private Property<Boolean> showSCS2YoVariables;
    private Predicate<YoRegistry> scs2InternalRegistryFilter;
    private AtomicReference<SearchEngines> activeSearchEngine;
    private YoRegistry rootRegistry;
    private Future<TreeItem<YoRegistry>> backgroundSearch;
    private boolean refreshRootRegistry;
    private YoManager yoManager;
    private BackgroundExecutorManager backgroundExecutorManager;
    private Consumer<YoRegistry> registryViewRequestConsumer = null;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.yoManager = toolkit.getYoManager();
        this.backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.registryTreeView.setCellFactory(param -> new YoRegistryTreeCell());
        this.registryTreeView.setRoot(this.defaultRootItem);
        BufferedJavaFXMessager messager = toolkit.getMessager();
        SessionVisualizerTopics topics = toolkit.getTopics();
        ContextMenuTools.setupContextMenu(this.registryTreeView, new Function[]{treeView -> {
            MenuItem openStatisticsMenuItem = new MenuItem("Open statistics...");
            openStatisticsMenuItem.setOnAction(e -> {
                TreeItem selectedRegistry = (TreeItem)treeView.getSelectionModel().getSelectedItem();
                if (selectedRegistry == null) {
                    return;
                }
                messager.submitMessage(topics.getOpenWindowRequest(), SecondaryWindowManager.NewWindowRequest.registryStatisticWindow((Window)toolkit.getMainWindow(), (YoRegistry)selectedRegistry.getValue()));
            });
            return openStatisticsMenuItem;
        }});
        this.yoManager.rootRegistryChangeCounter().addListener((o, oldValue, newValue) -> {
            this.refreshRootRegistry = true;
        });
        this.searchTextField.textProperty().addListener((observable, oldValue, newValue) -> this.search((String)newValue));
        this.activeSearchEngine = messager.createInput(topics.getYoSearchEngine(), (Object)SearchEngines.DEFAULT);
        messager.registerJavaFXSyncedTopicListener(topics.getSessionCurrentState(), state -> {
            if (state == SessionState.ACTIVE) {
                this.refreshRootRegistry = true;
                this.start();
            } else if (state == SessionState.INACTIVE) {
                this.stop();
                this.searchResult = null;
                this.allRegistries = Collections.emptyList();
                this.defaultRootItem = new TreeItem();
                this.registryTreeView.setRoot(this.defaultRootItem);
                this.searchTextField.clear();
            }
        });
        this.showSCS2YoVariables = messager.createPropertyInput(topics.getShowSCS2YoVariables(), false);
        this.showSCS2YoVariables.addListener((o, oldValue, newValue) -> {
            this.refreshRootRegistry = true;
        });
        this.scs2InternalRegistryFilter = reg -> (Boolean)this.showSCS2YoVariables.getValue() != false || !reg.getNamespace().equals((Object)Session.SESSION_INTERNAL_NAMESPACE);
    }

    public void requestFocusForSearchBox() {
        this.searchTextField.requestFocus();
    }

    public void setRegistryViewRequestConsumer(Consumer<YoRegistry> consumer) {
        this.registryViewRequestConsumer = consumer;
    }

    private void refreshRootRegistry() {
        this.rootRegistry = this.yoManager.getRootRegistry();
        if (this.rootRegistry == null) {
            this.refreshRootRegistry = true;
            this.allRegistries = null;
            this.defaultRootItem = null;
        } else {
            this.allRegistries = this.rootRegistry.collectSubtreeRegistries();
            this.defaultRootItem = new TreeItem((Object)this.rootRegistry);
            YoRegistrySearchPaneController.buildTreeRecursively(this.defaultRootItem, this.scs2InternalRegistryFilter);
        }
    }

    @Override
    public void handleImpl(long now) {
        if (this.backgroundSearch != null && this.backgroundSearch.isDone() && !this.backgroundSearch.isCancelled()) {
            try {
                this.searchResult = this.backgroundSearch.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (this.searchResult != null) {
            this.registryTreeView.setShowRoot(this.showRoot);
            this.registryTreeView.setRoot(this.searchResult);
            this.searchResult = null;
        }
        if (this.refreshRootRegistry) {
            this.refreshRootRegistry = false;
            this.refreshRootRegistry();
            if (!this.refreshRootRegistry) {
                this.search(this.searchTextField.getText());
            }
        }
    }

    private void search(String searchQuery) {
        if (this.backgroundSearch != null) {
            this.backgroundSearch.cancel(true);
            this.backgroundSearch = null;
        }
        if (searchQuery != null && !searchQuery.isEmpty()) {
            this.backgroundSearch = this.backgroundExecutorManager.executeInBackground(() -> {
                if (this.allRegistries == null) {
                    this.refreshRootRegistry = true;
                    return null;
                }
                return this.createRootItemForRegistries(YoVariableTools.search(this.allRegistries, registry -> registry.getNamespace().getName(), searchQuery, YoVariableTools.fromSearchEnginesEnum(this.activeSearchEngine.get()), Integer.MAX_VALUE, Collectors.toSet()));
            });
        } else {
            this.searchResult = this.defaultRootItem;
            this.showRoot = false;
        }
    }

    @FXML
    void openRegistryTab(InputEvent inputEvent) {
        TreeItem selectedItem;
        if (this.registryViewRequestConsumer == null) {
            return;
        }
        boolean performOpenAction = false;
        if (inputEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            performOpenAction = mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2;
        } else if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            boolean bl = performOpenAction = keyEvent.getCode() == KeyCode.ENTER;
        }
        if (performOpenAction && (selectedItem = (TreeItem)this.registryTreeView.getSelectionModel().getSelectedItem()) != null) {
            this.registryViewRequestConsumer.accept((YoRegistry)selectedItem.getValue());
            inputEvent.consume();
        }
    }

    private TreeItem<YoRegistry> createRootItemForRegistries(Set<YoRegistry> subSelection) {
        TreeItem root = new TreeItem((Object)this.rootRegistry);
        YoRegistrySearchPaneController.buildTreeRecursively((TreeItem<YoRegistry>)root, this.scs2InternalRegistryFilter);
        YoRegistrySearchPaneController.filterRegistries((TreeItem<YoRegistry>)root, subSelection);
        TreeViewTools.expandRecursively(root);
        return root;
    }

    private static void filterRegistries(TreeItem<YoRegistry> parent, Set<YoRegistry> registriesToKeep) {
        if (parent == null || parent.isLeaf()) {
            return;
        }
        for (TreeItem child : parent.getChildren()) {
            if (child.getChildren().isEmpty()) continue;
            YoRegistrySearchPaneController.filterRegistries((TreeItem<YoRegistry>)child, registriesToKeep);
        }
        for (int i = parent.getChildren().size() - 1; i >= 0; --i) {
            TreeItem child;
            child = (TreeItem)parent.getChildren().get(i);
            if (!child.isLeaf() || child.getValue() == null || registriesToKeep.contains(child.getValue())) continue;
            parent.getChildren().remove(i);
        }
    }

    private static void buildTreeRecursively(TreeItem<YoRegistry> parent, Predicate<YoRegistry> registryFilter) {
        List children = ((YoRegistry)parent.getValue()).getChildren();
        for (int i = 0; i < children.size(); ++i) {
            YoRegistry child = (YoRegistry)children.get(i);
            if (!registryFilter.test(child)) continue;
            TreeItem childItem = new TreeItem((Object)child);
            parent.getChildren().add((Object)childItem);
            YoRegistrySearchPaneController.buildTreeRecursively((TreeItem<YoRegistry>)childItem, registryFilter);
        }
    }
}

