/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import com.jfoenix.controls.JFXTextField;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Slider;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000InputController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBCF2000SliderController
extends YoBCF2000InputController {
    @FXML
    private VBox rootPane;
    @FXML
    private JFXTextField sliderMaxTextField;
    @FXML
    private JFXTextField sliderMinTextField;
    @FXML
    private Slider slider;
    @FXML
    private Label yoVariableDropLabel;
    private SliderboardVariable sliderVariable;
    private YoVariableSlider yoVariableSlider;
    private YoManager yoManager;

    public void initialize(SessionVisualizerToolkit toolkit, SliderboardVariable sliderVariable) {
        this.sliderVariable = sliderVariable;
        this.yoManager = toolkit.getYoManager();
        super.initialize(toolkit, (Region)this.rootPane, (Labeled)this.yoVariableDropLabel);
        this.sliderMaxTextField.setText("");
        this.sliderMinTextField.setText("");
        this.sliderMaxTextField.setDisable(true);
        this.sliderMinTextField.setDisable(true);
        this.slider.setDisable(true);
    }

    public void setInput(YoSliderDefinition definition) {
        YoVariable yoVariable;
        if (definition == null) {
            this.setYoVariableInput(null);
            return;
        }
        if (definition.getVariableName() != null) {
            yoVariable = this.yoManager.getRootRegistryDatabase().searchExact(definition.getVariableName());
            if (yoVariable == null) {
                LogTools.warn((String)("Could not find variable for slider: " + definition.getVariableName()));
            }
        } else {
            yoVariable = null;
        }
        this.setYoVariableInput(yoVariable, definition.getMinValue(), definition.getMaxValue());
    }

    @Override
    public void setYoVariableInput(YoVariable yoVariable) {
        this.setYoVariableInput(yoVariable, null, null);
    }

    private void setYoVariableInput(YoVariable yoVariable, String minValue, String maxValue) {
        if (this.yoVariableSlider != null) {
            this.yoVariableSlider.dispose();
        }
        if (yoVariable != null) {
            this.slider.setDisable(false);
            this.yoVariableSlider = YoVariableSlider.newYoVariableSlider(yoVariable, this.yoManager.getLinkedRootRegistry());
            this.yoVariableSlider.bindMinTextField(this.sliderMinTextField);
            this.yoVariableSlider.bindMaxTextField(this.sliderMaxTextField);
            if (this.sliderVariable != null) {
                this.yoVariableSlider.bindSliderVariable(this.sliderVariable);
            }
            this.yoVariableSlider.bindVirtualSlider(this.slider);
            if (minValue != null && !this.sliderMinTextField.isDisabled()) {
                this.sliderMinTextField.setText(minValue);
            }
            if (maxValue != null && !this.sliderMaxTextField.isDisabled()) {
                this.sliderMaxTextField.setText(maxValue);
            }
            this.setupYoVariableSlider(this.yoVariableSlider);
        } else {
            this.clear();
            this.slider.setDisable(true);
            this.yoVariableSlider = null;
            this.sliderMaxTextField.setText("");
            this.sliderMinTextField.setText("");
        }
    }

    public void close() {
        this.setYoVariableInput(null);
    }

    public YoSliderDefinition toYoSliderDefinition() {
        return this.yoVariableSlider == null ? new YoSliderDefinition() : this.yoVariableSlider.toYoSliderDefinition();
    }
}

