/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.definition;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.ModelImporter;
import com.interactivemesh.jfx.importer.col.ColAsset;
import com.interactivemesh.jfx.importer.col.ColImportOption;
import com.interactivemesh.jfx.importer.col.ColModelImporter;
import com.interactivemesh.jfx.importer.obj.ObjImportOption;
import com.interactivemesh.jfx.importer.obj.ObjModelImporter;
import com.interactivemesh.jfx.importer.stl.StlMeshImporter;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.apache.commons.io.FilenameUtils;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.AffineTransformDefinition;
import us.ihmc.scs2.definition.geometry.ArcTorus3DDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.HemiEllipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Ramp3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.Torus3DDefinition;
import us.ihmc.scs2.definition.geometry.TruncatedCone3DDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.sessionVisualizer.TriangleMesh3DFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;

public class JavaFXVisualTools {
    private static final Map<Long, PhongMaterial> cachedNamedColladaMaterials = new ConcurrentHashMap<Long, PhongMaterial>();
    private static final Map<Long, PhongMaterial> cachedNamedOBJMaterials = new ConcurrentHashMap<Long, PhongMaterial>();
    private static final Map<String, CachedImportedModel> cachedColladaModels = new ConcurrentHashMap<String, CachedImportedModel>();
    private static final Map<String, CachedImportedModel> cachedOBJModels = new ConcurrentHashMap<String, CachedImportedModel>();
    private static final Rotate ROTATE_PI_X = new Rotate(180.0, Rotate.X_AXIS);
    private static final Color DEFAULT_COLOR = Color.DARKBLUE;
    private static final Material DEFAULT_MATERIAL = new PhongMaterial(DEFAULT_COLOR);
    private static final Shape3D DEFAULT_GEOMETRY = null;
    private static final Box DEFAULT_BOX = null;
    private static final Cylinder DEFAULT_CYLINDER = null;
    private static final Sphere DEFAULT_SPHERE = null;
    private static final Node[] DEFAULT_MESH_VIEWS = null;
    public static final List<String> colorNameList;

    public static Node collectNodes(List<VisualDefinition> visualDefinitions) {
        return JavaFXVisualTools.collectNodes(visualDefinitions, null);
    }

    public static Node collectNodes(List<VisualDefinition> visualDefinitions, ClassLoader resourceClassLoader) {
        List nodes = visualDefinitions.stream().map(definition -> JavaFXVisualTools.toNode(definition, resourceClassLoader)).filter(node -> node != null).collect(Collectors.toList());
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return (Node)nodes.get(0);
        }
        return new Group(nodes);
    }

    public static Node toNode(VisualDefinition visualDefinition, ClassLoader resourceClassLoader) {
        Node node = JavaFXVisualTools.toShape3D(visualDefinition.getGeometryDefinition(), visualDefinition.getMaterialDefinition(), resourceClassLoader);
        AffineTransformDefinition originPose = visualDefinition.getOriginPose();
        if (node != null && originPose != null && (originPose.hasTranslation() || originPose.hasLinearTransform())) {
            Affine nodeAffine = new Affine();
            JavaFXTools.convertEuclidAffineToJavaFXAffine((AffineTransform)originPose, (Affine)nodeAffine);
            node.getTransforms().add(0, (Object)nodeAffine);
        }
        return node;
    }

    public static Node toShape3D(GeometryDefinition geometryDefinition, MaterialDefinition materialDefinition, ClassLoader resourceClassLoader) {
        if (geometryDefinition == null) {
            return DEFAULT_GEOMETRY;
        }
        if (geometryDefinition instanceof ArcTorus3DDefinition) {
            MeshView arcTorus = JavaFXVisualTools.toArcTorus((ArcTorus3DDefinition)geometryDefinition);
            arcTorus.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return arcTorus;
        }
        if (geometryDefinition instanceof Box3DDefinition) {
            Box box = JavaFXVisualTools.toBox((Box3DDefinition)geometryDefinition);
            box.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return box;
        }
        if (geometryDefinition instanceof Capsule3DDefinition) {
            MeshView capsule = JavaFXVisualTools.toCapsule((Capsule3DDefinition)geometryDefinition);
            capsule.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return capsule;
        }
        if (geometryDefinition instanceof Cone3DDefinition) {
            MeshView cone = JavaFXVisualTools.toCone((Cone3DDefinition)geometryDefinition);
            cone.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return cone;
        }
        if (geometryDefinition instanceof Cylinder3DDefinition) {
            Shape3D cylinder = JavaFXVisualTools.toCylinder((Cylinder3DDefinition)geometryDefinition);
            cylinder.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return cylinder;
        }
        if (geometryDefinition instanceof Ellipsoid3DDefinition) {
            MeshView ellipsoid = JavaFXVisualTools.toEllipsoid((Ellipsoid3DDefinition)geometryDefinition);
            ellipsoid.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return ellipsoid;
        }
        if (geometryDefinition instanceof TruncatedCone3DDefinition) {
            MeshView genTruncatedCone = JavaFXVisualTools.toGenTruncatedCone((TruncatedCone3DDefinition)geometryDefinition);
            genTruncatedCone.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return genTruncatedCone;
        }
        if (geometryDefinition instanceof HemiEllipsoid3DDefinition) {
            MeshView hemiEllipsoid = JavaFXVisualTools.toHemiEllipsoid((HemiEllipsoid3DDefinition)geometryDefinition);
            hemiEllipsoid.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return hemiEllipsoid;
        }
        if (geometryDefinition instanceof Sphere3DDefinition) {
            Sphere sphere = JavaFXVisualTools.toSphere((Sphere3DDefinition)geometryDefinition);
            sphere.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return sphere;
        }
        if (geometryDefinition instanceof Torus3DDefinition) {
            MeshView torus = JavaFXVisualTools.toTorus((Torus3DDefinition)geometryDefinition);
            torus.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return torus;
        }
        if (geometryDefinition instanceof Ramp3DDefinition) {
            MeshView ramp = JavaFXVisualTools.toRamp((Ramp3DDefinition)geometryDefinition);
            ramp.setMaterial(JavaFXVisualTools.toMaterial(materialDefinition, resourceClassLoader));
            return ramp;
        }
        if (geometryDefinition instanceof ModelFileGeometryDefinition) {
            Node[] nodes = JavaFXVisualTools.importModel((ModelFileGeometryDefinition)geometryDefinition, resourceClassLoader);
            if (nodes == null) {
                return null;
            }
            return nodes.length == 1 ? nodes[0] : new Group(nodes);
        }
        return DEFAULT_GEOMETRY;
    }

    public static MeshView toArcTorus(ArcTorus3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition(TriangleMesh3DFactories.TriangleMesh((GeometryDefinition)geometryDefinition));
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static Box toBox(Box3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return DEFAULT_BOX;
        }
        Box box = new Box(geometryDefinition.getSizeX(), geometryDefinition.getSizeY(), geometryDefinition.getSizeZ());
        if (!geometryDefinition.isCentered()) {
            box.getTransforms().add((Object)new Translate(0.0, 0.0, 0.5 * geometryDefinition.getSizeZ()));
        }
        return box;
    }

    public static MeshView toCapsule(Capsule3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)geometryDefinition);
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static MeshView toCone(Cone3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)geometryDefinition);
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static Shape3D toCylinder(Cylinder3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return DEFAULT_CYLINDER;
        }
        Cylinder cylinder = new Cylinder(geometryDefinition.getRadius(), geometryDefinition.getLength());
        cylinder.getTransforms().add((Object)new Rotate(90.0, Rotate.X_AXIS));
        return cylinder;
    }

    public static MeshView toEllipsoid(Ellipsoid3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)geometryDefinition);
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static MeshView toGenTruncatedCone(TruncatedCone3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)geometryDefinition);
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static MeshView toHemiEllipsoid(HemiEllipsoid3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)geometryDefinition);
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static Sphere toSphere(Sphere3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return DEFAULT_SPHERE;
        }
        return new Sphere(geometryDefinition.getRadius());
    }

    public static MeshView toTorus(Torus3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)geometryDefinition);
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static MeshView toRamp(Ramp3DDefinition geometryDefinition) {
        if (geometryDefinition == null) {
            return null;
        }
        TriangleMesh mesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition((GeometryDefinition)geometryDefinition);
        MeshView meshView = new MeshView((Mesh)mesh);
        return meshView;
    }

    public static Node[] importModel(ModelFileGeometryDefinition geometryDefinition, ClassLoader resourceClassLoader) {
        URL fileURL;
        if (geometryDefinition == null || geometryDefinition.getFileName() == null) {
            return DEFAULT_MESH_VIEWS;
        }
        String filename = geometryDefinition.getFileName();
        if (resourceClassLoader == null) {
            resourceClassLoader = JavaFXTools.class.getClassLoader();
        }
        if ((fileURL = resourceClassLoader.getResource(filename)) == null) {
            File file = new File(filename);
            try {
                fileURL = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        Node[] importedModel = JavaFXVisualTools.importModel(fileURL);
        Vector3D scale = geometryDefinition.getScale();
        if (scale != null && importedModel != null && importedModel.length > 0) {
            if (importedModel.length == 1) {
                importedModel[0].getTransforms().add((Object)new Scale(scale.getX(), scale.getY(), scale.getZ()));
            } else {
                Group group = new Group(importedModel);
                group.getTransforms().add((Object)new Scale(scale.getX(), scale.getY(), scale.getZ()));
                importedModel = new Node[]{group};
            }
        }
        return importedModel;
    }

    public static Node[] importModel(URL fileURL) {
        try {
            String fileExtension;
            String file = fileURL.getFile();
            Node[] importedNodes = switch (fileExtension = FilenameUtils.getExtension((String)file).toLowerCase()) {
                case "dae" -> JavaFXVisualTools.importColladaModel(fileURL);
                case "stl" -> JavaFXVisualTools.importSTLModel(fileURL);
                case "obj" -> JavaFXVisualTools.importOBJModel(fileURL);
                default -> DEFAULT_MESH_VIEWS;
            };
            JavaFXVisualTools.setNodeIDs(importedNodes, FilenameUtils.getBaseName((String)file), true);
            return importedNodes;
        }
        catch (Exception e) {
            LogTools.error((String)("Could not import model file: " + fileURL.toExternalForm() + "\n " + e.getClass().getSimpleName() + ": " + e.getMessage()));
            return null;
        }
    }

    public static Node[] importColladaModel(URL fileURL) {
        MeshView[] importedModel;
        CachedImportedModel cachedImportedModel = cachedColladaModels.get(fileURL.toExternalForm());
        if (cachedImportedModel == null) {
            ColModelImporter importer = new ColModelImporter();
            importer.getOptions().add(ColImportOption.IGNORE_LIGHTS);
            importer.getOptions().add(ColImportOption.IGNORE_CAMERAS);
            importer.getOptions().add(ColImportOption.GENERATE_NORMALS);
            importer.read(fileURL);
            ColAsset asset = importer.getAsset();
            importedModel = JavaFXVisualTools.unwrapGroups(importer.getImport(), MeshView.class).toArray(new MeshView[0]);
            Stream.of(importedModel).forEach(model -> model.getTransforms().add(0, (Object)new Rotate(-90.0, Rotate.X_AXIS)));
            if (!EuclidCoreTools.epsilonEquals((double)1.0, (double)asset.getUnitMeter(), (double)0.001)) {
                Stream.of(importedModel).forEach(model -> model.getTransforms().add(0, (Object)new Scale((double)asset.getUnitMeter(), (double)asset.getUnitMeter(), (double)asset.getUnitMeter())));
            }
            JavaFXVisualTools.cacheMaterials((ModelImporter)importer, importedModel, cachedNamedColladaMaterials);
            cachedColladaModels.put(fileURL.toExternalForm(), new CachedImportedModel(importedModel));
            importer.close();
        } else {
            importedModel = cachedImportedModel.newMeshViews();
        }
        return importedModel;
    }

    public static Node[] importSTLModel(URL fileURL) {
        StlMeshImporter importer = new StlMeshImporter();
        importer.read(fileURL);
        MeshView meshView = new MeshView((Mesh)importer.getImport());
        meshView.getTransforms().add((Object)ROTATE_PI_X);
        importer.close();
        return new Node[]{meshView};
    }

    public static Node[] importOBJModel(URL fileURL) throws URISyntaxException, IOException {
        MeshView[] importedModel;
        String externalForm = fileURL.toExternalForm();
        CachedImportedModel cachedImportedModel = cachedOBJModels.get(externalForm);
        if (cachedImportedModel == null) {
            ObjModelImporter importer;
            block10: {
                importer = new ObjModelImporter();
                importer.setOptions(new ObjImportOption[]{ObjImportOption.GENERATE_NORMALS});
                try {
                    importer.read(fileURL);
                }
                catch (ImportException e) {
                    String line;
                    if (!e.getMessage().contains("Material not found")) break block10;
                    String filePath = fileURL.getPath();
                    File tempFileWithoutMTL = new File(filePath.substring(0, filePath.lastIndexOf(".")) + "Temp.obj");
                    if (tempFileWithoutMTL.exists()) {
                        throw e;
                    }
                    tempFileWithoutMTL.createNewFile();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(fileURL.toURI())));
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFileWithoutMTL)));
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.toLowerCase().startsWith("mtllib") || line.toLowerCase().startsWith("usemtl")) continue;
                        try {
                            bufferedWriter.write(line);
                            bufferedWriter.newLine();
                        }
                        catch (Exception e1) {
                            tempFileWithoutMTL.delete();
                            bufferedReader.close();
                            bufferedWriter.close();
                            throw e1;
                        }
                    }
                    bufferedReader.close();
                    bufferedWriter.close();
                    try {
                        importer.close();
                        importer = new ObjModelImporter();
                        importer.setOptions(new ObjImportOption[]{ObjImportOption.GENERATE_NORMALS});
                        importer.read(tempFileWithoutMTL);
                    }
                    catch (Exception e1) {
                        tempFileWithoutMTL.delete();
                        throw e1;
                    }
                    tempFileWithoutMTL.delete();
                }
            }
            importedModel = importer.getImport();
            Stream.of(importedModel).forEach(model -> model.getTransforms().add((Object)ROTATE_PI_X));
            JavaFXVisualTools.cacheMaterials((ModelImporter)importer, importedModel, cachedNamedOBJMaterials);
            cachedOBJModels.put(fileURL.toExternalForm(), new CachedImportedModel(importedModel));
            importer.close();
        } else {
            importedModel = cachedImportedModel.newMeshViews();
        }
        return importedModel;
    }

    private static void cacheMaterials(ModelImporter importer, MeshView[] importedModels, Map<Long, PhongMaterial> cacheToUpdate) {
        Map namedMaterials = importer.getNamedMaterials();
        if (namedMaterials == null) {
            return;
        }
        Map imageFilePaths = importer.getImageFilePaths();
        HashMap<PhongMaterial, Long> materialToHashCodeMap = new HashMap<PhongMaterial, Long>();
        for (Map.Entry entry : namedMaterials.entrySet()) {
            PhongMaterial material = (PhongMaterial)entry.getValue();
            long materialHashCode = ((String)entry.getKey()).hashCode();
            Image materialImage = material.getDiffuseMap();
            if (materialImage != null) {
                materialHashCode = 31L * materialHashCode + (long)((FilePath)imageFilePaths.get(materialImage)).getAbsolutePath().hashCode();
            }
            if ((materialImage = material.getSpecularMap()) != null) {
                materialHashCode = 31L * materialHashCode + (long)((FilePath)imageFilePaths.get(materialImage)).getAbsolutePath().hashCode();
            }
            if ((materialImage = material.getBumpMap()) != null) {
                materialHashCode = 31L * materialHashCode + (long)((FilePath)imageFilePaths.get(materialImage)).getAbsolutePath().hashCode();
            }
            if ((materialImage = material.getSelfIlluminationMap()) != null) {
                materialHashCode = 31L * materialHashCode + (long)((FilePath)imageFilePaths.get(materialImage)).getAbsolutePath().hashCode();
            }
            materialToHashCodeMap.put(material, materialHashCode);
            cacheToUpdate.putIfAbsent(materialHashCode, material);
        }
        for (MeshView importedModel : importedModels) {
            Long materialHashCode = (Long)materialToHashCodeMap.get(importedModel.getMaterial());
            importedModel.setMaterial((Material)cacheToUpdate.get(materialHashCode));
        }
    }

    public static <T extends Node> List<T> unwrapGroups(Node[] nodes, Class<T> filterClass) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        ArrayList<T> filteredNodes = new ArrayList<T>();
        for (Node node : nodes) {
            filteredNodes.addAll(JavaFXVisualTools.unwrapGroups(node, filterClass));
        }
        return filteredNodes;
    }

    public static <T extends Node> List<T> unwrapGroups(Node node, Class<T> filterClass) {
        if (!(node instanceof Group)) {
            if (filterClass.isInstance(node)) {
                return Collections.singletonList((Node)filterClass.cast(node));
            }
            return Collections.emptyList();
        }
        Group group = (Group)node;
        if (group.getChildren().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> filteredNodes = new ArrayList<T>();
        for (Node child : group.getChildren()) {
            child.getTransforms().addAll(0, (Collection)group.getTransforms());
            filteredNodes.addAll(JavaFXVisualTools.unwrapGroups(child, filterClass));
        }
        return filteredNodes;
    }

    public static Material toMaterial(MaterialDefinition materialDefinition, ClassLoader resourceClassLoader) {
        if (materialDefinition == null) {
            return DEFAULT_MATERIAL;
        }
        PhongMaterial phongMaterial = new PhongMaterial();
        ColorDefinition diffuseColor = materialDefinition.getDiffuseColor();
        ColorDefinition specularColor = materialDefinition.getSpecularColor();
        TextureDefinition diffuseMap = materialDefinition.getDiffuseMap();
        TextureDefinition emissiveMap = materialDefinition.getEmissiveMap();
        TextureDefinition normalMap = materialDefinition.getNormalMap();
        TextureDefinition specularMap = materialDefinition.getSpecularMap();
        boolean atLeastOneFieldSet = false;
        if (diffuseColor != null) {
            phongMaterial.setDiffuseColor(JavaFXVisualTools.toColor(diffuseColor));
            atLeastOneFieldSet = true;
        }
        if (specularColor != null) {
            phongMaterial.setSpecularColor(JavaFXVisualTools.toColor(specularColor));
            phongMaterial.setSpecularPower(materialDefinition.getShininess());
            atLeastOneFieldSet = true;
        }
        if (diffuseMap != null) {
            phongMaterial.setDiffuseMap(JavaFXVisualTools.toImage(diffuseMap, resourceClassLoader));
            atLeastOneFieldSet = true;
        }
        if (emissiveMap != null) {
            phongMaterial.setSelfIlluminationMap(JavaFXVisualTools.toImage(emissiveMap, resourceClassLoader));
            atLeastOneFieldSet = true;
        }
        if (normalMap != null) {
            phongMaterial.setBumpMap(JavaFXVisualTools.toImage(normalMap, resourceClassLoader));
            atLeastOneFieldSet = true;
        }
        if (specularMap != null) {
            phongMaterial.setSpecularMap(JavaFXVisualTools.toImage(specularMap, resourceClassLoader));
            phongMaterial.setSpecularPower(materialDefinition.getShininess());
            atLeastOneFieldSet = true;
        }
        return atLeastOneFieldSet ? phongMaterial : DEFAULT_MATERIAL;
    }

    public static Image toImage(TextureDefinition textureDefinition, ClassLoader resourceClassLoader) {
        try {
            if (textureDefinition == null) {
                return null;
            }
            if (textureDefinition.getImage() != null) {
                return SwingFXUtils.toFXImage((BufferedImage)textureDefinition.getImage(), null);
            }
            if (textureDefinition.getFileURL() != null) {
                return new Image(textureDefinition.getFileURL().openStream());
            }
            if (textureDefinition.getFilename() != null) {
                if (resourceClassLoader != null) {
                    return new Image(resourceClassLoader.getResourceAsStream(textureDefinition.getFilename()));
                }
                return new Image(textureDefinition.getFilename());
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Color toColor(ColorDefinition colorDefinition) {
        return JavaFXVisualTools.toColor(colorDefinition, DEFAULT_COLOR);
    }

    public static Color toColor(ColorDefinition colorDefinition, Color defaultValue) {
        if (colorDefinition == null) {
            return defaultValue;
        }
        return Color.color((double)colorDefinition.getRed(), (double)colorDefinition.getGreen(), (double)colorDefinition.getBlue(), (double)colorDefinition.getAlpha());
    }

    public static void setNodeIDs(Node[] nodes, String id, boolean overrideExistingIDs) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        if (nodes.length == 1) {
            JavaFXVisualTools.setNodeIDs(nodes[0], id, overrideExistingIDs);
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                JavaFXVisualTools.setNodeIDs(nodes[i], id + "_" + i, overrideExistingIDs);
            }
        }
    }

    public static void setMissingNodeIDs(Node node, String id) {
        JavaFXVisualTools.setNodeIDs(node, id, false);
    }

    public static void setNodeIDs(Node node, String id, boolean overrideExistingIDs) {
        if (node == null) {
            return;
        }
        if (node.getId() == null || overrideExistingIDs) {
            node.setId(id);
        }
        if (node instanceof Group) {
            Group group = (Group)node;
            for (int i = 0; i < group.getChildren().size(); ++i) {
                JavaFXVisualTools.setNodeIDs((Node)group.getChildren().get(i), id + "_" + i, overrideExistingIDs);
            }
        }
    }

    static {
        List list = Stream.of(Color.class.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> Modifier.isPublic(field.getModifiers())).filter(field -> field.getType() == Color.class).map(field -> field.getName().toLowerCase()).collect(Collectors.toList());
        colorNameList = Collections.unmodifiableList(list);
    }

    private static class CachedImportedModel {
        private final Mesh[] meshes;
        private final Material[] materials;
        private final List<Transform>[] transforms;

        private CachedImportedModel(MeshView[] importedMeshViews) {
            this.meshes = new Mesh[importedMeshViews.length];
            this.materials = new Material[importedMeshViews.length];
            this.transforms = new List[importedMeshViews.length];
            for (int i = 0; i < importedMeshViews.length; ++i) {
                MeshView meshView = importedMeshViews[i];
                this.meshes[i] = meshView.getMesh();
                this.materials[i] = meshView.getMaterial();
                this.transforms[i] = new ArrayList<Transform>((Collection<Transform>)meshView.getTransforms());
            }
        }

        private MeshView[] newMeshViews() {
            MeshView[] meshViews = new MeshView[this.meshes.length];
            for (int i = 0; i < this.meshes.length; ++i) {
                MeshView meshView = new MeshView(this.meshes[i]);
                meshView.setMaterial(this.materials[i]);
                meshView.getTransforms().setAll(this.transforms[i]);
                meshViews[i] = meshView;
            }
            return meshViews;
        }
    }
}

