/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class YoGraphicFXItemTreeCell
extends CheckBoxTreeCell<YoGraphicFXItem> {
    private final YoGroupFX rootGroup;

    public YoGraphicFXItemTreeCell(YoGroupFX rootGroup) {
        this.rootGroup = rootGroup;
        this.setOnDragOver(this::handleDragOver);
        this.setOnDragDropped(this::handleDragDropped);
        this.setOnDragEntered(this::handleDragEntered);
        this.setOnDragExited(this::handleDragExited);
    }

    public void updateItem(YoGraphicFXItem item, boolean empty) {
        this.textProperty().unbind();
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(item.getName());
            this.textProperty().bind((ObservableValue)item.nameProperty());
            FontAwesomeIconView graphic = null;
            if (item instanceof YoGroupFX) {
                graphic = new FontAwesomeIconView(FontAwesomeIcon.FOLDER_OPEN_ALT);
            } else if (item instanceof YoGraphicFX2D) {
                icon = new Label("2D");
                icon.setFont(Font.font((String)"Century Schoolbook", (double)10.0));
                icon.setTextFill((Paint)Color.DARKGREEN);
                graphic = icon;
            } else if (item instanceof YoGraphicFX3D) {
                icon = new Label("3D");
                icon.setFont(Font.font((String)"Century Schoolbook", (double)10.0));
                icon.setTextFill((Paint)Color.DARKRED);
                graphic = icon;
            }
            if (this.getGraphic() != null) {
                HBox container = new HBox(5.0, new Node[]{this.getGraphic(), graphic});
                container.setAlignment(Pos.CENTER);
                this.setGraphic((Node)container);
            } else {
                this.setGraphic((Node)graphic);
            }
        }
    }

    public void handleDragEntered(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(true);
        }
        event.consume();
    }

    public void handleDragExited(DragEvent event) {
        if (this.acceptDragEventForDrop(event)) {
            this.setSelectionHighlight(false);
        }
        event.consume();
    }

    public void handleDragOver(DragEvent event) {
        if (!event.isAccepted() && this.acceptDragEventForDrop(event)) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    public void handleDragDropped(DragEvent event) {
        List<YoGraphicFXItem> items;
        if (!event.isAccepted()) {
            return;
        }
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasContent(DragAndDropTools.YO_GRAPHIC_ITEMS_REFERENCE) && (items = DragAndDropTools.retrieveYoGraphicFXItemsFromDragBoard(db, this.rootGroup)) != null && this.getItem() instanceof YoGroupFX) {
            YoGroupFX newParent = (YoGroupFX)this.getItem();
            items.forEach(newParent::addYoGraphicFXItem);
            this.setSelectionHighlight(false);
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    public void setSelectionHighlight(boolean isSelected) {
        if (isSelected) {
            this.setStyle("-fx-border-color:green; -fx-border-radius:5;");
        } else {
            this.setStyle("-fx-border-color: null;");
        }
    }

    private boolean acceptDragEventForDrop(DragEvent event) {
        if (event.getGestureSource() == this || !(this.getItem() instanceof YoGroupFX)) {
            return false;
        }
        List<YoGraphicFXItem> items = DragAndDropTools.retrieveYoGraphicFXItemsFromDragBoard(event.getDragboard(), this.rootGroup);
        if (items == null) {
            return false;
        }
        return !items.stream().filter(item -> item == this.getItem()).findFirst().isPresent();
    }
}

