/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoPieChart;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoPieChart.YoPieChartVariableController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoPieChartController
implements VisualizerController {
    @FXML
    public Button saveButton;
    @FXML
    public Button loadButton;
    public Button clearButton;
    @FXML
    private YoPieChartVariableController variable0Controller;
    @FXML
    private YoPieChartVariableController variable1Controller;
    @FXML
    private YoPieChartVariableController variable2Controller;
    @FXML
    private YoPieChartVariableController variable3Controller;
    @FXML
    private YoPieChartVariableController variable4Controller;
    @FXML
    private YoPieChartVariableController variable5Controller;
    @FXML
    private YoPieChartVariableController variable6Controller;
    @FXML
    private YoPieChartVariableController variable7Controller;
    @FXML
    private YoPieChartVariableController variable8Controller;
    @FXML
    private YoPieChartVariableController variable9Controller;
    @FXML
    private YoPieChartVariableController variable10Controller;
    @FXML
    private YoPieChartVariableController variable11Controller;
    private List<YoPieChartVariableController> variableControllers;
    private final List<YoVariable> yoVariablesInPieChart = new ArrayList<YoVariable>();
    @FXML
    private PieChart pieChart;
    @FXML
    private Stage stage;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.variableControllers = Arrays.asList(this.variable0Controller, this.variable1Controller, this.variable2Controller, this.variable3Controller, this.variable4Controller, this.variable5Controller, this.variable6Controller, this.variable7Controller, this.variable8Controller, this.variable9Controller, this.variable10Controller, this.variable11Controller);
        for (int i = 0; i < this.variableControllers.size(); ++i) {
            YoPieChartVariableController variableController = this.variableControllers.get(i);
            variableController.initialize(toolkit.getGlobalToolkit(), this.pieChart);
        }
        AnimationTimer animationTimer = new AnimationTimer(){

            public void handle(long now) {
                if (YoPieChartController.this.pieChart.getData().isEmpty()) {
                    return;
                }
                for (int i = 0; i < YoPieChartController.this.variableControllers.size(); ++i) {
                    YoPieChartVariableController variableController = YoPieChartController.this.variableControllers.get(i);
                    YoPieChartController.this.yoVariablesInPieChart.add(variableController.getYoVariable());
                }
                YoPieChartController.this.pieChart.setStyle("-fx-pie-animation-time: 0ms;");
                ObservableList currentData = YoPieChartController.this.pieChart.getData();
                block1: for (PieChart.Data data : currentData) {
                    String name = data.getName();
                    for (YoVariable yoVariable : YoPieChartController.this.yoVariablesInPieChart) {
                        if (yoVariable == null || !yoVariable.getName().equals(name)) continue;
                        data.setPieValue(yoVariable.getValueAsDouble());
                        continue block1;
                    }
                }
            }
        };
        animationTimer.start();
        this.stage.initOwner((Window)toolkit.getWindow());
        this.stage.show();
        JavaFXMissingTools.centerWindowInOwner((Window)this.stage, (Window)toolkit.getWindow());
    }

    @FXML
    public void loadLayout(MouseEvent mouseEvent) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Layout");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Pie Chart Files", new String[]{"*.pie.chart"}));
        Stage stage = (Stage)((Node)mouseEvent.getSource()).getScene().getWindow();
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            this.loadFromXML(file);
        }
    }

    @FXML
    public void clearChart(MouseEvent mouseEvent) {
        this.yoVariablesInPieChart.clear();
        for (YoPieChartVariableController variableController : this.variableControllers) {
            variableController.clear();
        }
        this.pieChart.getData().clear();
    }

    private void loadFromXML(File file) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            doc.getDocumentElement().normalize();
            Element rootElement = doc.getDocumentElement();
            NodeList chartConfigList = rootElement.getElementsByTagName("chartConfigurations");
            for (int i = 0; i < chartConfigList.getLength(); ++i) {
                Element chartConfigElement;
                NodeList yoVariablesList;
                org.w3c.dom.Node chartConfigNode = chartConfigList.item(i);
                if (chartConfigNode.getNodeType() != 1 || (yoVariablesList = (chartConfigElement = (Element)chartConfigNode).getElementsByTagName("yoVariables")).getLength() <= 0) continue;
                String yoVariableText = yoVariablesList.item(0).getTextContent();
                if (i >= this.variableControllers.size()) continue;
                YoPieChartVariableController controller = this.variableControllers.get(i);
                controller.setYoVariable(yoVariableText);
            }
            System.out.println("Layout loaded successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void saveLayout(MouseEvent mouseEvent) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Layout");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Pie Chart Files", new String[]{"*.pie.chart"}));
        Stage stage = (Stage)((Node)mouseEvent.getSource()).getScene().getWindow();
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            String filePath = file.getAbsolutePath();
            if (!filePath.endsWith(".pie.chart")) {
                file = new File(filePath + ".pie.chart");
            }
            this.saveToXML(file);
        }
    }

    private void saveToXML(File file) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            Document doc = documentBuilder.newDocument();
            Element rootElement = doc.createElement("YoChartGroupConfigurationList");
            rootElement.setAttribute("name", "pieChartLayout");
            doc.appendChild(rootElement);
            for (YoPieChartVariableController controller : this.variableControllers) {
                if (controller.getYoVariable() == null) continue;
                Element chartConfiguration = doc.createElement("chartConfigurations");
                controller.getYoVariable().getType();
                Element yoVariable = doc.createElement("yoVariables");
                yoVariable.appendChild(doc.createTextNode(controller.getYoVariable().getFullNameString()));
                chartConfiguration.appendChild(yoVariable);
                rootElement.appendChild(chartConfiguration);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
            System.out.println("Layout saved successfully!");
        }
        catch (ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
        }
    }
}

