/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera;

import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SubScene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.session.SessionPropertiesHelper;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraBindingsHelper;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraControlMode;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraFocalPointHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraOrbitHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.LevelOrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.OrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TranslateSCS2;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;

public class PerspectiveCameraController
extends ObservedAnimationTimer
implements EventHandler<Event> {
    private static final boolean FOCUS_POINT_SHOW = SessionPropertiesHelper.loadBooleanPropertyOrEnvironment((String)"scs2.session.gui.camera.focuspoint.show", (String)"SCS2_GUI_CAMERA_FOCUS_SHOW", (boolean)true);
    private static final double FOCUS_POINT_SIZE = SessionPropertiesHelper.loadDoublePropertyOrEnvironment((String)"scs2.session.gui.camera.focuspoint.size", (String)"SCS2_GUI_CAMERA_FOCUS_SIZE", (double)0.0025);
    private final Sphere focalPointViz;
    private final CameraFocalPointHandler focalPointHandler;
    private final CameraOrbitHandler orbitHandler;
    private final DoubleProperty minTranslationOffset = new SimpleDoubleProperty((Object)this, "minTranslationOffset", 0.1);
    private final DoubleProperty zoomToTranslationPow = new SimpleDoubleProperty((Object)this, "zoomToTranslationPow", 0.75);
    private final EventHandler<ScrollEvent> zoomEventHandler;
    private final EventHandler<MouseEvent> orbitalRotationEventHandler;
    private final CameraFocalPointHandler.FocalPointKeyEventHandler translationEventHandler;
    private final PerspectiveCamera camera;
    private final Property<Tuple3DProperty> cameraPositionCoordinatesToTrack = new SimpleObjectProperty((Object)this, "cameraPositionCoordinatesToTrack", null);
    private final Property<OrbitalCoordinateProperty> cameraOrbitalCoordinatesToTrack = new SimpleObjectProperty((Object)this, "cameraOrbitCoordinatesToTrack", null);
    private final Property<LevelOrbitalCoordinateProperty> cameraLevelOrbitalCoordinatesToTrack = new SimpleObjectProperty((Object)this, "cameraOrbit2DCoordinatesToTrack", null);
    private EventHandler<MouseEvent> rayBasedFocusTranslation = null;
    private EventHandler<MouseEvent> cameraRotationEventHandler;

    public PerspectiveCameraController(ReadOnlyDoubleProperty sceneWidthProperty, ReadOnlyDoubleProperty sceneHeightProperty, PerspectiveCamera camera, Vector3DReadOnly up, Vector3DReadOnly forward) {
        this.camera = camera;
        Vector3D left = new Vector3D();
        left.cross((Tuple3DReadOnly)up, (Tuple3DReadOnly)forward);
        if (!MathTools.epsilonEquals((double)left.norm(), (double)1.0, (double)1.0E-5)) {
            throw new RuntimeException("The vectors up and forward must be orthogonal. Received: up = " + String.valueOf(up) + ", forward = " + String.valueOf(forward));
        }
        this.orbitHandler = new CameraOrbitHandler(up, forward);
        this.orbitHandler.fastModifierPredicateProperty().set(event -> event.isShiftDown());
        this.orbitalRotationEventHandler = this.orbitHandler.createMouseEventHandler(sceneWidthProperty, sceneHeightProperty);
        this.zoomEventHandler = this.orbitHandler.createScrollEventHandler();
        this.orbitHandler.minDistanceProperty().set(1.1 * camera.getNearClip());
        this.orbitHandler.maxDistanceProperty().set(0.9 * camera.getFarClip());
        this.focalPointHandler = new CameraFocalPointHandler(up);
        this.focalPointHandler.fastModifierPredicateProperty().set(event -> event.isShiftDown());
        this.focalPointHandler.setCameraOrientation((Transform)this.orbitHandler.getCameraPose());
        this.translationEventHandler = this.focalPointHandler.createKeyEventHandler();
        this.focalPointHandler.setTranslationRateModifier(translationRate -> Math.min(translationRate * Math.pow(this.orbitHandler.distanceProperty().get(), this.zoomToTranslationPow.get()), this.minTranslationOffset.get()));
        this.setCameraPosition(-2.0, 0.7, 1.0);
        TranslateSCS2 focalPointTranslation = this.focalPointHandler.getTranslation();
        camera.getTransforms().addAll((Object[])new Transform[]{focalPointTranslation, this.orbitHandler.getCameraPose()});
        this.orbitHandler.createCameraWorldCoordinates((ObservableDoubleValue)focalPointTranslation.xProperty(), (ObservableDoubleValue)focalPointTranslation.yProperty(), (ObservableDoubleValue)focalPointTranslation.zProperty());
        this.cameraPositionCoordinatesToTrack.addListener((o, oldValue, newValue) -> {
            CameraBindingsHelper.removeCameraPositionBindings(oldValue, this.orbitHandler);
            if (this.cameraControlMode().getValue() == CameraControlMode.Position) {
                CameraBindingsHelper.addCameraPositionBindings(newValue, this.orbitHandler);
            }
        });
        this.cameraOrbitalCoordinatesToTrack.addListener((o, oldValue, newValue) -> {
            CameraBindingsHelper.removeCameraOrbitalBindings(oldValue, this.orbitHandler);
            if (this.cameraControlMode().getValue() == CameraControlMode.Orbital) {
                CameraBindingsHelper.addCameraOrbitalBindings(newValue, this.orbitHandler);
            }
        });
        this.cameraLevelOrbitalCoordinatesToTrack.addListener((o, oldValue, newValue) -> {
            CameraBindingsHelper.removeCameraLevelOrbitalBindings(oldValue, this.orbitHandler);
            if (this.cameraControlMode().getValue() == CameraControlMode.LevelOrbital) {
                CameraBindingsHelper.addCameraLevelOrbitalBindings(newValue, this.orbitHandler);
            }
        });
        this.cameraControlMode().addListener((o, oldValue, newValue) -> {
            switch (oldValue) {
                case Position: {
                    CameraBindingsHelper.removeCameraPositionBindings((Tuple3DProperty)this.cameraPositionCoordinatesToTrack.getValue(), this.orbitHandler);
                    break;
                }
                case Orbital: {
                    CameraBindingsHelper.removeCameraOrbitalBindings((OrbitalCoordinateProperty)this.cameraOrbitalCoordinatesToTrack.getValue(), this.orbitHandler);
                    break;
                }
                case LevelOrbital: {
                    CameraBindingsHelper.removeCameraLevelOrbitalBindings((LevelOrbitalCoordinateProperty)this.cameraLevelOrbitalCoordinatesToTrack.getValue(), this.orbitHandler);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf(oldValue));
                }
            }
            switch (newValue) {
                case Position: {
                    CameraBindingsHelper.addCameraPositionBindings((Tuple3DProperty)this.cameraPositionCoordinatesToTrack.getValue(), this.orbitHandler);
                    break;
                }
                case Orbital: {
                    CameraBindingsHelper.addCameraOrbitalBindings((OrbitalCoordinateProperty)this.cameraOrbitalCoordinatesToTrack.getValue(), this.orbitHandler);
                    break;
                }
                case LevelOrbital: {
                    CameraBindingsHelper.addCameraLevelOrbitalBindings((LevelOrbitalCoordinateProperty)this.cameraLevelOrbitalCoordinatesToTrack.getValue(), this.orbitHandler);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf(newValue));
                }
            }
        });
        if (FOCUS_POINT_SHOW) {
            this.focalPointViz = new Sphere(0.01);
            PhongMaterial material = new PhongMaterial();
            material.setDiffuseColor(Color.DARKRED);
            material.setSpecularColor(Color.RED);
            this.focalPointViz.setMaterial((Material)material);
            this.focalPointViz.getTransforms().add((Object)focalPointTranslation);
            this.orbitHandler.distanceProperty().addListener((o, oldValue, newValue) -> this.focalPointViz.setRadius(FOCUS_POINT_SIZE * newValue.doubleValue()));
        } else {
            this.focalPointViz = null;
        }
        this.setupCameraRotationHandler();
    }

    @Override
    public void handleImpl(long now) {
        this.focalPointHandler.update();
        if (this.translationEventHandler.isTranslating()) {
            Vector3DReadOnly translation = this.translationEventHandler.getActiveTranslationWorldFrame();
            if (this.cameraControlMode().getValue() == CameraControlMode.Position) {
                double x = this.orbitHandler.xProperty().get() + translation.getX();
                double y = this.orbitHandler.yProperty().get() + translation.getY();
                double z = this.orbitHandler.zProperty().get() + translation.getZ();
                this.orbitHandler.setPosition(x, y, z, Double.NaN);
            } else if (this.cameraControlMode().getValue() == CameraControlMode.LevelOrbital && translation.getZ() != 0.0) {
                double height = this.orbitHandler.zProperty().get() + translation.getZ();
                this.orbitHandler.setLevelOrbit(Double.NaN, Double.NaN, height, Double.NaN);
            }
        }
    }

    public void setCameraPosition(Point3DReadOnly desiredCameraPosition) {
        this.setCameraPosition(desiredCameraPosition, false);
    }

    public void setCameraPosition(Point3DReadOnly desiredCameraPosition, boolean translateFocalPoint) {
        this.setCameraPosition(desiredCameraPosition.getX(), desiredCameraPosition.getY(), desiredCameraPosition.getZ(), translateFocalPoint);
    }

    public void setCameraPosition(double x, double y, double z) {
        this.setCameraPosition(x, y, z, false);
    }

    public void setCameraPosition(double x, double y, double z, boolean translateFocalPoint) {
        if (translateFocalPoint) {
            Transform cameraTransform = this.camera.getLocalToSceneTransform();
            this.focalPointHandler.translateWorldFrame(x - cameraTransform.getTx(), y - cameraTransform.getTy(), z - cameraTransform.getTz());
        } else {
            TranslateSCS2 focalPoint = this.focalPointHandler.getTranslation();
            this.orbitHandler.setPosition(x - focalPoint.getX(), y - focalPoint.getY(), z - focalPoint.getZ(), 0.0);
        }
    }

    public void setFocalPoint(Point3DReadOnly desiredFocalPoint, boolean translateCamera) {
        this.setFocalPoint(desiredFocalPoint.getX(), desiredFocalPoint.getY(), desiredFocalPoint.getZ(), translateCamera);
    }

    public void setFocalPoint(double x, double y, double z, boolean translateCamera) {
        this.focalPointHandler.disableTracking();
        if (translateCamera) {
            this.focalPointHandler.setPositionWorldFrame(x, y, z);
        } else {
            Transform cameraTransform = this.camera.getLocalToSceneTransform();
            this.orbitHandler.setPosition(cameraTransform.getTx() - x, cameraTransform.getTy() - y, cameraTransform.getTz() - z, 0.0);
            this.focalPointHandler.setPositionWorldFrame(x, y, z);
        }
    }

    public void setCameraOrientation(double longitude, double latitude, double roll, boolean translateFocalPoint) {
        if (translateFocalPoint) {
            Vector3DReadOnly focalPointShift = this.orbitHandler.setRotation(longitude, latitude, roll, true);
            this.focalPointHandler.translateWorldFrame((Tuple3DReadOnly)focalPointShift);
        } else {
            this.orbitHandler.setRotation(longitude, latitude, roll);
        }
    }

    public void setCameraOrbit(double distance, double longitude, double latitude, double roll, boolean translateFocalPoint) {
        if (translateFocalPoint) {
            Vector3DReadOnly focalPointShift = this.orbitHandler.setOrbit(distance, longitude, latitude, roll, true);
            this.focalPointHandler.translateWorldFrame((Tuple3DReadOnly)focalPointShift);
        } else {
            this.orbitHandler.setOrbit(distance, longitude, latitude, roll);
        }
    }

    public void setCameraLevelOrbit(double distance, double longitude, double height, double roll, boolean translateFocalPoint) {
        if (translateFocalPoint) {
            Vector3DReadOnly focalPointShift = this.orbitHandler.setLevelOrbit(distance, longitude, height -= this.focalPointHandler.getTranslation().getZ(), roll, true);
            this.focalPointHandler.translateWorldFrame((Tuple3DReadOnly)focalPointShift);
        } else {
            this.orbitHandler.setLevelOrbit(distance, longitude, height, roll);
        }
    }

    public void rotateCamera(double deltaLongitude, double deltaLatitude, double deltaRoll, boolean translateFocalPoint) {
        if (translateFocalPoint) {
            Vector3DReadOnly focalPointShift = switch ((CameraControlMode)((Object)this.cameraControlMode().getValue())) {
                default -> throw new IncompatibleClassChangeError();
                case CameraControlMode.Position -> this.orbitHandler.computeFocalPointShift(0.0, deltaLongitude, deltaLatitude, deltaRoll);
                case CameraControlMode.Orbital -> this.orbitHandler.rotate(deltaLongitude, deltaLatitude, deltaRoll, true);
                case CameraControlMode.LevelOrbital -> {
                    Vector3D shift = new Vector3D((Tuple3DReadOnly)this.orbitHandler.setLevelOrbit(Double.NaN, this.orbitHandler.longitudeProperty().get() + deltaLongitude, Double.NaN, this.orbitHandler.rollProperty().get() + deltaRoll, true));
                    shift.setZ(this.orbitHandler.computeFocalPointShift(0.0, deltaLongitude, deltaLatitude, deltaRoll).getZ());
                    yield shift;
                }
            };
            this.focalPointHandler.translateWorldFrame((Tuple3DReadOnly)focalPointShift);
        } else {
            this.orbitHandler.rotate(deltaLongitude, deltaLatitude, deltaRoll);
        }
    }

    public void handle(Event event) {
        if (event instanceof ScrollEvent) {
            this.zoomEventHandler.handle((Event)((ScrollEvent)event));
        }
        if (event instanceof KeyEvent) {
            this.translationEventHandler.handle((KeyEvent)event);
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (this.rayBasedFocusTranslation != null) {
                this.rayBasedFocusTranslation.handle((Event)mouseEvent);
            }
            if (!event.isConsumed()) {
                this.orbitalRotationEventHandler.handle((Event)mouseEvent);
            }
            if (!event.isConsumed() && this.cameraRotationEventHandler != null) {
                this.cameraRotationEventHandler.handle((Event)mouseEvent);
            }
        }
    }

    public void enableShiftClickFocusTranslation() {
        this.enableShiftClickFocusTranslation(MouseEvent::getPickResult);
    }

    public void enableShiftClickFocusTranslation(Function<MouseEvent, PickResult> nodePickingFunction) {
        this.setupRayBasedFocusTranslation((MouseEvent event) -> {
            if (!event.isShiftDown()) {
                return false;
            }
            if (event.getButton() != MouseButton.PRIMARY) {
                return false;
            }
            if (!event.isStillSincePress()) {
                return false;
            }
            return event.getEventType() == MouseEvent.MOUSE_CLICKED;
        }, nodePickingFunction);
    }

    public void setupRayBasedFocusTranslation(Predicate<MouseEvent> condition) {
        this.setupRayBasedFocusTranslation(condition, MouseEvent::getPickResult);
    }

    public void setupRayBasedFocusTranslation(Predicate<MouseEvent> condition, Function<MouseEvent, PickResult> nodePickingFunction) {
        this.setupRayBasedFocusTranslation(condition, nodePickingFunction, 0.1);
    }

    public void setupRayBasedFocusTranslation(Predicate<MouseEvent> condition, double animationDuration) {
        this.setupRayBasedFocusTranslation(condition, MouseEvent::getPickResult, animationDuration);
    }

    public void setupRayBasedFocusTranslation(final Predicate<MouseEvent> condition, final Function<MouseEvent, PickResult> nodePickingFunction, final double animationDuration) {
        this.rayBasedFocusTranslation = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (condition.test(event)) {
                    PickResult pickResult = (PickResult)nodePickingFunction.apply(event);
                    if (pickResult == null) {
                        return;
                    }
                    Node intersectedNode = pickResult.getIntersectedNode();
                    if (intersectedNode == null || intersectedNode instanceof SubScene) {
                        return;
                    }
                    Point3D localPoint = pickResult.getIntersectedPoint();
                    Point3D scenePoint = intersectedNode.getLocalToSceneTransform().transform(localPoint);
                    PerspectiveCameraController.this.focalPointHandler.disableTracking();
                    TranslateSCS2 translate = PerspectiveCameraController.this.focalPointHandler.getOffsetTranslation();
                    if (animationDuration > 0.0) {
                        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)animationDuration), new KeyValue[]{new KeyValue((WritableValue)translate.xProperty(), (Object)scenePoint.getX(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)translate.yProperty(), (Object)scenePoint.getY(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)translate.zProperty(), (Object)scenePoint.getZ(), Interpolator.EASE_BOTH)})});
                        animation.playFromStart();
                    } else {
                        translate.set(scenePoint);
                    }
                    event.consume();
                }
            }
        };
    }

    public void setupCameraRotationHandler() {
        this.setupCameraRotationHandler(MouseButton.SECONDARY);
    }

    public void setupCameraRotationHandler(MouseButton mouseButton) {
        this.setupCameraRotationHandler(mouseButton, () -> 0.003);
    }

    public void setupCameraRotationHandler(final MouseButton mouseButton, final DoubleSupplier modifier) {
        this.cameraRotationEventHandler = new EventHandler<MouseEvent>(){
            private final Point2D oldMouseLocation = new Point2D();

            public void handle(MouseEvent event) {
                if (event.getButton() != mouseButton) {
                    return;
                }
                if (event.isStillSincePress()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    this.oldMouseLocation.set(event.getSceneX(), event.getSceneY());
                    return;
                }
                if (event.getEventType() != MouseEvent.MOUSE_DRAGGED) {
                    return;
                }
                Point2D newMouseLocation = new Point2D(event.getSceneX(), event.getSceneY());
                Vector2D drag = new Vector2D();
                drag.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)this.oldMouseLocation);
                drag.scale(modifier.getAsDouble());
                PerspectiveCameraController.this.focalPointHandler.disableTracking();
                PerspectiveCameraController.this.rotateCamera(-drag.getX(), drag.getY(), 0.0, true);
                this.oldMouseLocation.set(newMouseLocation);
            }
        };
    }

    public Sphere getFocalPointViz() {
        return this.focalPointViz;
    }

    public TranslateSCS2 getFocalPointTranslate() {
        return this.focalPointHandler.getTranslation();
    }

    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    public CameraFocalPointHandler getFocalPointHandler() {
        return this.focalPointHandler;
    }

    public CameraOrbitHandler getOrbitHandler() {
        return this.orbitHandler;
    }

    public Property<CameraControlMode> cameraControlMode() {
        return this.orbitHandler.controlMode();
    }

    public Property<Tuple3DProperty> cameraPositionCoordinatesToTrackProperty() {
        return this.cameraPositionCoordinatesToTrack;
    }

    public Property<OrbitalCoordinateProperty> cameraOrbitalCoordinatesToTrackProperty() {
        return this.cameraOrbitalCoordinatesToTrack;
    }

    public Property<LevelOrbitalCoordinateProperty> cameraLevelOrbitalCoordinatesToTrackProperty() {
        return this.cameraLevelOrbitalCoordinatesToTrack;
    }
}

