/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.controlsfx.control.textfield.TextFields;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class YoGraphicNameEditorPaneController {
    @FXML
    private GridPane mainPane;
    @FXML
    private Label nameLabel;
    @FXML
    private TextField nameTextField;
    @FXML
    private Label namespaceLabel;
    @FXML
    private TextField namespaceTextField;
    @FXML
    private ImageView nameValidImageView;
    private YoGroupFX rootGroup;
    private final BooleanProperty inputsValidityProperty = new SimpleBooleanProperty((Object)this, "inputsValidity", false);
    private final StringProperty nameProperty = new SimpleStringProperty((Object)this, "name", null);
    private final StringProperty namespaceProperty = new SimpleStringProperty((Object)this, "namespace", null);
    private YoGraphicFXItem yoGraphicFXItem;

    public void initialize(SessionVisualizerToolkit toolkit, YoGraphicFXItem yoGraphicFXItem) {
        this.yoGraphicFXItem = yoGraphicFXItem;
        this.rootGroup = toolkit.getYoGraphicFXRootGroup();
        TextFields.bindAutoCompletion((TextField)this.namespaceTextField, YoGraphicTools.collectAllExistingNamespaces(this.rootGroup));
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.inputsValidityProperty, this.nameValidImageView);
        this.nameTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                this.inputsValidityProperty.set(false);
            } else {
                YoGraphicFXItem searchResult = this.findYoGraphicFXItem((String)newValue, this.namespaceTextField.getText());
                boolean isNameValid = searchResult == null || searchResult == yoGraphicFXItem;
                this.inputsValidityProperty.set(isNameValid);
                if (isNameValid) {
                    this.nameProperty.set(newValue);
                }
            }
        });
        this.namespaceTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                this.inputsValidityProperty.set(false);
            } else {
                YoGraphicFXItem searchResult = this.findYoGraphicFXItem(this.nameTextField.getText(), (String)newValue);
                boolean isNamespaceValid = searchResult == null || searchResult == yoGraphicFXItem;
                this.inputsValidityProperty.set(isNamespaceValid);
                if (isNamespaceValid) {
                    this.namespaceProperty.set(newValue);
                }
            }
        });
    }

    private YoGraphicFXItem findYoGraphicFXItem(String itemName, String namespace) {
        return YoGraphicTools.findYoGraphicFXItem(this.rootGroup, namespace, itemName, this.yoGraphicFXItem.getClass());
    }

    public void setInput(String name, String namespace) {
        this.nameTextField.setText(name);
        this.namespaceTextField.setText(namespace);
        this.namespaceTextField.setDisable(true);
    }

    public void bindYoGraphicFXItem(YoGraphicFXItem yoGraphicFXItemToBind) {
        this.nameProperty.addListener((o, oldValue, newValue) -> yoGraphicFXItemToBind.setName((String)newValue));
    }

    public void addAnyChangeListener(ChangeListener<Object> changeListener) {
        this.nameProperty.addListener(changeListener);
        this.namespaceProperty.addListener(changeListener);
    }

    public ReadOnlyBooleanProperty inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public ReadOnlyStringProperty nameProperty() {
        return this.nameProperty;
    }

    public ReadOnlyStringProperty namespaceProperty() {
        return this.namespaceProperty;
    }

    public GridPane getMainPane() {
        return this.mainPane;
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    public Label getNamespaceLabel() {
        return this.namespaceLabel;
    }

    public TextField getNameTextField() {
        return this.nameTextField;
    }
}

