/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class LogCropProgressController
implements ProgressConsumer {
    @FXML
    private VBox mainPane;
    @FXML
    private Label taskInProgressLabel;
    @FXML
    private Label progressInfoLabel;
    @FXML
    private Label progressErrorLabel;
    @FXML
    private ProgressBar progressBar;
    private Pane parent;
    private Timeline openTimeline;
    private Timeline closeTimeline;

    public void initialize(Pane parent) {
        this.parent = parent;
        this.taskInProgressLabel.setText("N/D");
        this.progressInfoLabel.setText(null);
        this.progressErrorLabel.setText(null);
        DoubleProperty scaleYProperty = this.mainPane.scaleYProperty();
        this.openTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)scaleYProperty, (Object)0.0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)scaleYProperty, (Object)1.0, Interpolator.EASE_BOTH)})});
        this.closeTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)scaleYProperty, (Object)1.0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)5.0), new KeyValue[]{new KeyValue((WritableValue)scaleYProperty, (Object)1.0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)5.2), new KeyValue[]{new KeyValue((WritableValue)scaleYProperty, (Object)0.0, Interpolator.EASE_BOTH)})});
        this.closeTimeline.setOnFinished(e -> parent.getChildren().remove((Object)this.mainPane));
    }

    public void started(String task) {
        this.taskInProgressLabel.setText(task);
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            if (!this.parent.getChildren().contains((Object)this.mainPane)) {
                this.mainPane.setScaleY(0.0);
                this.parent.getChildren().add((Object)this.mainPane);
                this.openTimeline.playFromStart();
            }
        });
    }

    public void info(String info) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.progressInfoLabel.setText(info));
    }

    public void error(String error) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.progressErrorLabel.setText(error));
    }

    public void progress(double progressPercentage) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.progressBar.setProgress(progressPercentage));
    }

    public void done() {
        this.info("Done!");
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.closeTimeline.playFromStart());
    }
}

