/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionAdvancedControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;

public class SessionSimpleControlsController
implements VisualizerController {
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    @FXML
    private HBox controlsHBox;
    @FXML
    private Node runningIconView;
    @FXML
    private Node playbackIconView;
    @FXML
    private Node pauseIconView;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.messager.addTopicListener(this.topics.getShowAdvancedControls(), showAdvancedControls -> this.show(showAdvancedControls == false));
        this.messager.addFXTopicListener(this.topics.getDisableUserControls(), disable -> this.controlsHBox.setDisable(disable.booleanValue()));
        SessionAdvancedControlsController.setupMainControlsActiveMode(this, this.messager, this.topics, this.runningIconView, this.playbackIconView, this.pauseIconView);
    }

    @FXML
    private void startRunning() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.RUNNING);
    }

    @FXML
    private void startPlayback() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PLAYBACK);
    }

    @FXML
    private void openAdvancedControls() {
        this.messager.submitMessage(this.topics.getShowAdvancedControls(), (Object)true);
    }

    @FXML
    private void pause() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
    }

    public void show(boolean show) {
        this.controlsHBox.setMouseTransparent(!show);
        this.controlsHBox.setVisible(show);
    }
}

