/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.camera.YoLevelOrbitalCoordinateDefinition;
import us.ihmc.scs2.definition.camera.YoOrbitalCoordinateDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.session.SessionDataFilterParameters;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionChangeListener;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoMultiSliderboardWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoBooleanProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoEnumAsStringProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoIntegerProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoLongProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.yoVariables.euclid.YoTuple2D;
import us.ihmc.yoVariables.euclid.YoTuple3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameTuple2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameTuple3D;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public interface SessionVisualizerControls {
    public void setCameraOrientation(double var1, double var3);

    default public void setCameraPosition(Point3DReadOnly position) {
        this.setCameraPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setCameraPosition(double var1, double var3, double var5);

    @Deprecated
    default public void setCameraFocusPosition(Point3DReadOnly position) {
        this.setCameraFocalPosition(position);
    }

    @Deprecated
    default public void setCameraFocusPosition(double x, double y, double z) {
        this.setCameraFocalPosition(x, y, z);
    }

    default public void setCameraFocalPosition(Point3DReadOnly position) {
        this.setCameraFocalPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setCameraFocalPosition(double var1, double var3, double var5);

    public void setCameraZoom(double var1);

    public void requestCameraRigidBodyTracking(String var1, String var2);

    default public void requestCameraFocalPositionTracking(YoFrameTuple3D coordinatesToTrack) {
        this.requestCameraFocalPositionTracking(coordinatesToTrack.getYoX(), coordinatesToTrack.getYoY(), coordinatesToTrack.getYoZ(), coordinatesToTrack.getReferenceFrame());
    }

    default public void requestCameraFocalPositionTracking(YoDouble xCoordinateToTrack, YoDouble yCoordinateToTrack, YoDouble zCoordinateToTrack, ReferenceFrame referenceFrame) {
        this.requestCameraFocalPositionTracking(xCoordinateToTrack == null ? null : xCoordinateToTrack.getFullNameString(), yCoordinateToTrack == null ? null : yCoordinateToTrack.getFullNameString(), zCoordinateToTrack == null ? null : zCoordinateToTrack.getFullNameString(), referenceFrame == null ? null : referenceFrame.getNameId());
    }

    default public void requestCameraFocalPositionTracking(String xCoordinateNameToTrack, String yCoordinateNameToTrack, String zCoordinateNameToTrack, String referenceFrameName) {
        this.requestCameraFocalPositionTracking(new YoTuple3DDefinition(xCoordinateNameToTrack, yCoordinateNameToTrack, zCoordinateNameToTrack, referenceFrameName));
    }

    public void requestCameraFocalPositionTracking(YoTuple3DDefinition var1);

    default public void requestCameraPositionTracking(YoTuple3D cameraCoordinates) {
        this.requestCameraPositionTracking(cameraCoordinates.getYoX(), cameraCoordinates.getYoY(), cameraCoordinates.getYoZ());
    }

    default public void requestCameraPositionTracking(YoDouble xCameraCoordinate, YoDouble yCameraCoordinate, YoDouble zCameraCoordinate) {
        this.requestCameraPositionTracking(xCameraCoordinate == null ? null : xCameraCoordinate.getFullNameString(), yCameraCoordinate == null ? null : yCameraCoordinate.getFullNameString(), zCameraCoordinate == null ? null : zCameraCoordinate.getFullNameString());
    }

    default public void requestCameraPositionTracking(String xCameraCoordinateName, String yCameraCoordinateName, String zCameraCoordinateName) {
        this.requestCameraPositionTracking(new YoTuple3DDefinition(xCameraCoordinateName, yCameraCoordinateName, zCameraCoordinateName));
    }

    public void requestCameraPositionTracking(YoTuple3DDefinition var1);

    default public void requestCameraOrbitTracking(YoDouble distanceCameraCoordinate, YoDouble longitudeCameraCoordinate, YoDouble latitudeCameraCoordinate) {
        this.requestCameraOrbitTracking(distanceCameraCoordinate == null ? null : distanceCameraCoordinate.getFullNameString(), longitudeCameraCoordinate == null ? null : longitudeCameraCoordinate.getFullNameString(), latitudeCameraCoordinate == null ? null : latitudeCameraCoordinate.getFullNameString());
    }

    default public void requestCameraOrbitTracking(String distanceCameraCoordinateName, String longitudeCameraCoordinateName, String latitudeCameraCoordinateName) {
        this.requestCameraOrbitTracking(new YoOrbitalCoordinateDefinition(distanceCameraCoordinateName, longitudeCameraCoordinateName, latitudeCameraCoordinateName));
    }

    public void requestCameraOrbitTracking(YoOrbitalCoordinateDefinition var1);

    default public void requestCameraLevelOrbitTracking(YoDouble distanceCameraCoordinate, YoDouble longitudeCameraCoordinate, YoDouble heightCameraCoordinate) {
        this.requestCameraLevelOrbitTracking(distanceCameraCoordinate == null ? null : distanceCameraCoordinate.getFullNameString(), longitudeCameraCoordinate == null ? null : longitudeCameraCoordinate.getFullNameString(), heightCameraCoordinate == null ? null : heightCameraCoordinate.getFullNameString());
    }

    default public void requestCameraLevelOrbitTracking(String distanceCameraCoordinateName, String longitudeCameraCoordinateName, String heightCameraCoordinateName) {
        this.requestCameraLevelOrbitTracking(new YoLevelOrbitalCoordinateDefinition(distanceCameraCoordinateName, longitudeCameraCoordinateName, heightCameraCoordinateName));
    }

    public void requestCameraLevelOrbitTracking(YoLevelOrbitalCoordinateDefinition var1);

    public void showOverheadPlotter2D(boolean var1);

    default public void requestPlotter2DCoordinateTracking(YoFrameTuple2D position) {
        this.requestPlotter2DCoordinateTracking((YoTuple2D)position, position.getReferenceFrame().getNameId());
    }

    default public void requestPlotter2DCoordinateTracking(YoTuple2D position, String frameName) {
        this.requestPlotter2DCoordinateTracking(position.getYoX(), position.getYoY(), frameName);
    }

    default public void requestPlotter2DCoordinateTracking(YoDouble xVariable, YoDouble yVariable, String frameName) {
        this.requestPlotter2DCoordinateTracking(xVariable.getFullNameString(), yVariable.getFullNameString(), frameName);
    }

    public void requestPlotter2DCoordinateTracking(String var1, String var2, String var3);

    public void addStaticVisual(VisualDefinition var1);

    default public void addStaticVisuals(Collection<? extends VisualDefinition> visualDefinitions) {
        for (VisualDefinition visualDefinition : visualDefinitions) {
            this.addStaticVisual(visualDefinition);
        }
    }

    public void removeStaticVisual(VisualDefinition var1);

    default public void removeStaticVisuals(Collection<? extends VisualDefinition> visualDefinitions) {
        for (VisualDefinition visualDefinition : visualDefinitions) {
            this.removeStaticVisual(visualDefinition);
        }
    }

    default public void removeAllYoGraphics() {
        this.removeYoGraphic("root");
    }

    public void removeYoGraphic(String var1);

    default public void setAllYoGraphicsVisible(boolean visible) {
        this.setYoGraphicVisible("root", visible);
    }

    public void setYoGraphicVisible(String var1, boolean var2);

    public void addYoGraphic(YoGraphicDefinition var1);

    default public void addYoGraphics(Collection<? extends YoGraphicDefinition> yoGraphicDefinitions) {
        for (YoGraphicDefinition yoGraphicDefinition : yoGraphicDefinitions) {
            this.addYoGraphic(yoGraphicDefinition);
        }
    }

    default public void addYoGraphic(String namespace, YoGraphicDefinition yoGraphicDefinition) {
        String[] subNames = namespace.split(":");
        if (subNames == null || subNames.length == 0) {
            this.addYoGraphic(yoGraphicDefinition);
        } else {
            for (int i = subNames.length - 1; i >= 0; --i) {
                yoGraphicDefinition = new YoGraphicGroupDefinition(subNames[i], new YoGraphicDefinition[]{yoGraphicDefinition});
            }
            this.addYoGraphic(yoGraphicDefinition);
        }
    }

    @Deprecated
    default public void addYoGraphic(String namespace, Collection<? extends YoGraphicDefinition> yoGraphicDefinitions) {
        this.addYoGraphics(namespace, yoGraphicDefinitions);
    }

    default public void addYoGraphics(String namespace, Collection<? extends YoGraphicDefinition> yoGraphicDefinitions) {
        String[] subNames = namespace.split(":");
        if (subNames == null || subNames.length == 0) {
            this.addYoGraphics(yoGraphicDefinitions);
        } else {
            YoGraphicGroupDefinition group = new YoGraphicGroupDefinition(subNames[subNames.length - 1], yoGraphicDefinitions);
            for (int i = subNames.length - 2; i >= 0; --i) {
                group = new YoGraphicGroupDefinition(subNames[i], new YoGraphicDefinition[]{group});
            }
            this.addYoGraphic((YoGraphicDefinition)group);
        }
    }

    default public void addYoEntry(String variableName) {
        this.addYoEntry(Collections.singletonList(variableName));
    }

    default public void addYoEntry(Collection<String> variableNames) {
        this.addYoEntry(null, variableNames);
    }

    default public void addYoEntry(String groupName, String variableName) {
        this.addYoEntry(groupName, Collections.singletonList(variableName));
    }

    public void addYoEntry(String var1, Collection<String> var2);

    public void requestChartsForceUpdate();

    default public void loadSliderboards(InputStream inputStream) {
        try {
            this.setSliderboards(XMLTools.loadYoSliderboardListDefinition(inputStream));
        }
        catch (JAXBException | IOException e) {
            LogTools.error((String)"Failed to load sliderboard configuration: {}, {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    public void setSliderboards(YoSliderboardListDefinition var1);

    public void clearAllSliderboards();

    default public void setDefaultSliderboard(YoSliderboardDefinition sliderboardDefinition) {
        sliderboardDefinition.setName("Default");
        this.setSliderboard(sliderboardDefinition);
    }

    default public void clearDefaultSliderboard() {
        this.removeSliderboard("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE);
    }

    public void setSliderboard(YoSliderboardDefinition var1);

    public void removeSliderboard(String var1, YoSliderboardType var2);

    default public void setDefaultSliderboardButton(int buttonIndex, String variableName) {
        this.setSliderboardButton("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, new YoButtonDefinition(variableName, buttonIndex));
    }

    default public void setDefaultSliderboardButton(YoButtonDefinition buttonDefinition) {
        this.setSliderboardButton("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, buttonDefinition);
    }

    default public void setSliderboardButton(String sliderboardName, YoSliderboardType sliderboardType, int buttonIndex, String variableName) {
        this.setSliderboardButton(sliderboardName, sliderboardType, new YoButtonDefinition(variableName, buttonIndex));
    }

    public void setSliderboardButton(String var1, YoSliderboardType var2, YoButtonDefinition var3);

    default public void clearDefaultSliderboardButton(int buttonIndex) {
        this.clearSliderboardButton("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, buttonIndex);
    }

    public void clearSliderboardButton(String var1, YoSliderboardType var2, int var3);

    default public void setDefaultSliderboardKnob(int knobIndex, String variableName) {
        this.setSliderboardKnob("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, new YoKnobDefinition(variableName, knobIndex));
    }

    default public void setDefaultSliderboardKnob(YoKnobDefinition knobDefinition) {
        this.setSliderboardKnob("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, knobDefinition);
    }

    default public void setSliderboardKnob(String sliderboardName, YoSliderboardType sliderboardType, int knobIndex, String variableName) {
        this.setSliderboardKnob(sliderboardName, sliderboardType, new YoKnobDefinition(variableName, knobIndex));
    }

    public void setSliderboardKnob(String var1, YoSliderboardType var2, YoKnobDefinition var3);

    default public void clearDefaultSliderboardKnob(int knobIndex) {
        this.clearSliderboardKnob("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, knobIndex);
    }

    public void clearSliderboardKnob(String var1, YoSliderboardType var2, int var3);

    default public void setDefaultSliderboardSlider(int sliderIndex, String variableName) {
        this.setSliderboardSlider("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, new YoSliderDefinition(variableName, sliderIndex));
    }

    default public void setDefaultSliderboardSlider(YoSliderDefinition sliderDefinition) {
        this.setSliderboardSlider("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, sliderDefinition);
    }

    default public void setSliderboardSlider(String sliderboardName, YoSliderboardType sliderboardType, int sliderIndex, String variableName) {
        this.setSliderboardSlider(sliderboardName, sliderboardType, new YoSliderDefinition(variableName, sliderIndex));
    }

    public void setSliderboardSlider(String var1, YoSliderboardType var2, YoSliderDefinition var3);

    default public void clearDefaultSliderboardSlider(int sliderIndex) {
        this.clearSliderboardSlider("Default", YoMultiSliderboardWindowController.DEFAULT_SLIDERBOARD_TYPE, sliderIndex);
    }

    public void clearSliderboardSlider(String var1, YoSliderboardType var2, int var3);

    default public void addSessionDataFilterParameters(String name, Predicate<YoVariable> variableFilter) {
        this.addSessionDataFilterParameters(new SessionDataFilterParameters(name, variableFilter, null));
    }

    public void addSessionDataFilterParameters(SessionDataFilterParameters var1);

    default public void exportVideo(File file) {
        SceneVideoRecordingRequest request = new SceneVideoRecordingRequest();
        request.setFile(file);
        this.exportVideo(request);
    }

    public void exportVideo(SceneVideoRecordingRequest var1);

    public void disableGUIControls();

    public void enableGUIControls();

    public Window getPrimaryGUIWindow();

    public void addCustomGUIControl(Node var1);

    public boolean removeCustomGUIControl(Node var1);

    public void loadCustomGUIPane(String var1, URL var2);

    public void addCustomGUIPane(String var1, Pane var2);

    public boolean removeCustomGUIPane(String var1);

    public YoDoubleProperty newYoDoubleProperty(String var1);

    public YoIntegerProperty newYoIntegerProperty(String var1);

    public YoLongProperty newYoLongProperty(String var1);

    public YoBooleanProperty newYoBooleanProperty(String var1);

    public <E extends Enum<E>> YoEnumAsStringProperty<E> newYoEnumProperty(String var1);

    public void addSessionChangedListener(SessionChangeListener var1);

    public boolean removeSessionChangedListener(SessionChangeListener var1);

    public void requestVisualizerShutdown();

    public void shutdownSession();

    public boolean isVisualizerShutdown();

    public void addVisualizerShutdownListener(Runnable var1);

    public void waitUntilVisualizerFullyUp();

    public void waitUntilVisualizerDown();
}

