/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField;

import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;

public class YoCompositeListSearchField {
    private TextField textField;
    private final Map<String, List<YoComposite>> yoCompositeListMap;
    private final ObjectProperty<List<YoComposite>> compositeListProperty = new SimpleObjectProperty((Object)this, "compositeList", null);
    private AutoCompletionBinding<String> autoCompletionBinding;

    public YoCompositeListSearchField(Map<String, List<YoComposite>> yoCompositeListMap, TextField textField) {
        this.textField = textField;
        this.yoCompositeListMap = yoCompositeListMap;
    }

    public void setupAutoCompletion() {
        this.autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.textField, this.yoCompositeListMap.keySet());
        this.autoCompletionBinding.prefWidthProperty().bind((ObservableValue)this.textField.widthProperty());
        this.textField.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (this.textField.isFocused() && e.isControlDown() && e.getCode() == KeyCode.SPACE) {
                this.autoCompletionBinding.setUserInput(this.textField.getText());
                e.consume();
            }
        });
        this.autoCompletionBinding.setOnAutoCompleted(event -> this.compositeListProperty.set(this.yoCompositeListMap.get(event.getCompletion())));
    }

    public ReadOnlyObjectProperty<List<YoComposite>> compositeListProperty() {
        return this.compositeListProperty;
    }
}

