/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.remote;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.robotDataLogger.StaticHostListLoader;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.interfaces.DataServerDiscoveryListener;
import us.ihmc.robotDataLogger.websocket.client.discovery.DataServerDiscoveryClient;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;
import us.ihmc.scs2.session.remote.FunctionalDataServerDiscoveryListener;
import us.ihmc.scs2.session.remote.RemoteSession;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionInfoController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.RemoteSessionFactory;
import us.ihmc.scs2.sessionVisualizer.jfx.session.remote.YoClientInformationPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.IntegerConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TreeTableViewTools;

public class RemoteSessionManagerController
implements SessionControlsController {
    private static final String OFFLINE_HOSTNAME_DESCRIPTION = "[Offline]";
    private static final String OFFLINE_SESSIONNAME_DESCRIPTION = "";
    public static final int DEFAULT_TIMEOUT = 25000;
    private static final Integer DEFAULT_PORT = 8008;
    @FXML
    private AnchorPane mainPane;
    @FXML
    private TreeTableView<SessionInfo> sessionTreeTableView;
    @FXML
    private Pane staticControlsPane;
    @FXML
    private TextField staticHostTextField;
    @FXML
    private TextField staticPortTextField;
    @FXML
    private Button createStaticHostButton;
    @FXML
    private ProgressIndicator loadingSpinner;
    @FXML
    private Button startSessionButton;
    @FXML
    private Button endSessionButton;
    private YoVariableClient client;
    private final RemoteSessionFactory sessionFactory = new RemoteSessionFactory();
    private TreeItem<SessionInfo> rootSession;
    private ObservableMap<HTTPDataServerDescription, TreeItem<SessionInfo>> descriptionToTreeItemMap = FXCollections.observableMap(new HashMap());
    private final ObjectProperty<HTTPDataServerDescription> staticDescriptionProperty = new SimpleObjectProperty((Object)this, "staticDescription", null);
    private final ObservableList<HTTPDataServerDescription> registeredStaticDescriptions = FXCollections.observableArrayList();
    private final BooleanProperty sessionInProgressProperty = new SimpleBooleanProperty((Object)this, "sessionInProgress", false);
    private DataServerDiscoveryClient discoveryClient;
    private BackgroundExecutorManager backgroundExecutorManager;
    private YoClientInformationPaneController informationPaneController;
    private Stage stage;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit) {
        this.backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.client = new YoVariableClient((YoVariablesUpdatedListener)this.sessionFactory);
        this.mainPane.getStylesheets().add((Object)SessionVisualizerIOTools.GENERAL_STYLESHEET.toExternalForm());
        TreeTableColumn<SessionInfo, String> hostColumn = this.createColumn("Host", 150.0, 100.0, 200.0, SessionInfo::getHost);
        TreeTableColumn<SessionInfo, String> portColumn = this.createColumn("Port", 80.0, SessionInfo::getPort);
        TreeTableColumn<SessionInfo, String> hostNameColumn = this.createColumn("HostName", 175.0, 100.0, 250.0, SessionInfo::getHostName);
        TreeTableColumn<SessionInfo, String> sessionNameColumn = this.createColumn("SessionName", 250.0, 200.0, 500.0, SessionInfo::getSessionName);
        this.rootSession = new RecursiveTreeItem(FXCollections.observableArrayList(), RecursiveTreeObject::getChildren);
        this.sessionTreeTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.sessionTreeTableView.setRoot(this.rootSession);
        this.sessionTreeTableView.setShowRoot(false);
        this.sessionTreeTableView.getColumns().setAll((Object[])new TreeTableColumn[]{hostColumn, portColumn, hostNameColumn, sessionNameColumn});
        TextFormatter portFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)DEFAULT_PORT, (UnaryOperator)new PositiveIntegerValueFilter());
        this.staticPortTextField.setTextFormatter(portFormatter);
        this.createStaticHostButton.setDisable(true);
        this.staticHostTextField.textProperty().addListener((o, oldValue, newValue) -> this.createStaticHostButton.setDisable(RemoteSessionManagerController.isEmpty(newValue) || RemoteSessionManagerController.isEmpty(this.staticPortTextField.getText())));
        this.staticPortTextField.textProperty().addListener((o, oldValue, newValue) -> this.createStaticHostButton.setDisable(RemoteSessionManagerController.isEmpty(newValue) || RemoteSessionManagerController.isEmpty(this.staticPortTextField.getText())));
        this.createStaticHostButton.setOnAction(e -> this.staticDescriptionProperty.set((Object)new HTTPDataServerDescription(this.staticHostTextField.getText(), Integer.parseInt(this.staticPortTextField.getText()), null, true)));
        this.staticDescriptionProperty.addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.staticHostTextField.setText(null);
                portFormatter.setValue((Object)DEFAULT_PORT);
            } else {
                this.staticHostTextField.setText(newValue.getHost());
                portFormatter.setValue((Object)newValue.getPort());
            }
        });
        this.rootSession.getChildren().addListener((ListChangeListener)new ListChangeListener<TreeItem<SessionInfo>>(){

            public void onChanged(ListChangeListener.Change<? extends TreeItem<SessionInfo>> c) {
                while (c.next()) {
                    if (c.wasRemoved()) {
                        c.getRemoved().forEach(item -> RemoteSessionManagerController.this.descriptionToTreeItemMap.remove((Object)((SessionInfo)((Object)((Object)item.getValue()))).getDescription()));
                    }
                    if (!c.wasAdded()) continue;
                    c.getAddedSubList().forEach(item -> RemoteSessionManagerController.this.descriptionToTreeItemMap.put((Object)((SessionInfo)((Object)((Object)item.getValue()))).getDescription(), item));
                }
            }
        });
        this.discoveryClient = new DataServerDiscoveryClient((DataServerDiscoveryListener)((FunctionalDataServerDiscoveryListener)connection -> this.updateConnection(connection)), true);
        this.staticDescriptionProperty.addListener((o, oldValue, newValue) -> {
            if (newValue != null && newValue.getHost() != null) {
                LogTools.info((String)"Adding description");
                this.addDescription((HTTPDataServerDescription)newValue);
                this.staticDescriptionProperty.set(null);
            }
        });
        MenuTools.setupContextMenu(this.sessionTreeTableView, new Function[]{TreeTableViewTools.removeMenuItemFactory(false, sessionInfo -> this.registeredStaticDescriptions.contains((Object)sessionInfo.getDescription()), sessionInfo -> this.registeredStaticDescriptions.remove((Object)sessionInfo.getDescription()))});
        this.startSessionButton.setDisable(true);
        this.endSessionButton.disableProperty().bind((ObservableValue)this.sessionInProgressProperty.not());
        this.sessionTreeTableView.disableProperty().bind((ObservableValue)this.sessionInProgressProperty);
        this.staticControlsPane.disableProperty().bind((ObservableValue)this.sessionInProgressProperty);
        this.sessionInProgressProperty.addListener((o, oldValue, newValue) -> this.startSessionButton.setDisable(newValue.booleanValue()));
        this.loadingSpinner.disabledProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.startSessionButton.setDisable(true);
            }
        });
        this.sessionTreeTableView.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.startSessionButton.setDisable(true);
            } else {
                HTTPDataServerConnection connection = ((SessionInfo)((Object)((Object)newValue.getValue()))).getConnection();
                if (connection == null) {
                    this.startSessionButton.setDisable(true);
                } else {
                    this.startSessionButton.setDisable(!connection.isConnected());
                }
            }
        });
        StaticHostListLoader.load().forEach(this::addDescription);
        this.registeredStaticDescriptions.addListener(c -> {
            try {
                StaticHostListLoader.save(new ArrayList(c.getList()));
                LogTools.info((String)"Save static host list.");
            }
            catch (IOException e) {
                LogTools.warn((String)("Cannot save host list. " + e.getMessage()));
            }
        });
        this.startSessionButton.setOnAction(e -> this.startSession());
        this.sessionTreeTableView.setOnMouseClicked(e -> {
            if (e.getClickCount() != 2) {
                return;
            }
            this.startSession();
        });
        this.endSessionButton.setOnAction(e -> this.stopSession());
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.REMOTE_SESSION_INFO_PANE_FXML_URL);
            loader.load();
            this.informationPaneController = (YoClientInformationPaneController)loader.getController();
            this.informationPaneController.initialize();
            this.informationPaneController.start();
            this.informationPaneController.activeSessionProperty().bind(this.sessionFactory.activeSessionProperty());
            SessionVisualizerTopics topics = toolkit.getTopics();
            SCS2JavaFXMessager messager = toolkit.getMessager();
            this.sessionFactory.activeSessionProperty().addListener((arg_0, arg_1, arg_2) -> RemoteSessionManagerController.lambda$initialize$15((JavaFXMessager)messager, topics, arg_0, arg_1, arg_2));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.stage = new Stage();
        this.stage.setScene(new Scene((Parent)this.mainPane));
        this.stage.setTitle("Active remote sessions");
        this.stage.getIcons().add((Object)SessionVisualizerIOTools.REMOTE_SESSION_IMAGE);
        toolkit.getMainWindow().addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.shutdown();
            }
        });
    }

    private static boolean isEmpty(String query) {
        return query == null || query.isEmpty();
    }

    private void updateConnection(HTTPDataServerConnection connection) {
        if (connection.getTarget().isPersistant() || connection.isConnected()) {
            JavaFXMissingTools.runLater(this.getClass(), () -> this.addConnection(connection));
        } else {
            JavaFXMissingTools.runLater(this.getClass(), () -> this.removeConnection(connection));
        }
    }

    private TreeItem<SessionInfo> addDescription(HTTPDataServerDescription description) {
        TreeItem treeItem = (TreeItem)this.descriptionToTreeItemMap.get((Object)description);
        if (treeItem == null) {
            SessionInfo sessionInfo = new SessionInfo();
            sessionInfo.setDescription(description);
            treeItem = new TreeItem((Object)sessionInfo);
            this.rootSession.getChildren().add((Object)treeItem);
            if (description.isPersistant()) {
                this.registeredStaticDescriptions.add((Object)description);
                this.discoveryClient.addHost(description);
            }
        }
        return treeItem;
    }

    private void addConnection(HTTPDataServerConnection connection) {
        TreeItem<SessionInfo> treeItem = this.addDescription(connection.getTarget());
        ((SessionInfo)((Object)treeItem.getValue())).setConnection(connection);
    }

    private void removeDescription(HTTPDataServerDescription description) {
        TreeItem treeItem = (TreeItem)this.descriptionToTreeItemMap.get((Object)description);
        if (treeItem == null) {
            return;
        }
        this.rootSession.getChildren().remove((Object)treeItem);
        this.registeredStaticDescriptions.remove((Object)description);
    }

    private void removeConnection(HTTPDataServerConnection connection) {
        this.removeDescription(connection.getTarget());
    }

    private void startSession() {
        TreeItem selectedItem = (TreeItem)this.sessionTreeTableView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        if (this.sessionInProgressProperty.get()) {
            this.unloadSession();
        }
        this.setIsLoading(true);
        this.sessionInProgressProperty.set(true);
        this.backgroundExecutorManager.executeInBackground(() -> {
            try {
                this.client.start(25000, ((SessionInfo)((Object)((Object)selectedItem.getValue()))).getConnection());
            }
            catch (Throwable e) {
                e.printStackTrace();
                JavaFXMissingTools.runLater(this.getClass(), () -> this.unloadSession());
            }
        });
    }

    @Override
    public void notifySessionLoaded() {
        this.setIsLoading(false);
    }

    private void stopSession() {
        if (!this.sessionInProgressProperty.get()) {
            return;
        }
        this.sessionFactory.unloadSession();
        try {
            this.client.stop();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.setIsLoading(false);
        this.sessionInProgressProperty.set(false);
    }

    @Override
    public void shutdown() {
        this.setIsLoading(false);
        this.sessionInProgressProperty.set(false);
        try {
            if (this.sessionFactory.activeSessionProperty().get() != null) {
                this.stopSession();
                ThreadTools.sleep((long)500L);
            }
            this.client.stop();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.discoveryClient.close();
        this.informationPaneController.stop();
        this.stage.close();
    }

    @Override
    public void unloadSession() {
        this.stopSession();
    }

    @Override
    public SessionInfoController getSessionInfoController() {
        return this.informationPaneController;
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    private void setIsLoading(boolean isLoading) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.loadingSpinner.setVisible(isLoading));
    }

    private TreeTableColumn<SessionInfo, String> createColumn(String name, double prefWidth, Function<SessionInfo, StringProperty> fieldProvider) {
        return this.createColumn(name, prefWidth, prefWidth, prefWidth, fieldProvider);
    }

    private TreeTableColumn<SessionInfo, String> createColumn(String name, double prefWidth, double minWidth, double maxWidth, Function<SessionInfo, StringProperty> fieldProvider) {
        JFXTreeTableColumn column = new JFXTreeTableColumn(name);
        column.setPrefWidth(prefWidth);
        column.setMinWidth(minWidth);
        column.setMaxWidth(maxWidth);
        column.setCellValueFactory(param -> (ObservableValue)fieldProvider.apply((SessionInfo)((Object)((Object)param.getValue().getValue()))));
        return column;
    }

    private static /* synthetic */ void lambda$initialize$15(JavaFXMessager messager, SessionVisualizerTopics topics, ObservableValue o, RemoteSession oldValue, RemoteSession newValue) {
        messager.submitMessage(topics.getStartNewSessionRequest(), (Object)newValue);
    }

    public static class SessionInfo
    extends RecursiveTreeObject<SessionInfo> {
        private final StringProperty host = new SimpleStringProperty((Object)this, "host", null);
        private final StringProperty port = new SimpleStringProperty((Object)this, "port", null);
        private final StringProperty hostName = new SimpleStringProperty((Object)this, "hostName", "[Offline]");
        private final StringProperty sessionName = new SimpleStringProperty((Object)this, "sessionName", "");
        private final ObjectProperty<HTTPDataServerDescription> descriptionProperty = new SimpleObjectProperty((Object)this, "description", null);
        private final ObjectProperty<HTTPDataServerConnection> connectionProperty = new SimpleObjectProperty((Object)this, "connection", null);

        public SessionInfo() {
            this.descriptionProperty.addListener((o, oldValue, newValue) -> {
                if (newValue != null) {
                    this.host.set((Object)newValue.getHost());
                    this.port.set((Object)Integer.toString(newValue.getPort()));
                    this.updateConnection((HTTPDataServerConnection)this.connectionProperty.get());
                }
            });
            this.connectionProperty.addListener((o, oldValue, newValue) -> this.updateConnection((HTTPDataServerConnection)newValue));
        }

        private void updateConnection(HTTPDataServerConnection connection) {
            if (connection != null && connection.isConnected()) {
                this.hostName.set((Object)connection.getAnnouncement().getHostNameAsString());
                this.sessionName.set((Object)connection.getAnnouncement().getNameAsString());
            } else {
                this.hostName.set((Object)RemoteSessionManagerController.OFFLINE_HOSTNAME_DESCRIPTION);
                this.sessionName.set((Object)RemoteSessionManagerController.OFFLINE_SESSIONNAME_DESCRIPTION);
            }
        }

        public void setDescription(HTTPDataServerDescription description) {
            this.descriptionProperty.set((Object)description);
        }

        public HTTPDataServerDescription getDescription() {
            return (HTTPDataServerDescription)this.descriptionProperty.get();
        }

        public ObjectProperty<HTTPDataServerDescription> descriptionProperty() {
            return this.descriptionProperty;
        }

        public void setConnection(HTTPDataServerConnection connection) {
            this.connectionProperty.set((Object)connection);
        }

        public HTTPDataServerConnection getConnection() {
            return (HTTPDataServerConnection)this.connectionProperty.get();
        }

        public ObjectProperty<HTTPDataServerConnection> connectionProperty() {
            return this.connectionProperty;
        }

        public StringProperty getHost() {
            return this.host;
        }

        public StringProperty getPort() {
            return this.port;
        }

        public StringProperty getHostName() {
            return this.hostName;
        }

        public StringProperty getSessionName() {
            return this.sessionName;
        }
    }
}

