/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import us.ihmc.scs2.sessionVisualizer.jfx.Camera3DRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraFocalPointHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MainViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SingleViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;

public class MultiViewport3DManager {
    private final GridPane container = new GridPane();
    private final Group mainView3DRoot;
    private final MainViewport3DManager mainViewport;
    private final YoManager yoManager;
    private final YoCompositeSearchManager yoCompositeSearchManager;
    private final ReferenceFrameManager referenceFrameManager;
    private final ObservableList<SingleViewport3DManager> allViewports = FXCollections.observableArrayList();
    private final IntegerProperty numberOfColumns = new SimpleIntegerProperty((Object)this, "numberOfColumns", 2);

    public MultiViewport3DManager(Group mainView3DRoot, YoManager yoManager, YoCompositeSearchManager yoCompositeSearchManager, ReferenceFrameManager referenceFrameManager) {
        this.mainView3DRoot = mainView3DRoot;
        this.yoManager = yoManager;
        this.yoCompositeSearchManager = yoCompositeSearchManager;
        this.referenceFrameManager = referenceFrameManager;
        this.allViewports.addListener(change -> this.refreshLayout());
        this.numberOfColumns.addListener((o, oldValue, newValue) -> this.refreshLayout());
        this.mainViewport = new MainViewport3DManager(mainView3DRoot, yoManager, yoCompositeSearchManager, referenceFrameManager);
        this.allViewports.add((Object)this.mainViewport);
    }

    public void submitRequest(Camera3DRequest request) {
        Camera3DRequest.CameraControlRequest cameraControlRequest;
        Camera3DRequest.FocalPointRequest focalPointRequest = request.getFocalPointRequest();
        if (focalPointRequest != null && focalPointRequest.getTrackingTargetType() != null) {
            switch (focalPointRequest.getTrackingTargetType()) {
                case Node: {
                    this.mainViewport.setCameraFocalNodeToTrack(focalPointRequest.getNode());
                    break;
                }
                case YoCoordinates: {
                    this.mainViewport.setCameraFocalPositionToTrack(focalPointRequest.getCoordinatesToTrack());
                    break;
                }
                case Disabled: {
                    this.mainViewport.setCameraFocalTargetTypeToTrack(CameraFocalPointHandler.TrackingTargetType.Disabled);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected target type: " + focalPointRequest.getTrackingTargetType());
                }
            }
        }
        if ((cameraControlRequest = request.getCameraControlRequest()) != null && cameraControlRequest.getControlMode() != null) {
            switch (cameraControlRequest.getControlMode()) {
                case Position: {
                    this.mainViewport.setCameraPositionToTrack(cameraControlRequest.getPositionToTrack());
                    break;
                }
                case Orbital: {
                    this.mainViewport.setCameraOrbitToTrack(cameraControlRequest.getOrbitToTrack());
                    break;
                }
                case LevelOrbital: {
                    this.mainViewport.setCameraLevelOrbitToTrack(cameraControlRequest.getLevelOrbitToTrack());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected control mode: " + cameraControlRequest.getControlMode());
                }
            }
            this.mainViewport.setCameraControlMode(cameraControlRequest.getControlMode());
        }
    }

    public void refreshLayout() {
        this.container.getChildren().clear();
        int numCols = this.numberOfColumns.get();
        int col = 0;
        int row = 0;
        for (int i = 0; i < this.allViewports.size(); ++i) {
            Pane pane = ((SingleViewport3DManager)this.allViewports.get(i)).getPane();
            this.container.add((Node)pane, col, row);
            GridPane.setHgrow((Node)pane, (Priority)Priority.SOMETIMES);
            GridPane.setVgrow((Node)pane, (Priority)Priority.SOMETIMES);
            if (++col < numCols) continue;
            col = 0;
            ++row;
        }
    }

    public void addSecondaryViewport() {
        this.allViewports.add((Object)new SecondaryViewport3DManager(this.mainView3DRoot, this.yoManager, this.yoCompositeSearchManager, this.referenceFrameManager));
    }

    public MainViewport3DManager getMainViewport() {
        return this.mainViewport;
    }

    public Pane getPane() {
        return this.container;
    }

    public void dispose() {
        this.allViewports.forEach(viewport -> viewport.dispose());
        this.allViewports.clear();
    }
}

