/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu;

import java.io.File;
import java.io.IOException;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.CheckMenuItem;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.Plotter2DOptionsStageController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.NewTerrainVisualRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoRobot.NewRobotVisualRequest;

public class YoGraphicMenuController
implements VisualizerController {
    @FXML
    private CheckMenuItem overheadPlotterMenuItem;
    @FXML
    private CheckMenuItem showRobotMenuItem;
    @FXML
    private CheckMenuItem enableWireframeRobotModeMenuItem;
    @FXML
    private CheckMenuItem showTerrainMenuItem;
    @FXML
    private CheckMenuItem enableWireframeTerrainModeMenuItem;
    private SessionVisualizerWindowToolkit toolkit;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    private Stage owner;
    private Property<Plotter2DOptionsStageController> plotterOptionsController = new SimpleObjectProperty((Object)this, "plotterOptionsController", null);

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.owner = toolkit.getWindow();
        this.messager.bindBidirectional(this.topics.getShowOverheadPlotter(), (Property)this.overheadPlotterMenuItem.selectedProperty(), false);
        this.showRobotMenuItem.selectedProperty().addListener((o, oldValue, newValue) -> this.messager.submitMessage(this.topics.getRobotVisualRequest(), (Object)NewRobotVisualRequest.visible("AllOfTheRobots!", newValue)));
        this.enableWireframeRobotModeMenuItem.selectedProperty().addListener((o, oldValue, newValue) -> this.messager.submitMessage(this.topics.getRobotVisualRequest(), (Object)NewRobotVisualRequest.wireframeMode("AllOfTheRobots!", newValue)));
        this.showTerrainMenuItem.selectedProperty().addListener((o, oldValue, newValue) -> this.messager.submitMessage(this.topics.getTerrainVisualRequest(), (Object)NewTerrainVisualRequest.visible(newValue)));
        this.enableWireframeTerrainModeMenuItem.selectedProperty().addListener((o, oldValue, newValue) -> this.messager.submitMessage(this.topics.getTerrainVisualRequest(), (Object)NewTerrainVisualRequest.wireframeMode(newValue)));
    }

    @FXML
    private void openPlotter2DOptions() {
        if (this.plotterOptionsController.getValue() != null) {
            ((Plotter2DOptionsStageController)this.plotterOptionsController.getValue()).close();
            this.plotterOptionsController.setValue(null);
        }
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.PLOTTER2D_OPTIONS_STAGE_URL);
            loader.load();
            Plotter2DOptionsStageController controller = (Plotter2DOptionsStageController)loader.getController();
            controller.initialize(this.toolkit);
            controller.getStage().show();
            this.plotterOptionsController.setValue((Object)controller);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void loadYoGraphic() {
        File result = SessionVisualizerIOTools.yoGraphicConfigurationOpenFileDialog((Window)this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoGraphicLoadRequest(), (Object)result);
        }
    }

    @FXML
    private void saveYoGraphic() {
        File result = SessionVisualizerIOTools.yoGraphicConfigurationSaveFileDialog((Window)this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoGraphicSaveRequest(), (Object)result);
        }
    }

    @FXML
    private void openYoGraphicEditor() {
        this.messager.submitMessage(this.topics.getOpenWindowRequest(), (Object)SecondaryWindowManager.NewWindowRequest.graphicEditorWindow((Window)this.owner));
    }
}

