/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.PropertySearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;

public class StringSearchField
extends PropertySearchField<StringProperty> {
    private final YoCompositeSearchManager searchManager;
    private final BooleanProperty isNumberProperty = new SimpleBooleanProperty((Object)this, "isNumber", false);
    private final BooleanProperty isYoCompositeProperty = new SimpleBooleanProperty((Object)this, "isYoComposite", false);
    private final Property<YoComposite> yoCompositeProperty = new SimpleObjectProperty((Object)this, "yoComposite", null);

    public StringSearchField(TextField textField, YoCompositeSearchManager searchManager) {
        this(textField, searchManager, null);
    }

    public StringSearchField(TextField textField, YoCompositeSearchManager searchManager, ImageView validImageView) {
        super(textField, validImageView);
        this.searchManager = searchManager;
        this.supplierProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.isNumberProperty.set(false);
                this.isYoCompositeProperty.set(false);
            } else {
                this.isNumberProperty.set(CompositePropertyTools.isParsableAsNumber((String)newValue.get()));
                YoCompositeCollection yoVariableCollection = searchManager.getYoVariableCollection();
                YoComposite yoComposite = yoVariableCollection.getYoCompositeFromUniqueName((String)newValue.get());
                if (yoComposite == null) {
                    yoComposite = yoVariableCollection.getYoCompositeFromFullname((String)newValue.get());
                }
                this.yoCompositeProperty.setValue((Object)yoComposite);
                this.isYoCompositeProperty.set(this.yoCompositeProperty.getValue() != null);
            }
        });
    }

    @Override
    protected boolean isTextValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        YoCompositeCollection yoVariableCollection = this.searchManager.getYoVariableCollection();
        YoComposite yoComposite = yoVariableCollection.getYoCompositeFromUniqueName(text);
        if (yoComposite == null) {
            yoComposite = yoVariableCollection.getYoCompositeFromFullname(text);
        }
        return yoComposite != null || CompositePropertyTools.isParsableAsNumber(text);
    }

    @Override
    protected String simplifyText(String text) {
        YoCompositeCollection yoVariableCollection = this.searchManager.getYoVariableCollection();
        YoComposite yoComposite = yoVariableCollection.getYoCompositeFromFullname(text);
        return yoComposite == null ? null : yoComposite.getUniqueShortName();
    }

    @Override
    protected Callback<AutoCompletionBinding.ISuggestionRequest, Collection<String>> createSuggestions() {
        return request -> {
            String userText = request.getUserText();
            if (CompositePropertyTools.isParsableAsNumber(userText)) {
                return null;
            }
            YoCompositeCollection yoVariableCollection = this.searchManager.getYoVariableCollection();
            Collection<String> uniqueNameCollection = yoVariableCollection.uniqueNameCollection();
            if (userText.isEmpty()) {
                return uniqueNameCollection;
            }
            String userTextLowerCase = userText.toLowerCase();
            return uniqueNameCollection.stream().filter(v -> v.toLowerCase().contains(userTextLowerCase)).collect(Collectors.toList());
        };
    }

    @Override
    protected StringProperty toSupplier(String text) {
        YoCompositeCollection yoVariableCollection = this.searchManager.getYoVariableCollection();
        YoComposite yoComposite = yoVariableCollection.getYoCompositeFromUniqueName(text);
        if (yoComposite == null) {
            return new SimpleStringProperty(text);
        }
        return new SimpleStringProperty(yoComposite.getYoComponents().get(0).getFullNameString());
    }

    @Override
    protected List<YoComposite> retrieveYoCompositesFromDragboard(Dragboard dragboard) {
        return DragAndDropTools.retrieveYoCompositesFromDragBoard(dragboard, this.searchManager.getYoVariableCollection());
    }

    public BooleanProperty isNumberProperty() {
        return this.isNumberProperty;
    }

    public boolean isNumber() {
        return this.isNumberProperty.get();
    }

    public BooleanProperty isYoCompositeProperty() {
        return this.isYoCompositeProperty;
    }

    public boolean isYoComposite() {
        return this.isYoCompositeProperty.get();
    }

    public Property<YoComposite> yoCompositeProperty() {
        return this.yoCompositeProperty;
    }

    public YoComposite getYoComposite() {
        return (YoComposite)this.yoCompositeProperty.getValue();
    }
}

