/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoComposite;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositePattern;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoCompositeCollection {
    private final YoCompositePattern pattern;
    private final List<YoComposite> yoComposites;
    private final Map<String, YoComposite> uniqueNameToYoComposite;
    private final Map<String, YoComposite> uniqueShortNameToYoComposite;
    private final Map<String, YoComposite> fullnameToYoComposite;

    public YoCompositeCollection(YoCompositePattern pattern, List<YoComposite> yoComposites) {
        this.pattern = pattern;
        this.yoComposites = yoComposites;
        YoComposite.computeUniqueNames(yoComposites);
        this.uniqueNameToYoComposite = yoComposites.stream().collect(Collectors.toMap(YoComposite::getUniqueName, Function.identity()));
        this.uniqueShortNameToYoComposite = yoComposites.stream().collect(Collectors.toMap(YoComposite::getUniqueShortName, Function.identity()));
        this.fullnameToYoComposite = yoComposites.stream().collect(Collectors.toMap(YoComposite::getFullname, Function.identity()));
    }

    public YoCompositePattern getPattern() {
        return this.pattern;
    }

    public List<YoComposite> getYoComposites() {
        return this.yoComposites;
    }

    public List<YoComposite> getYoComposite(YoRegistry owner) {
        return this.yoComposites.stream().filter(composite -> composite.getNamespace().equals((Object)owner.getNamespace())).collect(Collectors.toList());
    }

    public String getYoVariableUniqueName(YoVariable yoVariable) {
        YoComposite yoTypeReference = this.fullnameToYoComposite.get(yoVariable.getFullNameString());
        return yoTypeReference != null ? yoTypeReference.getUniqueName() : null;
    }

    public String getYoVariableUniqueShortName(YoVariable yoVariable) {
        YoComposite yoTypeReference = this.fullnameToYoComposite.get(yoVariable.getFullNameString());
        return yoTypeReference != null ? yoTypeReference.getUniqueShortName() : null;
    }

    public YoComposite getYoCompositeFromUniqueName(String uniqueName) {
        YoComposite result = this.uniqueNameToYoComposite.get(uniqueName);
        if (result == null) {
            result = this.uniqueShortNameToYoComposite.get(uniqueName);
        }
        return result;
    }

    public YoComposite getYoCompositeFromFullname(String fullname) {
        return this.fullnameToYoComposite.get(fullname);
    }

    public Collection<String> uniqueNameCollection() {
        return this.uniqueNameToYoComposite.keySet();
    }

    public Collection<String> uniqueShortNameCollection() {
        return this.uniqueShortNameToYoComposite.keySet();
    }

    public Collection<String> fullnameCollection() {
        return this.fullnameToYoComposite.keySet();
    }
}

