/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FilenameUtils;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.log.LogSession;
import us.ihmc.scs2.session.mcap.MCAPLogSession;

public class SessionVisualizerArgsHandler {
    private Session session = null;

    public boolean parseArgs(String[] args) throws Exception {
        String defaultRobotFileName;
        long desiredDT;
        String logFileName;
        Options options = new Options();
        options.addOption("l", "log", true, "Log file to load, can either be a SCS2 log file or a MCAP log file.");
        options.addOption("t", "dt", true, "If possible, the desired DT in seconds to use for the session visualizer. Default value is 1 millisecond.");
        options.addOption("r", "robot", true, "Default robot file to load in case the log file does not contain any robot definition. Can be either a URDF or SDF file.");
        options.addOption("h", "help", false, "Print this message.");
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                String header = "SCS2 SessionVisualizer Application: This application is used to visualize log files.";
                String footer = "Please report issues at https://github.com/ihmcrobotics/simulation-construction-set-2/issues.";
                new HelpFormatter().printHelp("SCS2 - SessionVisualizer", header, options, footer, true);
                return false;
            }
            logFileName = line.getOptionValue("log");
            desiredDT = (long)(1.0E9 * Double.parseDouble(line.getOptionValue("dt", "0.001")));
            defaultRobotFileName = line.getOptionValue("robot");
        }
        catch (Exception e) {
            System.err.println("Parsing failed, use option -h to see usage. Reason: " + e.getMessage());
            return false;
        }
        if (logFileName != null) {
            File logFile = new File(logFileName);
            if (!logFile.exists()) {
                System.err.println("Cannot find log file: " + logFile.getAbsolutePath());
                return false;
            }
            if (FilenameUtils.getExtension((String)logFileName).equals("mcap")) {
                File defaultRobotFile;
                if (defaultRobotFileName == null) {
                    defaultRobotFile = null;
                } else {
                    defaultRobotFile = new File(defaultRobotFileName);
                    if (!defaultRobotFile.exists()) {
                        System.err.println("Cannot find default robot file: " + defaultRobotFile.getAbsolutePath());
                        return false;
                    }
                }
                this.session = new MCAPLogSession(logFile, desiredDT, defaultRobotFile);
            } else if (logFileName.equals("robotData.log")) {
                this.session = new LogSession(logFile.getParentFile(), null);
            } else if (logFile.isDirectory()) {
                File[] result = logFile.listFiles((dir, name) -> name.equals("robotData.log"));
                if (result == null || result.length == 0) {
                    System.err.println("Cannot find log file: " + logFile.getAbsolutePath());
                    return false;
                }
                this.session = new LogSession(logFile, null);
            } else {
                System.err.println("Unknown log file type: " + logFile.getAbsolutePath());
                return false;
            }
        }
        return true;
    }

    public Session getSession() {
        return this.session;
    }
}

