/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoRobotFXManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoArrowFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoBoxFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoCapsuleFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoConeFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoConvexPolytopeFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoCoordinateSystemFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoCylinderFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoEllipsoidFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGhostRobotFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoLineFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPointFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPointFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPointcloudFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPointcloudFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPolygonExtrudedFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPolygonFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPolynomialFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoRampFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoSTPBoxFX3D;

public class YoGraphicItemCreatorDialogController {
    @FXML
    private Pane mainPane;
    @FXML
    private ToggleButton yoLineFX2DToggleButton;
    @FXML
    private ToggleButton yoPointcloudFX2DToggleButton;
    @FXML
    private ToggleButton yoPointFX2DToggleButton;
    @FXML
    private ToggleButton yoPolygonFX2DToggleButton;
    @FXML
    private ToggleButton yoArrowFX3DToggleButton;
    @FXML
    private ToggleButton yoBoxFX3DToggleButton;
    @FXML
    private ToggleButton yoCapsuleFX3DToggleButton;
    @FXML
    private ToggleButton yoConeFX3DToggleButton;
    @FXML
    private ToggleButton yoCoordinateSystemFX3DToggleButton;
    @FXML
    private ToggleButton yoCylinderFX3DToggleButton;
    @FXML
    private ToggleButton yoEllipsoidFX3DToggleButton;
    @FXML
    private ToggleButton yoPointcloudFX3DToggleButton;
    @FXML
    private ToggleButton yoPointFX3DToggleButton;
    @FXML
    private ToggleButton yoPolygonExtrudedFX3DToggleButton;
    @FXML
    private ToggleButton yoConvexPolytopeFX3DToggleButton;
    @FXML
    private ToggleButton yoPolynomialFX3DToggleButton;
    @FXML
    private ToggleButton yoRampFX3DToggleButton;
    @FXML
    private ToggleButton yoSTPBoxFX3DToggleButton;
    @FXML
    private ToggleButton yoAddRobotFXToggleButton;
    @FXML
    private GridPane miscPane;
    @FXML
    private ToggleButton yoGroupFXToggleButton;
    @FXML
    private TextField itemNameTextField;
    @FXML
    private TextField itemNamespaceTextField;
    @FXML
    private ImageView itemNameValidImageView;
    @FXML
    private Button createItemButton;
    @FXML
    private TitledPane graphics2DTitledPane;
    @FXML
    private TitledPane graphics3DTitledPane;
    @FXML
    private TitledPane miscTitledPane;
    @FXML
    private Accordion accordion;
    private final ObservableList<ToggleButton> robotCollisionsToggleButtons = FXCollections.observableArrayList();
    private ToggleButton terrainCollisionsToggleButton = null;
    private final ObservableList<ToggleButton> robotMassPropertiesToggleButtons = FXCollections.observableArrayList();
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private final Stage stage = new Stage(StageStyle.UTILITY);
    private final BooleanProperty itemNameValidityProperty = new SimpleBooleanProperty((Object)this, "itemNameValidity", false);
    private final BooleanProperty userValidatedProperty = new SimpleBooleanProperty((Object)this, "userValidated", false);
    private final Map<Toggle, Class<? extends YoGraphicFXItem>> buttonToTypeMap = new LinkedHashMap<Toggle, Class<? extends YoGraphicFXItem>>();
    private final Map<Class<? extends YoGraphicFXItem>, String> typeToDefaultNameMap = new LinkedHashMap<Class<? extends YoGraphicFXItem>, String>();
    private ReferenceFrameWrapper worldFrame;
    private YoRobotFXManager robotFXManager;
    private YoManager yoManager;
    private ReferenceFrameManager referenceFrameManager;
    private ObservableList<RobotDefinition> sessionRobotDefinitions;
    private ObservableList<TerrainObjectDefinition> sessionTerrainObjectDefinitions;
    private YoGroupFX parent;

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.accordion.setExpandedPane(this.graphics2DTitledPane);
        this.referenceFrameManager = toolkit.getReferenceFrameManager();
        this.worldFrame = this.referenceFrameManager.getWorldFrame();
        this.robotFXManager = toolkit.getYoRobotFXManager();
        this.yoManager = toolkit.getYoManager();
        this.sessionRobotDefinitions = toolkit.getSessionRobotDefinitions();
        this.sessionTerrainObjectDefinitions = toolkit.getSessionTerrainObjectDefinitions();
        this.buttonToTypeMap.put((Toggle)this.yoLineFX2DToggleButton, YoLineFX2D.class);
        this.buttonToTypeMap.put((Toggle)this.yoPointcloudFX2DToggleButton, YoPointcloudFX2D.class);
        this.buttonToTypeMap.put((Toggle)this.yoPointFX2DToggleButton, YoPointFX2D.class);
        this.buttonToTypeMap.put((Toggle)this.yoPolygonFX2DToggleButton, YoPolygonFX2D.class);
        this.buttonToTypeMap.put((Toggle)this.yoArrowFX3DToggleButton, YoArrowFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoBoxFX3DToggleButton, YoBoxFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoCapsuleFX3DToggleButton, YoCapsuleFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoConeFX3DToggleButton, YoConeFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoCoordinateSystemFX3DToggleButton, YoCoordinateSystemFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoCylinderFX3DToggleButton, YoCylinderFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoEllipsoidFX3DToggleButton, YoEllipsoidFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoPointcloudFX3DToggleButton, YoPointcloudFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoPointFX3DToggleButton, YoPointFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoPolygonExtrudedFX3DToggleButton, YoPolygonExtrudedFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoConvexPolytopeFX3DToggleButton, YoConvexPolytopeFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoPolynomialFX3DToggleButton, YoPolynomialFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoRampFX3DToggleButton, YoRampFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoSTPBoxFX3DToggleButton, YoSTPBoxFX3D.class);
        this.buttonToTypeMap.put((Toggle)this.yoGroupFXToggleButton, YoGroupFX.class);
        this.buttonToTypeMap.put((Toggle)this.yoAddRobotFXToggleButton, YoGhostRobotFX.class);
        this.typeToDefaultNameMap.put(YoLineFX2D.class, "Line 2D");
        this.typeToDefaultNameMap.put(YoPointcloudFX2D.class, "Pointcloud 2D");
        this.typeToDefaultNameMap.put(YoPointFX2D.class, "Point 2D");
        this.typeToDefaultNameMap.put(YoPolygonFX2D.class, "Polygon 2D");
        this.typeToDefaultNameMap.put(YoArrowFX3D.class, "Arrow 3D");
        this.typeToDefaultNameMap.put(YoBoxFX3D.class, "Box 3D");
        this.typeToDefaultNameMap.put(YoCapsuleFX3D.class, "Capsule 3D");
        this.typeToDefaultNameMap.put(YoConeFX3D.class, "Cone 3D");
        this.typeToDefaultNameMap.put(YoCoordinateSystemFX3D.class, "Coordinate System 3D");
        this.typeToDefaultNameMap.put(YoCylinderFX3D.class, "Cylinder 3D");
        this.typeToDefaultNameMap.put(YoEllipsoidFX3D.class, "Ellipsoid 3D");
        this.typeToDefaultNameMap.put(YoPointcloudFX3D.class, "Pointcloud 3D");
        this.typeToDefaultNameMap.put(YoPointFX3D.class, "Point 3D");
        this.typeToDefaultNameMap.put(YoPolygonExtrudedFX3D.class, "Polygon Extruded 3D");
        this.typeToDefaultNameMap.put(YoConvexPolytopeFX3D.class, "Convex Polytope 3D");
        this.typeToDefaultNameMap.put(YoPolynomialFX3D.class, "Polynomial 3D");
        this.typeToDefaultNameMap.put(YoRampFX3D.class, "Ramp 3D");
        this.typeToDefaultNameMap.put(YoSTPBoxFX3D.class, "STP Box 3D");
        this.typeToDefaultNameMap.put(YoGroupFX.class, "Group");
        this.typeToDefaultNameMap.put(YoGhostRobotFX.class, "Ghost Robot");
        this.buttonToTypeMap.keySet().forEach(button -> button.setToggleGroup(this.toggleGroup));
        this.sessionRobotDefinitions.addListener(change -> this.refreshRobotCollisionsToggleButtons());
        this.refreshRobotCollisionsToggleButtons();
        this.sessionTerrainObjectDefinitions.addListener(change -> this.refreshTerrainCollisionsToggleButton());
        this.refreshTerrainCollisionsToggleButton();
        this.sessionRobotDefinitions.addListener(change -> this.refreshRobotMassPropertiesToggleButtons());
        this.refreshRobotMassPropertiesToggleButtons();
        this.toggleGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            Object name;
            Class newItemType;
            if (this.robotCollisionsToggleButtons.contains(newValue)) {
                newItemType = YoGroupFX.class;
                name = ((RobotDefinition)this.sessionRobotDefinitions.get(this.robotCollisionsToggleButtons.indexOf(newValue))).getName() + " collisions";
            } else if (this.terrainCollisionsToggleButton != null && this.terrainCollisionsToggleButton == newValue) {
                newItemType = YoGroupFX.class;
                name = "Terrain collisions";
            } else if (this.robotMassPropertiesToggleButtons.contains(newValue)) {
                newItemType = YoGroupFX.class;
                name = ((RobotDefinition)this.sessionRobotDefinitions.get(this.robotMassPropertiesToggleButtons.indexOf(newValue))).getName() + " mass properties";
            } else {
                newItemType = this.toItemType((Toggle)newValue);
                name = this.typeToDefaultNameMap.get(newItemType);
            }
            name = newItemType == null ? "" : YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(this.parent, (String)name, newItemType);
            this.itemNameTextField.setText((String)name);
            this.itemNameValidityProperty.set(this.isYoGraphicFXItemNameValid((String)name, newItemType));
        });
        this.itemNameTextField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.robotCollisionsToggleButtons.contains((Object)this.toggleGroup.getSelectedToggle())) {
                this.itemNameValidityProperty.set(this.isYoGraphicFXItemNameValid((String)newValue, (Class<? extends YoGraphicFXItem>)YoGroupFX.class));
            } else if (this.terrainCollisionsToggleButton != null && this.terrainCollisionsToggleButton == this.toggleGroup.getSelectedToggle()) {
                this.itemNameValidityProperty.set(this.isYoGraphicFXItemNameValid((String)newValue, (Class<? extends YoGraphicFXItem>)YoGroupFX.class));
            } else if (this.robotMassPropertiesToggleButtons.contains((Object)this.toggleGroup.getSelectedToggle())) {
                this.itemNameValidityProperty.set(this.isYoGraphicFXItemNameValid((String)newValue, (Class<? extends YoGraphicFXItem>)YoGroupFX.class));
            } else {
                this.itemNameValidityProperty.set(this.isYoGraphicFXItemNameValid((String)newValue, this.toItemType(this.toggleGroup.getSelectedToggle())));
            }
        });
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.itemNameValidityProperty, this.itemNameValidImageView);
        this.createItemButton.disableProperty().bind((ObservableValue)this.itemNameValidityProperty.not());
        this.stage.initOwner((Window)toolkit.getMainWindow());
        Scene scene = new Scene((Parent)this.mainPane);
        this.stage.setTitle("YoGraphicFXItem creation");
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.stage);
        this.stage.setScene(scene);
    }

    private void refreshRobotCollisionsToggleButtons() {
        this.miscPane.getChildren().removeAll(this.robotCollisionsToggleButtons);
        this.robotCollisionsToggleButtons.forEach(button -> button.setToggleGroup(null));
        this.cleanupMiscPane();
        this.robotCollisionsToggleButtons.clear();
        this.robotCollisionsToggleButtons.addAll(this.sessionRobotDefinitions.stream().map(this::createRobotCollisionsToggleButton).toList());
        this.addNodesToMiscPane((Collection<? extends Node>)this.robotCollisionsToggleButtons);
        this.robotCollisionsToggleButtons.forEach(button -> button.setToggleGroup(this.toggleGroup));
    }

    private void refreshTerrainCollisionsToggleButton() {
        if (this.sessionTerrainObjectDefinitions.isEmpty()) {
            if (this.terrainCollisionsToggleButton != null) {
                this.terrainCollisionsToggleButton.setToggleGroup(null);
                this.miscPane.getChildren().remove((Object)this.terrainCollisionsToggleButton);
                this.terrainCollisionsToggleButton = null;
                this.cleanupMiscPane();
            }
        } else if (this.terrainCollisionsToggleButton == null) {
            this.terrainCollisionsToggleButton = this.createTerrainCollisionsToggleButton();
            this.addNodeToMiscPane((Node)this.terrainCollisionsToggleButton);
            this.terrainCollisionsToggleButton.setToggleGroup(this.toggleGroup);
        }
    }

    private void refreshRobotMassPropertiesToggleButtons() {
        this.miscPane.getChildren().removeAll(this.robotMassPropertiesToggleButtons);
        this.robotMassPropertiesToggleButtons.forEach(button -> button.setToggleGroup(null));
        this.cleanupMiscPane();
        this.robotMassPropertiesToggleButtons.clear();
        this.robotMassPropertiesToggleButtons.addAll(this.sessionRobotDefinitions.stream().map(this::createRobotMassPropertiesToggleButton).toList());
        this.addNodesToMiscPane((Collection<? extends Node>)this.robotMassPropertiesToggleButtons);
        this.robotMassPropertiesToggleButtons.forEach(button -> button.setToggleGroup(this.toggleGroup));
    }

    private void cleanupMiscPane() {
        ArrayList nodes = new ArrayList(this.miscPane.getChildren());
        this.miscPane.getChildren().clear();
        this.addNodesToMiscPane(nodes);
    }

    private void addNodesToMiscPane(Collection<? extends Node> nodes) {
        int numberOfColumns = this.miscPane.getColumnConstraints().size();
        int row = this.miscPane.getChildren().size() / numberOfColumns;
        int col = this.miscPane.getChildren().size() % numberOfColumns;
        for (Node node : nodes) {
            this.miscPane.add(node, col, row);
            if (++col < numberOfColumns) continue;
            col = 0;
            ++row;
        }
    }

    private void addNodeToMiscPane(Node node) {
        int numberOfColumns = this.miscPane.getColumnConstraints().size();
        int row = this.miscPane.getChildren().size() / numberOfColumns;
        int col = this.miscPane.getChildren().size() % numberOfColumns;
        this.miscPane.add(node, col, row);
    }

    public void setParent(YoGroupFX parent) {
        this.parent = parent;
        this.userValidatedProperty.set(false);
        this.itemNamespaceTextField.setText(parent.getFullname());
        Class<? extends YoGraphicFXItem> itemType = this.toItemType(this.toggleGroup.getSelectedToggle());
        if (itemType != null) {
            String name = this.itemNameTextField.getText();
            if (name.trim().isEmpty()) {
                name = this.typeToDefaultNameMap.get(itemType);
            }
            this.itemNameTextField.setText(YoGraphicFXControllerTools.createAvailableYoGraphicFXItemName(parent, name, itemType));
        }
        this.itemNameValidityProperty.set(this.isYoGraphicFXItemNameValid(this.itemNameTextField.getText(), itemType));
    }

    public void showAndWait() {
        this.stage.showAndWait();
    }

    public YoGraphicFXItem createItem() {
        if (!this.userValidatedProperty.get()) {
            return null;
        }
        if (!this.itemNameValidityProperty.get()) {
            return null;
        }
        if (this.toggleGroup.getSelectedToggle() == null) {
            return null;
        }
        Class<? extends YoGraphicFXItem> itemType = this.toItemType(this.toggleGroup.getSelectedToggle());
        if (itemType == YoGhostRobotFX.class) {
            YoGhostRobotFX yoGhostRobotFX = new YoGhostRobotFX(this.yoManager.getRootRegistryDatabase());
            yoGhostRobotFX.setName(this.itemNameTextField.getText());
            this.parent.addYoGraphicFX3D(yoGhostRobotFX);
            return yoGhostRobotFX;
        }
        if (itemType != null) {
            return YoGraphicFXControllerTools.createYoGraphicFXItemAndRegister(this.worldFrame, this.parent, this.itemNameTextField.getText(), itemType);
        }
        if (this.robotCollisionsToggleButtons.contains((Object)this.toggleGroup.getSelectedToggle())) {
            RobotDefinition robotDefinition = (RobotDefinition)this.sessionRobotDefinitions.get(this.robotCollisionsToggleButtons.indexOf((Object)this.toggleGroup.getSelectedToggle()));
            YoGroupFX robotCollisionShapeDefinitions = YoGraphicTools.convertRobotCollisionShapeDefinitions(this.robotFXManager.getRobotRootBody(robotDefinition.getName()), robotDefinition, this.referenceFrameManager);
            robotCollisionShapeDefinitions.setName(this.itemNameTextField.getText());
            boolean success = this.parent.addChild(robotCollisionShapeDefinitions);
            return success ? robotCollisionShapeDefinitions : null;
        }
        if (this.terrainCollisionsToggleButton != null && this.terrainCollisionsToggleButton == this.toggleGroup.getSelectedToggle()) {
            YoGroupFX terrainCollisionShapeDefinitions = YoGraphicTools.convertTerrainObjectsCollisionShapeDefinitions(this.worldFrame, this.sessionTerrainObjectDefinitions);
            terrainCollisionShapeDefinitions.setName(this.itemNameTextField.getText());
            boolean success = this.parent.addChild(terrainCollisionShapeDefinitions);
            return success ? terrainCollisionShapeDefinitions : null;
        }
        if (this.robotMassPropertiesToggleButtons.contains((Object)this.toggleGroup.getSelectedToggle())) {
            RobotDefinition robotDefinition = (RobotDefinition)this.sessionRobotDefinitions.get(this.robotMassPropertiesToggleButtons.indexOf((Object)this.toggleGroup.getSelectedToggle()));
            YoGroupFX robotMassPropertiesShapeDefinitions = YoGraphicTools.convertRobotMassPropertiesShapeDefinitions(this.robotFXManager.getRobotRootBody(robotDefinition.getName()), robotDefinition, this.referenceFrameManager);
            robotMassPropertiesShapeDefinitions.setName(this.itemNameTextField.getText());
            boolean success = this.parent.addChild(robotMassPropertiesShapeDefinitions);
            return success ? robotMassPropertiesShapeDefinitions : null;
        }
        return null;
    }

    private Class<? extends YoGraphicFXItem> toItemType(Toggle toggle) {
        if (toggle == null) {
            return null;
        }
        return this.buttonToTypeMap.get(toggle);
    }

    private boolean isYoGraphicFXItemNameValid(String itemName, Class<? extends YoGraphicFXItem> itemClass) {
        if (itemName == null || itemName.isEmpty()) {
            return false;
        }
        if (itemClass == null) {
            return false;
        }
        if (YoGroupFX.class.isAssignableFrom(itemClass)) {
            return this.isYoGraphicFXGroupNameValid(itemName);
        }
        if (YoGraphicFX2D.class.isAssignableFrom(itemClass)) {
            return this.isYoGraphicFX2DNameValid(itemName);
        }
        if (YoGraphicFX3D.class.isAssignableFrom(itemClass)) {
            return this.isYoGraphicFX3DNameValid(itemName);
        }
        throw new RuntimeException("Unexpected item type: " + itemClass.getSimpleName());
    }

    private boolean isYoGraphicFXGroupNameValid(String itemName) {
        return !this.parent.containsChild(itemName);
    }

    private boolean isYoGraphicFX2DNameValid(String itemName) {
        return !this.parent.containsYoGraphicFX2D(itemName);
    }

    private boolean isYoGraphicFX3DNameValid(String itemName) {
        return !this.parent.containsYoGraphicFX3D(itemName);
    }

    @FXML
    private void cancelAndDispose(ActionEvent event) {
        this.userValidatedProperty.set(false);
        this.stage.close();
    }

    @FXML
    private void validateItemAndDispose(ActionEvent event) {
        this.userValidatedProperty.set(true);
        this.stage.close();
    }

    private ToggleButton createRobotCollisionsToggleButton(RobotDefinition robotdefinition) {
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_GRAPHIC_ROBOT_COLLISIONS_BUTTON_URL);
        try {
            ToggleButton button = (ToggleButton)loader.load();
            button.setText(StringUtils.capitalize((String)robotdefinition.getName()) + " Collisions");
            return button;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ToggleButton createTerrainCollisionsToggleButton() {
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_GRAPHIC_TERRAIN_COLLISIONS_BUTTON_URL);
        try {
            return (ToggleButton)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ToggleButton createRobotMassPropertiesToggleButton(RobotDefinition robotdefinition) {
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_GRAPHIC_ROBOT_MASS_PROPERTIES_BUTTON_URL);
        try {
            ToggleButton button = (ToggleButton)loader.load();
            button.setText(StringUtils.capitalize((String)robotdefinition.getName()) + " Mass Properties");
            return button;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

