/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.stage.Window;
import javafx.util.Pair;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import us.ihmc.log.LogTools;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoMultiSliderboardWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;

public class YoSliderboardManager
implements Manager {
    private final Property<YoMultiSliderboardWindowController> behringerSliderboard = new SimpleObjectProperty((Object)this, "behringerSliderboard", null);
    private final SessionVisualizerToolkit toolkit;
    private final SessionVisualizerTopics topics;
    private final JavaFXMessager messager;
    private YoSliderboardListDefinition initialConfiguration = null;
    private final TopicListener<File> saveRequestListener = m -> this.handleSaveRequest((File)m);
    private final TopicListener<File> loadRequestListener = m -> this.handleLoadRequest((File)m);
    private final TopicListener<Boolean> clearAllRequestListener = m -> this.handleClearRequest((Boolean)m);
    private final TopicListener<YoSliderboardListDefinition> setMultiRequestListener = m -> this.handleSetRequest((YoSliderboardListDefinition)m);
    private final TopicListener<YoSliderboardDefinition> setSingleRequestListener = m -> this.handleSetRequest((YoSliderboardDefinition)m);
    private final TopicListener<Pair<String, YoSliderboardType>> removeRequestListener = m -> this.handleRemoveRequest((String)m.getKey(), (YoSliderboardType)m.getValue());
    private final TopicListener<ImmutableTriple<String, YoSliderboardType, YoButtonDefinition>> setButtonRequestListener = m -> this.handleSetButtonRequest((String)m.getLeft(), (YoSliderboardType)m.getMiddle(), (YoButtonDefinition)m.getRight());
    private final TopicListener<ImmutableTriple<String, YoSliderboardType, YoKnobDefinition>> setKnobRequestListener = m -> this.handleSetKnobRequest((String)m.getLeft(), (YoSliderboardType)m.getMiddle(), (YoKnobDefinition)m.getRight());
    private final TopicListener<ImmutableTriple<String, YoSliderboardType, YoSliderDefinition>> setSliderRequestListener = m -> this.handleSetSliderRequest((String)m.getLeft(), (YoSliderboardType)m.getMiddle(), (YoSliderDefinition)m.getRight());
    private final TopicListener<ImmutableTriple<String, YoSliderboardType, Integer>> clearButtonRequestListener = m -> this.handleClearButtonRequest((String)m.getLeft(), (YoSliderboardType)m.getMiddle(), (Integer)m.getRight());
    private final TopicListener<ImmutableTriple<String, YoSliderboardType, Integer>> clearKnobRequestListener = m -> this.handleClearKnobRequest((String)m.getLeft(), (YoSliderboardType)m.getMiddle(), (Integer)m.getRight());
    private final TopicListener<ImmutableTriple<String, YoSliderboardType, Integer>> clearSliderRequestListener = m -> this.handleClearSliderRequest((String)m.getLeft(), (YoSliderboardType)m.getMiddle(), (Integer)m.getRight());

    public YoSliderboardManager(SessionVisualizerToolkit toolkit) {
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.toolkit = toolkit;
    }

    public void saveSessionConfiguration(SCSGuiConfiguration configuration) {
        this.handleSaveRequest(configuration.getYoSliderboardConfigurationFile());
    }

    @Override
    public void startSession(Session session) {
        this.initialConfiguration = null;
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardSave(), this.saveRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardLoad(), this.loadRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardClearAll(), this.clearAllRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoMultiSliderboardSet(), this.setMultiRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSet(), this.setSingleRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardRemove(), this.removeRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSetButton(), this.setButtonRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSetKnob(), this.setKnobRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardSetSlider(), this.setSliderRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardClearButton(), this.clearButtonRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardClearKnob(), this.clearKnobRequestListener);
        this.messager.addFXTopicListener(this.topics.getYoSliderboardClearSlider(), this.clearSliderRequestListener);
    }

    @Override
    public void stopSession() {
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardSave(), this.saveRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardLoad(), this.loadRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardClearAll(), this.clearAllRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoMultiSliderboardSet(), this.setMultiRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSet(), this.setSingleRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardRemove(), this.removeRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSetButton(), this.setButtonRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSetKnob(), this.setKnobRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardSetSlider(), this.setSliderRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardClearButton(), this.clearButtonRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardClearKnob(), this.clearKnobRequestListener);
        this.messager.removeFXTopicListener(this.topics.getYoSliderboardClearSlider(), this.clearSliderRequestListener);
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).close();
            this.behringerSliderboard.setValue(null);
        }
    }

    @Override
    public boolean isSessionLoaded() {
        return false;
    }

    private void handleSaveRequest(File file) {
        YoSliderboardListDefinition definitionToSave = this.behringerSliderboard.getValue() != null ? ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).toYoSliderboardListDefinition(true) : this.initialConfiguration;
        if (definitionToSave != null) {
            try {
                XMLTools.saveYoSliderboardListDefinition(new FileOutputStream(file), definitionToSave);
            }
            catch (IOException | JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleLoadRequest(File file) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            YoSliderboardListDefinition definition = XMLTools.loadYoSliderboardListDefinition(new FileInputStream(file));
            this.handleSetRequest(definition);
            if (definition.getWindowConfiguration() != null && !definition.getYoSliderboards().isEmpty() && definition.getWindowConfiguration().isShowing()) {
                this.openSliderboardWindow(null, ((YoSliderboardDefinition)definition.getYoSliderboards().get(0)).getType());
            }
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    private void handleClearRequest(Boolean m) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).clear();
        } else {
            this.initialConfiguration = null;
        }
    }

    private void handleSetRequest(YoSliderboardListDefinition definition) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).setInput(definition);
        } else {
            this.initialConfiguration = new YoSliderboardListDefinition(definition);
        }
    }

    private void handleSetRequest(YoSliderboardDefinition definition) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).setSliderboard(definition);
        } else {
            int index;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((index = this.findSliderboardIndex(definition.getName(), definition.getType())) != -1) {
                ((YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(index)).set(definition);
            } else {
                this.initialConfiguration.getYoSliderboards().add(definition);
            }
        }
    }

    private void handleRemoveRequest(String sliderboardName, YoSliderboardType sliderboardType) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).closeSliderboard(sliderboardName, sliderboardType);
        } else {
            int index;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((index = this.findSliderboardIndex(sliderboardName, sliderboardType)) != -1) {
                this.initialConfiguration.getYoSliderboards().remove(index);
            }
        }
    }

    private void handleSetButtonRequest(String sliderboardName, YoSliderboardType sliderboardType, YoButtonDefinition buttonDefinition) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).setButtonInput(sliderboardName, sliderboardType, buttonDefinition);
        } else {
            YoSliderboardDefinition sliderboard = this.getOrCreateSliderboardDefinition(sliderboardName, sliderboardType);
            sliderboard.getButtons().add(new YoButtonDefinition(buttonDefinition));
        }
    }

    private void handleSetKnobRequest(String sliderboardName, YoSliderboardType sliderboardType, YoKnobDefinition knobDefinition) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).setKnobInput(sliderboardName, sliderboardType, knobDefinition);
        } else {
            YoSliderboardDefinition sliderboard = this.getOrCreateSliderboardDefinition(sliderboardName, sliderboardType);
            sliderboard.getKnobs().add(new YoKnobDefinition(knobDefinition));
        }
    }

    private void handleSetSliderRequest(String sliderboardName, YoSliderboardType sliderboardType, YoSliderDefinition sliderDefinition) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).setSliderInput(sliderboardName, sliderboardType, sliderDefinition);
        } else {
            YoSliderboardDefinition sliderboard = this.getOrCreateSliderboardDefinition(sliderboardName, sliderboardType);
            sliderboard.getSliders().add(new YoSliderDefinition(sliderDefinition));
        }
    }

    private YoSliderboardDefinition getOrCreateSliderboardDefinition(String sliderboardName, YoSliderboardType sliderboardType) {
        YoSliderboardDefinition sliderboard;
        int sliderboardIndex;
        if (this.initialConfiguration == null) {
            this.initialConfiguration = new YoSliderboardListDefinition();
        }
        if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName, sliderboardType)) != -1) {
            sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
        } else {
            sliderboard = new YoSliderboardDefinition(sliderboardName);
            this.initialConfiguration.getYoSliderboards().add(sliderboard);
        }
        return sliderboard;
    }

    private void handleClearButtonRequest(String sliderboardName, YoSliderboardType sliderboardType, int buttonIndex) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).removeButtonInput(sliderboardName, sliderboardType, buttonIndex);
        } else {
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName, sliderboardType)) == -1) {
                return;
            }
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            List buttons = sliderboard.getButtons();
            for (int i = buttons.size() - 1; i >= 0; --i) {
                if (i == buttonIndex && ((YoButtonDefinition)buttons.get(i)).getIndex() == -1) {
                    buttons.remove(i);
                    continue;
                }
                if (((YoButtonDefinition)buttons.get(i)).getIndex() != buttonIndex) continue;
                buttons.remove(i);
            }
        }
    }

    private void handleClearKnobRequest(String sliderboardName, YoSliderboardType sliderboardType, int knobIndex) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).removeKnobInput(sliderboardName, sliderboardType, knobIndex);
        } else {
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName, sliderboardType)) == -1) {
                return;
            }
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            List knobs = sliderboard.getKnobs();
            for (int i = knobs.size() - 1; i >= 0; --i) {
                if (i == knobIndex && ((YoKnobDefinition)knobs.get(i)).getIndex() == -1) {
                    knobs.remove(i);
                    continue;
                }
                if (((YoKnobDefinition)knobs.get(i)).getIndex() != knobIndex) continue;
                knobs.remove(i);
            }
        }
    }

    private void handleClearSliderRequest(String sliderboardName, YoSliderboardType sliderboardType, int sliderIndex) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).removeSliderInput(sliderboardName, sliderboardType, sliderIndex);
        } else {
            int sliderboardIndex;
            if (this.initialConfiguration == null) {
                this.initialConfiguration = new YoSliderboardListDefinition();
            }
            if ((sliderboardIndex = this.findSliderboardIndex(sliderboardName, sliderboardType)) == -1) {
                return;
            }
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)this.initialConfiguration.getYoSliderboards().get(sliderboardIndex);
            List sliders = sliderboard.getSliders();
            for (int i = sliders.size() - 1; i >= 0; --i) {
                if (i == sliderIndex && ((YoSliderDefinition)sliders.get(i)).getIndex() == -1) {
                    sliders.remove(i);
                    continue;
                }
                if (((YoSliderDefinition)sliders.get(i)).getIndex() != sliderIndex) continue;
                sliders.remove(i);
            }
        }
    }

    private int findSliderboardIndex(String sliderboardName, YoSliderboardType type) {
        if (sliderboardName == null) {
            return -1;
        }
        List yoSliderboards = this.initialConfiguration.getYoSliderboards();
        for (int i = 0; i < yoSliderboards.size(); ++i) {
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)yoSliderboards.get(i);
            if (!sliderboardName.equals(sliderboard.getName()) || sliderboard.getType() != type) continue;
            return i;
        }
        return -1;
    }

    public void openSliderboardWindow(Window requestSource, YoSliderboardType type) {
        if (this.behringerSliderboard.getValue() != null) {
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).showWindow();
            ((YoMultiSliderboardWindowController)this.behringerSliderboard.getValue()).ensureTab(type);
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_MULTI_SLIDERBOARD_WINDOW_URL);
            fxmlLoader.load();
            YoMultiSliderboardWindowController controller = (YoMultiSliderboardWindowController)fxmlLoader.getController();
            controller.initialize(this.toolkit);
            if (this.initialConfiguration != null) {
                controller.setInput(this.initialConfiguration);
                if (this.initialConfiguration.getWindowConfiguration() == null) {
                    SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, controller.getWindow());
                }
                this.initialConfiguration = null;
            } else {
                YoSliderboardListDefinition initial = new YoSliderboardListDefinition();
                initial.getYoSliderboards().add(new YoSliderboardDefinition("Default", type));
                controller.setInput(initial);
                SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, controller.getWindow());
            }
            this.behringerSliderboard.setValue((Object)controller);
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

