/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Pair;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.kordamp.ikonli.javafx.FontIcon;
import us.ihmc.log.LogTools;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.TopicListenerBase;
import us.ihmc.scs2.definition.yoChart.YoChartGroupConfigurationDefinition;
import us.ihmc.scs2.definition.yoChart.YoChartGroupConfigurationListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SecondaryWindowControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.ChartTable2D;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartGroupPanelController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu.MainWindowMenuBarController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TabPaneTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;

public class SecondaryWindowController
implements VisualizerController {
    @FXML
    private VBox mainNode;
    @FXML
    private TabPane tabPane;
    @FXML
    private MainWindowMenuBarController menuController;
    @FXML
    private SecondaryWindowControlsController controlsController;
    private final TopicListener<Pair<Window, File>> loadChartGroupConfigurationListener = m -> this.loadChartGroupConfiguration((Window)m.getKey(), (File)m.getValue());
    private final TopicListener<Pair<Window, File>> saveChartGroupConfigurationListener = m -> this.saveChartGroupConfiguration((Window)m.getKey(), (File)m.getValue(), false);
    private final ObservableMap<Tab, YoChartGroupPanelController> chartGroupControllers = FXCollections.observableHashMap();
    private SessionVisualizerWindowToolkit toolkit;
    private boolean isMessagerSetup = false;
    private StringProperty userDefinedChartWindowName = new SimpleStringProperty((Object)this, "userDefinedChartWindowName", null);
    private Stage stage;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.menuController.initialize(toolkit);
        this.controlsController.initialize(toolkit);
        this.stage = toolkit.getWindow();
        Scene scene = new Scene((Parent)this.mainNode, 1024.0, 768.0);
        this.stage.setScene(scene);
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.stage);
        this.stage.setTitle("Chart Window");
        this.stage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (e.isConsumed()) {
                return;
            }
            this.closeAndDispose();
            this.stage.close();
        });
        ChangeListener chartTitleListener = (o, oldValue, newValue) -> this.updateWindowTitle();
        this.tabPane.tabClosingPolicyProperty().setValue((Object)TabPane.TabClosingPolicy.ALL_TABS);
        this.tabPane.tabDragPolicyProperty().setValue((Object)TabPane.TabDragPolicy.REORDER);
        this.tabPane.getTabs().addListener(c -> {
            while (c.next()) {
                YoChartGroupPanelController controller;
                if (c.wasAdded()) {
                    for (Tab tab : c.getAddedSubList()) {
                        controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)tab);
                        if (controller == null) continue;
                        controller.chartGroupNameProperty().addListener(chartTitleListener);
                    }
                }
                if (!c.wasRemoved()) continue;
                for (Tab tab : c.getRemoved()) {
                    controller = (YoChartGroupPanelController)this.chartGroupControllers.remove((Object)tab);
                    if (controller == null) continue;
                    controller.closeAndDispose();
                    controller.chartGroupNameProperty().removeListener(chartTitleListener);
                }
            }
            if (this.tabPane.getTabs().isEmpty()) {
                this.tabPane.getTabs().add((Object)this.newChartGroupTab());
            }
            this.updateWindowTitle();
        });
        this.userDefinedChartWindowName.addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.updateWindowTitle();
            } else {
                this.stage.setTitle("Chart Window: " + newValue);
            }
        });
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            YoChartGroupPanelController controller = (YoChartGroupPanelController)this.chartGroupControllers.get(newValue);
            if (controller != null) {
                controller.start();
            }
            if (oldValue == null) {
                return;
            }
            controller = (YoChartGroupPanelController)this.chartGroupControllers.get(oldValue);
            if (controller != null) {
                controller.stop();
            }
        });
        MenuTools.setupContextMenu(this.tabPane, TabPaneTools.addBeforeMenuItemFactory(this::newChartGroupTab), TabPaneTools.addAfterMenuItemFactory(this::newChartGroupTab), TabPaneTools.removeMenuItemFactory(), TabPaneTools.removeAllMenuItemFactory(), this.exportTabMenuItemFactory(), this.exportAllTabsMenuItemFactory(), this.importTabMenuItemFactory());
        if (this.tabPane.getTabs().isEmpty()) {
            this.tabPane.getTabs().add((Object)this.newChartGroupTab());
        }
        SCS2JavaFXMessager messager = toolkit.getMessager();
        SessionVisualizerTopics topics = toolkit.getTopics();
        messager.addFXTopicListener(topics.getYoChartGroupLoadConfiguration(), this.loadChartGroupConfigurationListener);
        messager.addFXTopicListener(topics.getYoChartGroupSaveConfiguration(), this.saveChartGroupConfigurationListener);
        this.isMessagerSetup = true;
    }

    private void updateWindowTitle() {
        if (this.userDefinedChartWindowName.get() != null) {
            return;
        }
        Object title = "Chart Window";
        List<String> nonEmptyTabNames = this.tabPane.getTabs().stream().filter(tab -> !((YoChartGroupPanelController)this.chartGroupControllers.get(tab)).isEmpty()).map(arg_0 -> this.chartGroupControllers.get(arg_0)).map(controller -> (String)controller.chartGroupNameProperty().get()).toList();
        if (!nonEmptyTabNames.isEmpty()) {
            title = (String)title + " - [%s]".formatted(String.join((CharSequence)", ", nonEmptyTabNames));
        }
        this.stage.setTitle((String)title);
    }

    private Tab newChartGroupTab() {
        YoChartGroupPanelController controller = this.newChartGroup();
        if (controller == null) {
            return null;
        }
        Tab tab = new Tab();
        String defaultText = "Chart Group " + this.tabPane.getTabs().size();
        tab.setText(defaultText);
        tab.setClosable(true);
        tab.setOnCloseRequest(e -> {
            LogTools.info((String)("Closing chart group: " + controller));
            controller.closeAndDispose();
        });
        tab.setContent((Node)controller.getMainPane());
        Label tabHeader = TabPaneTools.editableTabHeader(tab);
        MutableBoolean isAutoUpdating = new MutableBoolean(false);
        controller.chartGroupNameProperty().addListener((o, oldValue, newValue) -> {
            if (isAutoUpdating.isTrue()) {
                return;
            }
            isAutoUpdating.setTrue();
            if (newValue == null || newValue.isEmpty()) {
                tabHeader.setText(defaultText);
            } else {
                tabHeader.setText(newValue);
            }
            isAutoUpdating.setFalse();
        });
        tabHeader.textProperty().addListener((o, oldValue, newValue) -> {
            if (isAutoUpdating.isTrue()) {
                return;
            }
            isAutoUpdating.setTrue();
            if (newValue.isEmpty()) {
                controller.setUserDefinedChartGroupName(null);
                if (controller.chartGroupNameProperty().get() == null) {
                    tabHeader.setText(defaultText);
                } else {
                    tabHeader.setText((String)controller.chartGroupNameProperty().get());
                }
            } else {
                controller.setUserDefinedChartGroupName((String)newValue);
            }
            isAutoUpdating.setFalse();
        });
        this.tabPane.getSelectionModel().select((Object)tab);
        this.chartGroupControllers.put((Object)tab, (Object)controller);
        return tab;
    }

    private YoChartGroupPanelController newChartGroup() {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_GROUP_PANEL_URL);
            loader.load();
            YoChartGroupPanelController controller = (YoChartGroupPanelController)loader.getController();
            controller.initialize(this.toolkit);
            controller.start();
            controller.maxSizeProperty().setValue((Object)new ChartTable2D.ChartTable2DSize(9, 6));
            return controller;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Function<TabPane, MenuItem> exportTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)tabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            YoChartGroupPanelController controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)selectedTab);
            if (controller == null) {
                return null;
            }
            FontIcon exportIcon = new FontIcon();
            exportIcon.getStyleClass().add((Object)"save-icon-view");
            MenuItem menuItem = new MenuItem("Export active tab...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoChartConfigurationSaveFileDialog((Window)this.stage);
                if (result == null) {
                    return;
                }
                controller.saveChartGroupConfiguration((Window)this.stage, result);
            });
            return menuItem;
        };
    }

    private Function<TabPane, MenuItem> exportAllTabsMenuItemFactory() {
        return tabPane -> {
            FontIcon exportIcon = new FontIcon();
            exportIcon.getStyleClass().add((Object)"save-icon-view");
            MenuItem menuItem = new MenuItem("Export all tabs...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoChartConfigurationSaveFileDialog((Window)this.stage);
                if (result == null) {
                    return;
                }
                this.saveChartGroupConfiguration((Window)this.stage, result, false);
            });
            return menuItem;
        };
    }

    private Function<TabPane, MenuItem> importTabMenuItemFactory() {
        return tabPane -> {
            FontIcon importIcon = new FontIcon();
            importIcon.getStyleClass().add((Object)"load-icon-view");
            MenuItem menuItem = new MenuItem("Import tab(s)...", (Node)importIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoChartConfigurationOpenFileDialog((Window)this.stage);
                if (result == null) {
                    return;
                }
                this.loadChartGroupConfiguration(result, (Tab)tabPane.getSelectionModel().getSelectedItem());
            });
            return menuItem;
        };
    }

    private void loadChartGroupConfiguration(Window source, File file) {
        if (source != this.stage) {
            return;
        }
        this.loadChartGroupConfiguration(file, (Tab)this.tabPane.getSelectionModel().getSelectedItem());
    }

    private void loadChartGroupConfiguration(File file, Tab insertionPoint) {
        LogTools.info((String)("Loading file: " + file));
        try {
            int insertionIndex;
            Object loaded = XMLTools.loadYoChartGroupConfigurationUndefined(new FileInputStream(file));
            int n = insertionIndex = insertionPoint == null ? -1 : this.tabPane.getTabs().indexOf((Object)insertionPoint);
            if (loaded instanceof YoChartGroupConfigurationDefinition) {
                YoChartGroupConfigurationDefinition chartGroupDefinition = (YoChartGroupConfigurationDefinition)loaded;
                this.loadDefinition(chartGroupDefinition, insertionIndex);
            } else if (loaded instanceof YoChartGroupConfigurationListDefinition) {
                YoChartGroupConfigurationListDefinition chartGroupListDefinition = (YoChartGroupConfigurationListDefinition)loaded;
                for (YoChartGroupConfigurationDefinition chartGroupDefinition : chartGroupListDefinition.getChartGroupConfigurations()) {
                    if (!this.loadDefinition(chartGroupDefinition, insertionIndex)) {
                        return;
                    }
                    ++insertionIndex;
                }
                if (chartGroupListDefinition.getName() != null) {
                    this.userDefinedChartWindowName.set((Object)chartGroupListDefinition.getName());
                }
            } else {
                LogTools.error((String)("Failed to load file: " + file));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean selectActiveChartGroup(int index) {
        if (index < 0 || index >= this.tabPane.getTabs().size()) {
            return false;
        }
        this.tabPane.getSelectionModel().select(index);
        return true;
    }

    public boolean selectActiveChartGroup(String chartGroupName) {
        for (Tab tab : this.tabPane.getTabs()) {
            YoChartGroupPanelController controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)tab);
            if (controller == null || !((String)controller.chartGroupNameProperty().get()).equals(chartGroupName)) continue;
            this.tabPane.getSelectionModel().select((Object)tab);
            return true;
        }
        return false;
    }

    public boolean createNewChartGroup(String chartGroupName) {
        Tab newTab = this.newChartGroupTab();
        if (newTab == null) {
            return false;
        }
        YoChartGroupPanelController controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)newTab);
        controller.setUserDefinedChartGroupName(chartGroupName);
        this.tabPane.getTabs().add((Object)newTab);
        return true;
    }

    public boolean addVariableToActiveChartGroup(String variableName, int row, int column) {
        Tab selectedTab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        if (selectedTab == null) {
            return false;
        }
        YoChartGroupPanelController controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)selectedTab);
        if (controller == null) {
            return false;
        }
        return controller.addVariableToPlot(variableName, row, column, true);
    }

    public boolean addVariableToChartGroup(String chartGroupName, String variableName, int row, int column, boolean createIfAbsent) {
        YoChartGroupPanelController controller;
        for (Object tab : this.tabPane.getTabs()) {
            controller = (YoChartGroupPanelController)this.chartGroupControllers.get(tab);
            if (controller == null || !Objects.equals(controller.chartGroupNameProperty().get(), chartGroupName)) continue;
            return controller.addVariableToPlot(variableName, row, column, true);
        }
        if (!createIfAbsent) {
            return false;
        }
        YoChartGroupPanelController emptyController = null;
        for (Tab tab : this.tabPane.getTabs()) {
            YoChartGroupPanelController controller2 = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)tab);
            if (controller2 == null || !controller2.isEmpty()) continue;
            emptyController = controller2;
            break;
        }
        if (emptyController != null) {
            emptyController.setUserDefinedChartGroupName(chartGroupName);
            emptyController.addVariableToPlot(variableName, row, column, true);
            return true;
        }
        Tab newTab = this.newChartGroupTab();
        if (newTab == null) {
            return false;
        }
        controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)newTab);
        controller.setUserDefinedChartGroupName(chartGroupName);
        controller.addVariableToPlot(variableName, row, column, true);
        this.tabPane.getTabs().add((Object)newTab);
        return true;
    }

    public boolean loadDefinition(YoChartGroupConfigurationDefinition chartGroupDefinition, int insertionIndex) {
        Tab insertionTab;
        YoChartGroupPanelController controller;
        if (insertionIndex == -1) {
            Tab newTab = this.newChartGroupTab();
            if (newTab == null) {
                return false;
            }
            YoChartGroupPanelController controller2 = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)newTab);
            controller2.setChartGroupConfiguration(chartGroupDefinition);
            this.tabPane.getTabs().add((Object)newTab);
            return true;
        }
        if (insertionIndex < this.tabPane.getTabs().size() && (controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)(insertionTab = (Tab)this.tabPane.getTabs().get(insertionIndex)))).isEmpty()) {
            controller.setChartGroupConfiguration(chartGroupDefinition);
            return true;
        }
        Tab newTab = this.newChartGroupTab();
        if (newTab == null) {
            return false;
        }
        YoChartGroupPanelController newController = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)newTab);
        newController.setChartGroupConfiguration(chartGroupDefinition);
        this.tabPane.getTabs().add(insertionIndex, (Object)newTab);
        return true;
    }

    private void saveChartGroupConfiguration(Window source, File file, boolean isConfigurationFile) {
        if (source != null && source != this.stage) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Save must only be used from the FX Application Thread");
        }
        LogTools.info((String)("Saving file: " + file));
        try {
            YoChartGroupConfigurationListDefinition definition = this.toYoChartGroupConfigurationListDefinition();
            if (definition.getName() == null && !isConfigurationFile) {
                definition.setName(file.getName().replace(".scs2.chart", ""));
            }
            XMLTools.saveYoChartGroupConfigurationListDefinition(new FileOutputStream(file), definition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private YoChartGroupConfigurationListDefinition toYoChartGroupConfigurationListDefinition() {
        YoChartGroupConfigurationListDefinition configurationList = new YoChartGroupConfigurationListDefinition();
        for (Tab tab : this.tabPane.getTabs()) {
            YoChartGroupPanelController controller = (YoChartGroupPanelController)this.chartGroupControllers.get((Object)tab);
            if (controller == null) continue;
            configurationList.addChartGroupConfiguration(controller.toYoChartGroupConfigurationDefinition());
        }
        return configurationList;
    }

    public void saveSessionConfiguration(SCSGuiConfiguration configuration) {
        configuration.addSecondaryWindowConfiguration(SecondaryWindowManager.toWindowConfigurationDefinition(this.stage));
        this.saveChartGroupConfiguration((Window)this.stage, configuration.addSecondaryYoChartGroupConfigurationFile(), true);
    }

    public void start() {
        this.toolkit.start();
    }

    public void closeAndDispose() {
        this.tabPane.getTabs().clear();
        this.stage.close();
        SCS2JavaFXMessager messager = this.toolkit.getMessager();
        SessionVisualizerTopics topics = this.toolkit.getTopics();
        this.toolkit.getBackgroundExecutorManager().executeInBackground(() -> {
            if (!this.isMessagerSetup) {
                return;
            }
            this.isMessagerSetup = false;
            messager.removeFXTopicListener((MessagerAPIFactory.Topic)topics.getYoChartGroupLoadConfiguration(), (TopicListenerBase)this.loadChartGroupConfigurationListener);
            messager.removeFXTopicListener((MessagerAPIFactory.Topic)topics.getYoChartGroupSaveConfiguration(), (TopicListenerBase)this.saveChartGroupConfigurationListener);
        });
        this.toolkit.stop();
    }
}

