/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import javax.xml.bind.JAXBException;
import org.kordamp.ikonli.javafx.FontIcon;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoSliderboardWindowControllerInterface;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000SliderboardWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TabPaneTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.XTouchCompactSliderboardController;

public class YoMultiSliderboardWindowController {
    public static final String DEFAULT_SLIDERBOARD_NAME = "Default";
    public static final YoSliderboardType DEFAULT_SLIDERBOARD_TYPE = YoSliderboardType.BCF2000;
    @FXML
    private TabPane sliderboardTabPane;
    @FXML
    private VBox sliderboardRoot;
    @FXML
    private MenuBar sliderboardMenu;
    private final Map<Tab, YoSliderboardWindowControllerInterface> tabToControllerMap = new HashMap<Tab, YoSliderboardWindowControllerInterface>();
    private SessionVisualizerToolkit toolkit;
    private Stage window;
    private Window owner;
    private YoSliderboardType initialType = YoSliderboardType.BCF2000;
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.owner = toolkit.getMainWindow();
        this.window = new Stage();
        MenuTools.setupContextMenu(this.sliderboardTabPane, TabPaneTools.addBeforeMenuItemFactory(this::newBFC2000SliderboardTab, "Add BFC2000 tab before"), TabPaneTools.addAfterMenuItemFactory(this::newBFC2000SliderboardTab, "Add BFC2000 tab after"), TabPaneTools.addBeforeMenuItemFactory(this::newXtouchCompactTab, "Add XTouch tab before"), TabPaneTools.addAfterMenuItemFactory(this::newXtouchCompactTab, "Add Xtouch tab after"), TabPaneTools.removeMenuItemFactory(), TabPaneTools.removeAllMenuItemFactory(false), this.exportTabMenuItemFactory(), this.exportAllTabMenuItemFactory(), this.importTabMenuItemFactory());
        Menu fileMenu = new Menu("Import/Export");
        fileMenu.getItems().add((Object)this.importTabMenuItem(() -> (Tab)this.sliderboardTabPane.getSelectionModel().getSelectedItem()));
        fileMenu.getItems().add((Object)this.exportTabMenuItem(() -> (Tab)this.sliderboardTabPane.getSelectionModel().getSelectedItem()));
        fileMenu.getItems().add((Object)this.exportAllTabMenuItemFactory().apply(this.sliderboardTabPane));
        this.sliderboardMenu.getMenus().add((Object)fileMenu);
        Menu sliderboardAddRemoveMenu = new Menu("Sliderboards");
        sliderboardAddRemoveMenu.getItems().add((Object)TabPaneTools.addLastMenuItem(this.sliderboardTabPane, this::newBFC2000SliderboardTab, "Add BFC2000 sliderboard"));
        sliderboardAddRemoveMenu.getItems().add((Object)TabPaneTools.addLastMenuItem(this.sliderboardTabPane, this::newXtouchCompactTab, "Add XTouch Compact sliderboard"));
        sliderboardAddRemoveMenu.getItems().add((Object)TabPaneTools.removeSelectedMenuItem("Remove current sliderboard", this.sliderboardTabPane));
        sliderboardAddRemoveMenu.getItems().add((Object)TabPaneTools.removeAllMenuItem("Remove all sliderboards", false, this.sliderboardTabPane));
        this.sliderboardMenu.getMenus().add((Object)sliderboardAddRemoveMenu);
        ListChangeListener preserveOneTabListener = change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (Tab removedTab : change.getRemoved()) {
                    YoSliderboardWindowControllerInterface removed = this.tabToControllerMap.remove(removedTab);
                    if (removed != null) {
                        this.initialType = removed.getType();
                    }
                    if (!this.tabToControllerMap.isEmpty()) continue;
                    this.newInitialTab();
                }
            }
        };
        this.sliderboardTabPane.getTabs().addListener(preserveOneTabListener);
        this.cleanupTasks.add(() -> this.sliderboardTabPane.getTabs().removeListener(preserveOneTabListener));
        ChangeListener controllerScheduler = (o, oldValue, newValue) -> {
            if (oldValue != null) {
                this.tabToControllerMap.get(oldValue).stop();
            }
            if (newValue != null) {
                this.tabToControllerMap.get(newValue).start();
            }
            this.window.sizeToScene();
        };
        this.sliderboardTabPane.getSelectionModel().selectedItemProperty().addListener(controllerScheduler);
        this.cleanupTasks.add(() -> this.sliderboardTabPane.getSelectionModel().selectedItemProperty().removeListener(controllerScheduler));
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.window.close();
            }
        });
        this.window.addEventHandler(WindowEvent.WINDOW_HIDING, e -> {
            LogTools.info((String)"Stopping sliderboard binding.");
            this.tabToControllerMap.get(this.sliderboardTabPane.getSelectionModel().getSelectedItem()).stop();
        });
        this.window.addEventHandler(WindowEvent.WINDOW_SHOWING, e -> {
            LogTools.info((String)"Starting sliderboard binding.");
            this.tabToControllerMap.get(this.sliderboardTabPane.getSelectionModel().getSelectedItem()).start();
        });
        this.window.setTitle("YoSliderboard controller");
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.window);
        this.window.setScene(new Scene((Parent)this.sliderboardRoot));
    }

    public void setInput(YoSliderboardListDefinition input) {
        if (input.getYoSliderboards() == null || input.getYoSliderboards().isEmpty()) {
            return;
        }
        ObservableList tabs = this.sliderboardTabPane.getTabs();
        tabs.clear();
        List sliderboards = input.getYoSliderboards();
        for (int i = 0; i < sliderboards.size(); ++i) {
            YoSliderboardDefinition sliderboard = (YoSliderboardDefinition)sliderboards.get(i);
            this.setSliderboard(sliderboard);
        }
        if (input.getWindowConfiguration() != null) {
            SCSGuiConfiguration.loadWindowConfigurationDefinition(input.getWindowConfiguration(), this.window);
        }
    }

    public void setSliderboard(YoSliderboardDefinition sliderboardDefinition) {
        Tab tab = this.findTabByNameAndType(sliderboardDefinition.getName(), sliderboardDefinition.getType());
        if (tab == null) {
            tab = this.newSliderboardTab(sliderboardDefinition.getType());
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setInput(sliderboardDefinition);
    }

    public void closeSliderboard(String name, YoSliderboardType type) {
        Tab tabToRemove = this.findTabByNameAndType(name, type);
        if (tabToRemove != null) {
            this.sliderboardTabPane.getTabs().remove((Object)tabToRemove);
        }
    }

    public void setButtonInput(String sliderboardName, YoSliderboardType sliderboardType, YoButtonDefinition buttonDefinition) {
        Tab tab = this.findTabByNameAndType(sliderboardName, sliderboardType);
        if (tab == null) {
            tab = this.newSliderboardTab(sliderboardType);
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setButtonInput(buttonDefinition);
    }

    public void removeButtonInput(String sliderboardName, YoSliderboardType sliderboardType, int buttonIndex) {
        Tab tab = this.findTabByNameAndType(sliderboardName, sliderboardType);
        if (tab == null) {
            return;
        }
        this.tabToControllerMap.get(tab).removeButtonInput(buttonIndex);
    }

    public void setKnobInput(String sliderboardName, YoSliderboardType sliderboardType, YoKnobDefinition knobDefinition) {
        Tab tab = this.findTabByNameAndType(sliderboardName, sliderboardType);
        if (tab == null) {
            tab = this.newSliderboardTab(sliderboardType);
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setKnobInput(knobDefinition);
    }

    public void removeKnobInput(String sliderboardName, YoSliderboardType sliderboardType, int knobIndex) {
        Tab tab = this.findTabByNameAndType(sliderboardName, sliderboardType);
        if (tab == null) {
            return;
        }
        this.tabToControllerMap.get(tab).removeKnobInput(knobIndex);
    }

    public void setSliderInput(String sliderboardName, YoSliderboardType sliderboardType, YoSliderDefinition sliderDefinition) {
        Tab tab = this.findTabByNameAndType(sliderboardName, sliderboardType);
        if (tab == null) {
            tab = this.newSliderboardTab(sliderboardType);
            this.sliderboardTabPane.getTabs().add((Object)tab);
        }
        this.tabToControllerMap.get(tab).setSliderInput(sliderDefinition);
    }

    public void removeSliderInput(String sliderboardName, YoSliderboardType sliderboardType, int sliderIndex) {
        Tab tab = this.findTabByNameAndType(sliderboardName, sliderboardType);
        if (tab == null) {
            return;
        }
        this.tabToControllerMap.get(tab).removeSliderInput(sliderIndex);
    }

    private Tab findTabByNameAndType(String name, YoSliderboardType type) {
        if (name == null) {
            return null;
        }
        for (Tab tab : this.sliderboardTabPane.getTabs()) {
            YoSliderboardWindowControllerInterface controller = this.tabToControllerMap.get(tab);
            if (!name.equals(controller.nameProperty().get()) || controller.getType() != type) continue;
            return tab;
        }
        return null;
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public void clear() {
        for (Tab tab : this.sliderboardTabPane.getTabs()) {
            YoSliderboardWindowControllerInterface controller = this.tabToControllerMap.get(tab);
            controller.close();
        }
        this.sliderboardTabPane.getTabs().clear();
        this.tabToControllerMap.clear();
        this.newInitialTab();
    }

    private void newInitialTab() {
        Tab tab = this.newSliderboardTab(this.initialType);
        this.sliderboardTabPane.getTabs().add((Object)tab);
        this.sliderboardTabPane.getSelectionModel().select(0);
    }

    public void close() {
        this.cleanupTasks.forEach(Runnable::run);
        this.cleanupTasks.clear();
        this.clear();
        this.window.close();
        BCF2000SliderboardController.closeMidiDevices();
        XTouchCompactSliderboardController.closeMidiDevices();
    }

    public Stage getWindow() {
        return this.window;
    }

    private Function<TabPane, MenuItem> exportTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.sliderboardTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            return this.exportTabMenuItem(() -> selectedTab);
        };
    }

    private MenuItem exportTabMenuItem(Supplier<Tab> selectedTab) {
        FontIcon exportIcon = new FontIcon();
        exportIcon.getStyleClass().add((Object)"save-icon-view");
        MenuItem menuItem = new MenuItem("Export active tab...", (Node)exportIcon);
        menuItem.setOnAction(e -> {
            if (selectedTab == null) {
                return;
            }
            File result = SessionVisualizerIOTools.yoSliderboardConfigurationSaveFileDialog(this.owner);
            if (result != null) {
                this.tabToControllerMap.get(selectedTab.get()).save(result);
            }
        });
        return menuItem;
    }

    private Function<TabPane, MenuItem> exportAllTabMenuItemFactory() {
        return tabPane -> {
            FontIcon exportIcon = new FontIcon();
            exportIcon.getStyleClass().add((Object)"save-icon-view");
            MenuItem menuItem = new MenuItem("Export all tabs...", (Node)exportIcon);
            menuItem.setOnAction(e -> {
                File result = SessionVisualizerIOTools.yoSliderboardConfigurationSaveFileDialog(this.owner);
                if (result != null) {
                    this.exportAllTabs(result);
                }
            });
            return menuItem;
        };
    }

    private Function<TabPane, MenuItem> importTabMenuItemFactory() {
        return tabPane -> {
            Tab selectedTab = (Tab)this.sliderboardTabPane.getSelectionModel().getSelectedItem();
            if (selectedTab == null) {
                return null;
            }
            return this.importTabMenuItem(() -> selectedTab);
        };
    }

    private MenuItem importTabMenuItem(Supplier<Tab> selectedTab) {
        FontIcon exportIcon = new FontIcon();
        exportIcon.getStyleClass().add((Object)"load-icon-view");
        MenuItem menuItem = new MenuItem("Import tab(s)...", (Node)exportIcon);
        menuItem.setOnAction(e -> {
            if (selectedTab.get() == null) {
                return;
            }
            File result = SessionVisualizerIOTools.yoSliderboardConfigurationOpenFileDialog(this.owner);
            if (result != null) {
                this.importTabsAt(result, (Tab)selectedTab.get());
            }
        });
        return menuItem;
    }

    private Tab newSliderboardTab(YoSliderboardType type) {
        if (type == null) {
            throw new RuntimeException("Cannot load configuration: Invalid sliderboard type");
        }
        switch (type) {
            case BCF2000: {
                return this.newBFC2000SliderboardTab();
            }
            case XTOUCHCOMPACT: {
                return this.newXtouchCompactTab();
            }
        }
        throw new RuntimeException("Invalid sliderboard type: " + type);
    }

    private Tab newBFC2000SliderboardTab() {
        try {
            Tab tab = new Tab("Sliderboard" + (this.sliderboardTabPane.getTabs().size() - 1));
            Label tabHeader = TabPaneTools.editableTabHeader(tab);
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_SLIDERBOARD_BCF2000_WINDOW_URL);
            Node node = (Node)loader.load();
            tab.setContent(node);
            YoBCF2000SliderboardWindowController controller = (YoBCF2000SliderboardWindowController)loader.getController();
            controller.nameProperty().bindBidirectional((Property)tabHeader.textProperty());
            controller.initialize((Window)this.window, this.toolkit);
            this.tabToControllerMap.put(tab, controller);
            return tab;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Tab newXtouchCompactTab() {
        try {
            Tab tab = new Tab("XTouch Compact" + (this.sliderboardTabPane.getTabs().size() - 1));
            Label tabHeader = TabPaneTools.editableTabHeader(tab);
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.YO_SLIDERBOARD_XTOUCHCOMPACT_WINDOW_URL);
            Node node = (Node)loader.load();
            tab.setContent(node);
            YoSliderboardWindowControllerInterface controller = (YoSliderboardWindowControllerInterface)loader.getController();
            controller.nameProperty().bindBidirectional((Property)tabHeader.textProperty());
            controller.initialize((Window)this.window, this.toolkit);
            this.tabToControllerMap.put(tab, controller);
            return tab;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void exportAllTabs(File file) {
        LogTools.info((String)("Saving to file: " + file));
        try {
            XMLTools.saveYoSliderboardListDefinition(new FileOutputStream(file), this.toYoSliderboardListDefinition(false));
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void importTabsAt(File file, Tab insertionPoint) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            YoSliderboardListDefinition definition = XMLTools.loadYoSliderboardListDefinition(new FileInputStream(file));
            List yoEntryLists = definition.getYoSliderboards();
            if (yoEntryLists == null || yoEntryLists.isEmpty()) {
                return;
            }
            int startIndex = 0;
            ObservableList tabs = this.sliderboardTabPane.getTabs();
            int insertionIndex = tabs.indexOf((Object)insertionPoint);
            for (int i = startIndex; i < yoEntryLists.size(); ++i) {
                Tab newEmptyTab = this.newSliderboardTab(((YoSliderboardDefinition)yoEntryLists.get(i)).getType());
                this.tabToControllerMap.get(newEmptyTab).setInput((YoSliderboardDefinition)yoEntryLists.get(i));
                tabs.add(insertionIndex, (Object)newEmptyTab);
                this.sliderboardTabPane.getSelectionModel().select(insertionIndex);
                ++insertionIndex;
            }
            if (this.isTabEmpty(insertionPoint)) {
                this.sliderboardTabPane.getTabs().remove((Object)insertionPoint);
            }
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    private boolean isTabEmpty(Tab query) {
        return this.tabToControllerMap.get(query).isEmpty();
    }

    public YoSliderboardListDefinition toYoSliderboardListDefinition(boolean exportWindowConfiguration) {
        YoSliderboardListDefinition definition = new YoSliderboardListDefinition();
        definition.setYoSliderboards(new ArrayList());
        for (Tab tab : this.sliderboardTabPane.getTabs()) {
            definition.getYoSliderboards().add(this.tabToControllerMap.get(tab).toYoSliderboardDefinition());
        }
        if (exportWindowConfiguration) {
            definition.setWindowConfiguration(SCSGuiConfiguration.toWindowConfigurationDefinition(this.window));
        }
        return definition;
    }

    public void ensureTab(YoSliderboardType type) {
        for (Map.Entry<Tab, YoSliderboardWindowControllerInterface> controller : this.tabToControllerMap.entrySet()) {
            if (controller.getValue().getType() != type) continue;
            return;
        }
        Tab tab = this.newSliderboardTab(type);
        int index = this.sliderboardTabPane.getTabs().size();
        this.sliderboardTabPane.getTabs().add((Object)tab);
        this.sliderboardTabPane.getSelectionModel().select(index);
    }
}

