/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Sphere;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXExtensions.raycast.CustomPickRayTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.PerspectiveCameraController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MainViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SingleViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class SecondaryViewport3DManager
implements SingleViewport3DManager {
    private final Pane container;
    private final Group rootNode3D;
    private WritableImage image;
    private final ImageView cameraView;
    private final PerspectiveCamera camera;
    private final PerspectiveCameraController cameraController;
    private final SnapshotParameters snapshotParameters = new SnapshotParameters();
    private final ObservedAnimationTimer animationTimer = new ObservedAnimationTimer(this.getClass().getSimpleName() + " - Updater"){

        @Override
        public void handleImpl(long now) {
            SecondaryViewport3DManager.this.update(now);
        }
    };

    public SecondaryViewport3DManager(Group mainView3DRoot, YoManager yoManager, YoCompositeSearchManager yoCompositeSearchManager, ReferenceFrameManager referenceFrameManager) {
        this.rootNode3D = mainView3DRoot;
        this.cameraView = new ImageView();
        this.cameraView.setPreserveRatio(true);
        this.cameraView.setOnMousePressed(event -> this.cameraView.requestFocus());
        this.container = new Pane(new Node[]{this.cameraView});
        this.camera = new PerspectiveCamera(true);
        this.camera.setNearClip(0.05);
        this.camera.setFarClip(200000.0);
        this.cameraController = new PerspectiveCameraController(this.widthProperty(), this.heightProperty(), this.camera, (Vector3DReadOnly)Axis3D.Z, (Vector3DReadOnly)Axis3D.X);
        this.cameraController.enableShiftClickFocusTranslation(e -> CustomPickRayTools.pick((double)e.getX(), (double)e.getY(), (double)this.image.getWidth(), (double)this.image.getHeight(), (PerspectiveCamera)this.camera, (Node)this.rootNode3D));
        this.cameraController.start();
        this.cameraView.addEventHandler(Event.ANY, (EventHandler)this.cameraController);
        Sphere focusPointViz = this.cameraController.getFocalPointViz();
        if (focusPointViz != null) {
            this.rootNode3D.getChildren().add((Object)focusPointViz);
            focusPointViz.visibleProperty().bind((ObservableValue)this.cameraView.focusedProperty());
        }
        MainViewport3DManager.setupContextMenu(this.cameraController, yoCompositeSearchManager, yoManager, referenceFrameManager, (Node)this.cameraView);
        this.snapshotParameters.setCamera((Camera)this.camera);
        this.snapshotParameters.setDepthBuffer(true);
        this.snapshotParameters.setFill((Paint)Color.GRAY);
        this.animationTimer.start();
    }

    private void update(long now) {
        int height = (int)this.heightProperty().get();
        int width = (int)this.widthProperty().get();
        if (this.image == null || (double)height != this.image.getHeight() || (double)width != this.image.getWidth()) {
            this.snapshotParameters.setViewport(new Rectangle2D(0.0, 0.0, (double)width, (double)height));
            this.image = new WritableImage(width, height);
            this.cameraView.setImage((Image)this.image);
        }
        this.rootNode3D.snapshot(this.snapshotParameters, this.image);
    }

    @Override
    public void startSession(Session session) {
    }

    @Override
    public void stopSession() {
        this.cameraController.cameraPositionCoordinatesToTrackProperty().setValue(null);
        this.cameraController.cameraOrbitalCoordinatesToTrackProperty().setValue(null);
        this.cameraController.cameraLevelOrbitalCoordinatesToTrackProperty().setValue(null);
        this.cameraController.getFocalPointHandler().coordinatesToTrackProperty().set(null);
        this.cameraController.getFocalPointHandler().nodeToTrackProperty().set(null);
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    @Override
    public Pane getPane() {
        return this.container;
    }

    @Override
    public PerspectiveCamera getCamera() {
        return this.camera;
    }

    @Override
    public PerspectiveCameraController getCameraController() {
        return this.cameraController;
    }

    @Override
    public void dispose() {
        this.animationTimer.stop();
        this.cameraController.stop();
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.container.widthProperty();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.container.heightProperty();
    }
}

