/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionPropertiesHelper;
import us.ihmc.scs2.sessionVisualizer.jfx.Scene3DBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.Skybox;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.NewTerrainVisualRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class EnvironmentManager
implements Manager {
    public static final Skybox.SkyboxTheme SKYBOX_THEME = (Skybox.SkyboxTheme)SessionPropertiesHelper.loadEnumPropertyOrEnvironment((String)"scs2.session.gui.skybox.theme", (String)"SCS2_SKYBOX_THEME", Skybox.SkyboxTheme.class, (Enum)Skybox.SkyboxTheme.CLOUDY_CROWN_MIDDAY);
    public static final String SKYBOX_CUSTOM_PATH = SessionPropertiesHelper.loadStringPropertyOrEnvironment((String)"scs2.session.gui.skybox.custompath", (String)"SCS2_SKYBOX_CUSTOM_PATH", null);
    private static final int LARGE_TRIANGLE_MESH_THRESHOLD = 1000000;
    private final Group rootNode = new Group();
    private final Group terrainObjectGraphics = new Group();
    private Group staticVisualsRoot;
    private Map<VisualDefinition, Node> staticVisualDefinitionToNodeMap;
    private Skybox skybox;
    private final BackgroundExecutorManager backgroundExecutorManager;

    public EnvironmentManager(JavaFXMessager messager, SessionVisualizerTopics topics, BackgroundExecutorManager backgroundExecutorManager) {
        this.backgroundExecutorManager = backgroundExecutorManager;
        this.rootNode.getChildren().add((Object)this.terrainObjectGraphics);
        messager.addTopicListener(topics.getTerrainVisualRequest(), this::handleTerrainVisualRequest);
    }

    private void handleTerrainVisualRequest(NewTerrainVisualRequest request) {
        if (request.getRequestedVisible() != null) {
            this.terrainObjectGraphics.setVisible(request.getRequestedVisible().booleanValue());
        }
        if (request.getRequestedDrawMode() != null) {
            this.setTerrainDrawMode(request.getRequestedDrawMode());
        }
    }

    public void addWorldCoordinateSystem(double size) {
        this.backgroundExecutorManager.executeInBackground(() -> {
            Node node = Scene3DBuilder.coordinateSystem(size);
            JavaFXMissingTools.runLater(this.getClass(), () -> this.rootNode.getChildren().add((Object)node));
        });
    }

    public void addSkybox(Camera mainCamera) {
        if (this.skybox != null) {
            return;
        }
        this.skybox = new Skybox();
        switch (SKYBOX_THEME) {
            case CLOUDY_CROWN_MIDDAY: {
                this.skybox.setupCloudyCrown();
                break;
            }
            case SCS1: {
                this.skybox.setupSCS1Skybox();
                break;
            }
            case CUSTOM: {
                if (SKYBOX_CUSTOM_PATH == null) {
                    LogTools.warn((String)"Could not load custom skybox, needs to set the path.");
                    this.skybox.setupCloudyCrown();
                    break;
                }
                if (this.skybox.loadSkyboxFlexible(new File(SKYBOX_CUSTOM_PATH))) break;
                this.skybox.setupCloudyCrown();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + SKYBOX_THEME);
            }
        }
        this.skybox.setupCamera(mainCamera);
        this.backgroundExecutorManager.executeInBackground(() -> JavaFXMissingTools.runLater(this.getClass(), () -> this.rootNode.getChildren().add((Object)this.skybox)));
    }

    public void addStaticVisual(VisualDefinition visualDefinition) {
        Mesh mesh;
        Node nodeToAdd;
        if (this.staticVisualDefinitionToNodeMap == null) {
            this.staticVisualDefinitionToNodeMap = new HashMap<VisualDefinition, Node>();
            if (this.staticVisualDefinitionToNodeMap.containsKey(visualDefinition)) {
                return;
            }
        }
        if ((nodeToAdd = JavaFXVisualTools.toNode(visualDefinition, null)) instanceof MeshView && (mesh = ((MeshView)nodeToAdd).getMesh()) instanceof TriangleMesh && ((TriangleMesh)mesh).getPoints().size() > 1000000) {
            nodeToAdd.setMouseTransparent(true);
        }
        this.staticVisualDefinitionToNodeMap.put(visualDefinition, nodeToAdd);
        if (this.staticVisualsRoot == null) {
            this.staticVisualsRoot = new Group();
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                this.staticVisualsRoot.getChildren().add((Object)nodeToAdd);
                this.rootNode.getChildren().add((Object)this.staticVisualsRoot);
            });
        } else {
            JavaFXMissingTools.runLater(this.getClass(), () -> this.staticVisualsRoot.getChildren().add((Object)nodeToAdd));
        }
    }

    public void removeStaticVisual(VisualDefinition visualDefinition) {
        if (this.staticVisualDefinitionToNodeMap == null) {
            return;
        }
        if (this.staticVisualsRoot == null) {
            return;
        }
        Node nodeToRemove = this.staticVisualDefinitionToNodeMap.remove(visualDefinition);
        if (nodeToRemove == null) {
            return;
        }
        JavaFXMissingTools.runLater(this.getClass(), () -> this.staticVisualsRoot.getChildren().remove((Object)nodeToRemove));
    }

    public void setTerrainDrawMode(DrawMode drawMode) {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> JavaFXMissingTools.setDrawModeRecursive((Node)this.terrainObjectGraphics, drawMode));
    }

    @Override
    public void startSession(Session session) {
        List terrainObjectDefinitions = session.getTerrainObjectDefinitions();
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            for (TerrainObjectDefinition definition : terrainObjectDefinitions) {
                Node nodes = JavaFXVisualTools.collectNodes(definition.getVisualDefinitions(), definition.getResourceClassLoader());
                if (nodes == null) continue;
                this.terrainObjectGraphics.getChildren().add((Object)nodes);
            }
        });
    }

    @Override
    public void stopSession() {
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.terrainObjectGraphics.getChildren().clear());
    }

    @Override
    public boolean isSessionLoaded() {
        return true;
    }

    public Group getRootNode() {
        return this.rootNode;
    }

    public void dispose() {
        if (this.skybox != null) {
            this.skybox.dispose();
            this.skybox = null;
        }
        this.rootNode.getChildren().clear();
        this.terrainObjectGraphics.getChildren().clear();
        if (this.staticVisualsRoot != null) {
            this.staticVisualsRoot.getChildren().clear();
            this.staticVisualsRoot = null;
        }
    }
}

