/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Pair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.camera.YoLevelOrbitalCoordinateDefinition;
import us.ihmc.scs2.definition.camera.YoOrbitalCoordinateDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoEntry.YoEntryListDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionDataFilterParameters;
import us.ihmc.scs2.session.SessionPropertiesHelper;
import us.ihmc.scs2.sessionVisualizer.jfx.Camera3DRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.MainWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.Scene3DBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionChangeListener;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerArgsHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerControls;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MultiSessionManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoBooleanProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoEnumAsStringProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoIntegerProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoLongProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXApplicationCreator;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class SessionVisualizer {
    private static final boolean SHOW_WORLD_FRAME = SessionPropertiesHelper.loadBooleanPropertyOrEnvironment((String)"scs2.session.gui.worldframe.show", (String)"SCS2_GUI_WORLDFRAME_SHOW", (boolean)true);
    public static final String NO_ACTIVE_SESSION_TITLE = "No Active Session";
    private final boolean shutdownSessionOnClose;
    private final SessionVisualizerToolkit toolkit;
    private final MultiSessionManager multiSessionManager;
    protected final MainWindowController mainWindowController;
    private final SCS2JavaFXMessager messager;
    private final SessionVisualizerTopics topics;
    private final SessionVisualizerControlsImpl sessionVisualizerControls = this.createControls();
    private final List<Runnable> stopListeners = new ArrayList<Runnable>();
    private final Stage primaryStage;
    private boolean hasTerminated = false;

    public SessionVisualizer(Stage primaryStage, boolean shutdownSessionOnClose, Session initialSession) throws Exception {
        this.primaryStage = primaryStage;
        this.shutdownSessionOnClose = shutdownSessionOnClose;
        primaryStage.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, this::stop);
        SessionVisualizerIOTools.addSCSIconToWindow((Window)primaryStage);
        primaryStage.setTitle(NO_ACTIVE_SESSION_TITLE);
        Scene3DBuilder scene3DBuilder = new Scene3DBuilder();
        scene3DBuilder.addDefaultLighting();
        this.toolkit = this.createToolkit(primaryStage, scene3DBuilder);
        this.messager = this.toolkit.getMessager();
        this.topics = this.toolkit.getTopics();
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.MAIN_WINDOW_URL);
        Parent mainPane = (Parent)loader.load();
        this.mainWindowController = (MainWindowController)loader.getController();
        this.mainWindowController.initialize(new SessionVisualizerWindowToolkit(primaryStage, this.toolkit));
        if (SHOW_WORLD_FRAME) {
            this.toolkit.getEnvironmentManager().addWorldCoordinateSystem(0.3);
        }
        this.messager.addFXTopicListener(this.topics.getSessionVisualizerCloseRequest(), m -> this.stop());
        Group clonedLightGroup = new Group();
        Scene3DBuilder.setupLigthCloneList((ObservableList<? super LightBase>)clonedLightGroup.getChildren(), scene3DBuilder.getAllLights());
        StackPane mainPaneWithLights = new StackPane(new Node[]{mainPane});
        mainPaneWithLights.getChildren().add((Object)clonedLightGroup);
        mainPaneWithLights.getStylesheets().setAll((Collection)mainPane.getStylesheets());
        Scene mainScene = new Scene((Parent)mainPaneWithLights);
        this.toolkit.getSnapshotManager().registerRecordable(mainScene);
        primaryStage.setScene(mainScene);
        this.multiSessionManager = new MultiSessionManager(this.toolkit, this.mainWindowController);
        this.mainWindowController.start();
        this.toolkit.start();
        this.initializeStageWithPrimaryScreen();
        primaryStage.show();
        this.initializeStageWithPrimaryScreen();
        if (initialSession != null) {
            Runnable sessionLoadedCallback = () -> this.sessionVisualizerControls.visualizerReadyLatch.countDown();
            this.multiSessionManager.startSession(initialSession, sessionLoadedCallback);
        } else {
            this.sessionVisualizerControls.visualizerReadyLatch.countDown();
        }
    }

    protected SessionVisualizerControlsImpl createControls() {
        return new SessionVisualizerControlsImpl();
    }

    protected SessionVisualizerToolkit createToolkit(Stage primaryStage, Scene3DBuilder scene3DBuilder) throws Exception {
        return new SessionVisualizerToolkit(primaryStage, scene3DBuilder.getRoot());
    }

    public void initializeStageWithPrimaryScreen() {
        SessionVisualizer.initializeStageWithScreen(0.75, Screen.getPrimary(), this.primaryStage);
    }

    public static void initializeStageWithScreen(double sizeRatio, Screen screen, Stage stage) {
        Rectangle2D bounds = screen.getVisualBounds();
        double width = sizeRatio * bounds.getWidth();
        double height = sizeRatio * bounds.getHeight();
        stage.setWidth(width);
        stage.setHeight(height);
        double centerX = bounds.getMinX() + (bounds.getWidth() - width) * 0.5;
        double centerY = bounds.getMinY() + (bounds.getHeight() - height) * 1.0 / 3.0;
        stage.setX(centerX);
        stage.setY(centerY);
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(WindowEvent event) {
        boolean saveConfiguration = false;
        if (this.toolkit.hasActiveSession()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to save the default configuration?", new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
            SessionVisualizerIOTools.addSCSIconToDialog(alert);
            alert.initOwner((Window)this.primaryStage);
            JavaFXMissingTools.centerDialogInOwner(alert);
            Optional result = alert.showAndWait();
            if (!result.isPresent() || result.get() == ButtonType.CANCEL) {
                if (event != null) {
                    event.consume();
                }
                return;
            }
            saveConfiguration = result.get() == ButtonType.YES;
        }
        this.stopNow(saveConfiguration);
    }

    private void stopNow(boolean saveConfiguration) {
        if (this.hasTerminated) {
            return;
        }
        this.hasTerminated = true;
        try {
            this.multiSessionManager.stopSession(saveConfiguration, this.shutdownSessionOnClose);
            this.multiSessionManager.shutdown();
            this.mainWindowController.stop();
            this.toolkit.stop();
            if (this.primaryStage.isShowing()) {
                this.primaryStage.close();
            }
            this.primaryStage.setScene(null);
            this.stopListeners.forEach(Runnable::run);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.sessionVisualizerControls.visualizerShutdownLatch.countDown();
        }
    }

    public AnchorPane getSceneAnchorPane() {
        return this.mainWindowController.getSceneAnchorPane();
    }

    public SessionVisualizerToolkit getToolkit() {
        return this.toolkit;
    }

    public static void main(String[] args) throws Exception {
        SessionVisualizerArgsHandler argsHandler = new SessionVisualizerArgsHandler();
        if (!argsHandler.parseArgs(args)) {
            System.exit(-1);
            return;
        }
        SessionVisualizerControls controls = SessionVisualizer.startSessionVisualizer(argsHandler.getSession(), true);
        controls.addVisualizerShutdownListener(() -> System.exit(0));
    }

    public static SessionVisualizerControls startSessionVisualizer() {
        return SessionVisualizer.startSessionVisualizer(null);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session) {
        return SessionVisualizer.startSessionVisualizer(session, null);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session, Boolean javaFXThreadImplicitExit) {
        return SessionVisualizer.startSessionVisualizer(session, javaFXThreadImplicitExit, true);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session, Boolean javaFXThreadImplicitExit, boolean shutdownSessionOnClose) {
        SessionVisualizer sessionVisualizer = SessionVisualizer.startSessionVisualizerExpert(session, javaFXThreadImplicitExit, shutdownSessionOnClose);
        if (sessionVisualizer != null) {
            return sessionVisualizer.getSessionVisualizerControls();
        }
        return null;
    }

    public static SessionVisualizer startSessionVisualizerExpert(Session session, Boolean javaFXThreadImplicitExit) {
        return SessionVisualizer.startSessionVisualizerExpert(session, javaFXThreadImplicitExit, true);
    }

    public static SessionVisualizer startSessionVisualizerExpert(Session session, Boolean javaFXThreadImplicitExit, boolean shutdownSessionOnClose) {
        JavaFXApplicationCreator.spawnJavaFXMainApplication();
        return JavaFXMissingTools.runAndWait(SessionVisualizer.class, () -> {
            try {
                SessionVisualizer sessionVisualizer = new SessionVisualizer(new Stage(), shutdownSessionOnClose, session);
                JavaFXApplicationCreator.attachStopListener(sessionVisualizer::stop);
                if (javaFXThreadImplicitExit != null && Platform.isImplicitExit() != javaFXThreadImplicitExit) {
                    Platform.setImplicitExit((boolean)javaFXThreadImplicitExit);
                }
                return sessionVisualizer;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public SessionVisualizerControls getSessionVisualizerControls() {
        return this.sessionVisualizerControls;
    }

    static {
        System.setProperty("yo.allowRepeatingSubname", "true");
        DefinitionIOTools.loadResources();
        YoGraphicFXControllerTools.loadResources();
    }

    protected class SessionVisualizerControlsImpl
    implements SessionVisualizerControls {
        private final CountDownLatch visualizerReadyLatch = new CountDownLatch(1);
        private final CountDownLatch visualizerShutdownLatch = new CountDownLatch(1);

        @Override
        public void waitUntilVisualizerFullyUp() {
            try {
                this.visualizerReadyLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void waitUntilVisualizerDown() {
            try {
                this.visualizerShutdownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setCameraOrientation(double latitude, double longitude) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getViewport3DManager().getMainViewport().setCameraOrientation(latitude, longitude, 0.0);
        }

        @Override
        public void setCameraPosition(double x, double y, double z) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getViewport3DManager().getMainViewport().setCameraPosition(x, y, z);
        }

        @Override
        public void setCameraFocalPosition(double x, double y, double z) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getViewport3DManager().getMainViewport().setCameraFocalPosition(x, y, z);
        }

        @Override
        public void setCameraZoom(double distanceFromFocus) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getViewport3DManager().getMainViewport().setCameraZoom(distanceFromFocus);
        }

        @Override
        public void requestCameraRigidBodyTracking(String robotName, String rigidBodyName) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getCamera3DRequest(), new Camera3DRequest(Camera3DRequest.FocalPointRequest.trackRobot(robotName, rigidBodyName)));
        }

        @Override
        public void requestCameraFocalPositionTracking(YoTuple3DDefinition coordinatesToTrack) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getCamera3DRequest(), new Camera3DRequest(Camera3DRequest.FocalPointRequest.trackCoordinates(coordinatesToTrack)));
        }

        @Override
        public void requestCameraPositionTracking(YoTuple3DDefinition cameraCoordinates) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getCamera3DRequest(), new Camera3DRequest(Camera3DRequest.CameraControlRequest.trackPosition(cameraCoordinates)));
        }

        @Override
        public void requestCameraOrbitTracking(YoOrbitalCoordinateDefinition cameraCoordinates) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getCamera3DRequest(), new Camera3DRequest(Camera3DRequest.CameraControlRequest.trackOrbit(cameraCoordinates)));
        }

        @Override
        public void requestCameraLevelOrbitTracking(YoLevelOrbitalCoordinateDefinition cameraCoordinates) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getCamera3DRequest(), new Camera3DRequest(Camera3DRequest.CameraControlRequest.trackLevelOrbit(cameraCoordinates)));
        }

        @Override
        public void showOverheadPlotter2D(boolean show) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getShowOverheadPlotter(), show);
        }

        @Override
        public void requestPlotter2DCoordinateTracking(String xVariableName, String yVariableName, String frameName) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            if (xVariableName == null) {
                xVariableName = Double.toString(0.0);
            }
            if (yVariableName == null) {
                yVariableName = Double.toString(0.0);
            }
            if (frameName == null) {
                frameName = "worldFrame";
            }
            this.submitMessage(this.getTopics().getPlotter2DTrackCoordinateRequest(), new YoTuple2DDefinition(xVariableName, yVariableName, frameName));
        }

        @Override
        public void addStaticVisual(VisualDefinition visualDefinition) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getEnvironmentManager().addStaticVisual(visualDefinition);
        }

        @Override
        public void removeStaticVisual(VisualDefinition visualDefinition) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getEnvironmentManager().removeStaticVisual(visualDefinition);
        }

        @Override
        public void removeYoGraphic(String name) {
            this.submitMessage(this.getTopics().getRemoveYoGraphicRequest(), name);
        }

        @Override
        public void setYoGraphicVisible(String name, boolean visible) {
            this.submitMessage(this.getTopics().getSetYoGraphicVisibleRequest(), new Pair((Object)name, (Object)visible));
        }

        @Override
        public void addYoGraphic(YoGraphicDefinition yoGraphicDefinition) {
            this.submitMessage(this.getTopics().getAddYoGraphicRequest(), yoGraphicDefinition);
        }

        @Override
        public void addYoEntry(String groupName, Collection<String> variableNames) {
            this.submitMessage(this.getTopics().getYoEntryListAdd(), YoEntryListDefinition.newYoVariableEntryList((String)groupName, variableNames));
        }

        @Override
        public void clearAllSliderboards() {
            this.submitMessage(this.getTopics().getYoMultiSliderboardClearAll(), true);
        }

        @Override
        public void setSliderboards(YoSliderboardListDefinition sliderboardListDefinition) {
            this.submitMessage(this.getTopics().getYoMultiSliderboardSet(), sliderboardListDefinition);
        }

        @Override
        public void setSliderboard(YoSliderboardDefinition sliderboardConfiguration) {
            this.submitMessage(this.getTopics().getYoSliderboardSet(), sliderboardConfiguration);
        }

        @Override
        public void removeSliderboard(String sliderboardName, YoSliderboardType sliderboardType) {
            this.submitMessage(this.getTopics().getYoSliderboardRemove(), new Pair((Object)sliderboardName, (Object)sliderboardType));
        }

        @Override
        public void setSliderboardButton(String sliderboardName, YoSliderboardType sliderboardType, YoButtonDefinition buttonDefinition) {
            this.submitMessage(this.getTopics().getYoSliderboardSetButton(), new ImmutableTriple((Object)sliderboardName, (Object)sliderboardType, (Object)buttonDefinition));
        }

        @Override
        public void clearSliderboardButton(String sliderboardName, YoSliderboardType sliderboardType, int buttonIndex) {
            this.submitMessage(this.getTopics().getYoSliderboardClearButton(), new ImmutableTriple((Object)sliderboardName, (Object)sliderboardType, (Object)buttonIndex));
        }

        @Override
        public void setSliderboardKnob(String sliderboardName, YoSliderboardType sliderboardType, YoKnobDefinition knobDefinition) {
            this.submitMessage(this.getTopics().getYoSliderboardSetKnob(), new ImmutableTriple((Object)sliderboardName, (Object)sliderboardType, (Object)knobDefinition));
        }

        @Override
        public void clearSliderboardKnob(String sliderboardName, YoSliderboardType sliderboardType, int knobIndex) {
            this.submitMessage(this.getTopics().getYoSliderboardClearKnob(), new ImmutableTriple((Object)sliderboardName, (Object)sliderboardType, (Object)knobIndex));
        }

        @Override
        public void setSliderboardSlider(String sliderboardName, YoSliderboardType sliderboardType, YoSliderDefinition sliderDefinition) {
            this.submitMessage(this.getTopics().getYoSliderboardSetSlider(), new ImmutableTriple((Object)sliderboardName, (Object)sliderboardType, (Object)sliderDefinition));
        }

        @Override
        public void clearSliderboardSlider(String sliderboardName, YoSliderboardType sliderboardType, int sliderIndex) {
            this.submitMessage(this.getTopics().getYoSliderboardClearSlider(), new ImmutableTriple((Object)sliderboardName, (Object)sliderboardType, (Object)sliderIndex));
        }

        @Override
        public void addSessionDataFilterParameters(SessionDataFilterParameters filterParameters) {
            this.submitMessage(this.getTopics().getSessionDataFilterParametersAddRequest(), filterParameters);
        }

        @Override
        public void exportVideo(SceneVideoRecordingRequest request) {
            this.checkVisualizerRunning();
            this.checkSessionThreadRunning();
            CountDownLatch latch = new CountDownLatch(1);
            Runnable callback = request.getRecordingEndedCallback();
            request.setRecordingEndedCallback(() -> {
                latch.countDown();
                if (callback != null) {
                    callback.run();
                }
            });
            SessionVisualizer.this.messager.submitMessage(SessionVisualizer.this.topics.getSceneVideoRecordingRequest(), request);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void disableGUIControls() {
            this.submitMessage(this.getTopics().getDisableUserControls(), true);
        }

        @Override
        public void enableGUIControls() {
            this.submitMessage(this.getTopics().getDisableUserControls(), false);
        }

        SessionVisualizerTopics getTopics() {
            return SessionVisualizer.this.topics;
        }

        <T> void submitMessage(MessagerAPIFactory.Topic<T> topic, T messageContent) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.messager.submitMessage(topic, messageContent);
        }

        @Override
        public Window getPrimaryGUIWindow() {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            return SessionVisualizer.this.primaryStage;
        }

        @Override
        public void addCustomGUIControl(Node control) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.mainWindowController.getUserSidePaneController().addControl(control);
        }

        @Override
        public boolean removeCustomGUIControl(Node control) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.mainWindowController.getUserSidePaneController().removeControl(control);
        }

        @Override
        public void loadCustomGUIPane(String name, URL fxmlResource) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.mainWindowController.getUserSidePaneController().loadCustomPane(name, fxmlResource);
        }

        @Override
        public void addCustomGUIPane(String name, Pane pane) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.mainWindowController.getUserSidePaneController().addCustomPane(name, pane);
        }

        @Override
        public boolean removeCustomGUIPane(String name) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.mainWindowController.getUserSidePaneController().removeCustomPane(name);
        }

        @Override
        public YoDoubleProperty newYoDoubleProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoDoubleProperty(variableName);
        }

        @Override
        public YoIntegerProperty newYoIntegerProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoIntegerProperty(variableName);
        }

        @Override
        public YoBooleanProperty newYoBooleanProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoBooleanProperty(variableName);
        }

        @Override
        public YoLongProperty newYoLongProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoLongProperty(variableName);
        }

        @Override
        public <E extends Enum<E>> YoEnumAsStringProperty<E> newYoEnumProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoEnumProperty(variableName);
        }

        @Override
        public void addSessionChangedListener(SessionChangeListener listener) {
            SessionVisualizer.this.toolkit.addSessionChangedListener(listener);
        }

        @Override
        public boolean removeSessionChangedListener(SessionChangeListener listener) {
            return SessionVisualizer.this.toolkit.removeSessionChangedListener(listener);
        }

        @Override
        public void requestVisualizerShutdown() {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> SessionVisualizer.this.stop());
        }

        @Override
        public void shutdownSession() {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> SessionVisualizer.this.stopNow(false));
        }

        @Override
        public void addVisualizerShutdownListener(Runnable listener) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.stopListeners.add(listener);
        }

        @Override
        public boolean isVisualizerShutdown() {
            return SessionVisualizer.this.hasTerminated;
        }

        private void checkVisualizerRunning() {
            if (SessionVisualizer.this.hasTerminated) {
                throw new IllegalOperationException("Unable to perform operation, visualizer has terminated.");
            }
        }

        private void checkSessionThreadRunning() {
            if (SessionVisualizer.this.toolkit.getSession() == null) {
                throw new IllegalOperationException("No active session.");
            }
            if (!SessionVisualizer.this.toolkit.getSession().hasSessionStarted()) {
                throw new IllegalOperationException("Session thread is not running.");
            }
        }
    }
}

