/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ToggleButton;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple2DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;

public class Plotter2DOptionsStageController
implements VisualizerController {
    @FXML
    private Stage stage;
    @FXML
    private ToggleButton enableTrackingToggleButton;
    @FXML
    private YoCompositeEditorPaneController trackedPositionEditorController;
    private final List<Runnable> cleanupActions = new ArrayList<Runnable>();
    private Window owner;
    private YoCompositeSearchManager yoCompositeSearchManager;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.owner = toolkit.getWindow();
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        SCS2JavaFXMessager messager = toolkit.getMessager();
        SessionVisualizerTopics topics = toolkit.getTopics();
        MessagerAPIFactory.Topic<YoTuple2DDefinition> trackCoordsTopic = topics.getPlotter2DTrackCoordinateRequest();
        SimpleObjectProperty lastCoordinates = new SimpleObjectProperty((Object)this, "lastCoordinatesProperty", (Object)messager.getLastValue(trackCoordsTopic));
        this.trackedPositionEditorController.initialize(toolkit.getGlobalToolkit(), this.yoCompositeSearchManager.getCollectionFromType("YoTuple2D"), true);
        this.trackedPositionEditorController.setCompositeName("Tracking Coordinates");
        this.enableTrackingToggleButton.selectedProperty().addListener((arg_0, arg_1, arg_2) -> Plotter2DOptionsStageController.lambda$initialize$0(messager, trackCoordsTopic, (Property)lastCoordinates, arg_0, arg_1, arg_2));
        this.trackedPositionEditorController.getMainPane().disableProperty().bind((ObservableValue)this.enableTrackingToggleButton.selectedProperty().not());
        if (lastCoordinates.getValue() != null) {
            this.trackedPositionEditorController.setInput((YoCompositeDefinition)lastCoordinates.getValue());
            this.enableTrackingToggleButton.selectedProperty().set(true);
        }
        this.trackedPositionEditorController.addInputListener((arg_0, arg_1) -> Plotter2DOptionsStageController.lambda$initialize$1((Property)lastCoordinates, messager, trackCoordsTopic, arg_0, arg_1));
        EventHandler closeWindowEventHandler = e -> this.close();
        this.owner.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler);
        this.cleanupActions.add(() -> this.owner.removeEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, closeWindowEventHandler));
        this.stage.setOnCloseRequest(e -> this.close());
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.stage);
        JavaFXMissingTools.centerWindowInOwner((Window)this.stage, this.owner);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void close() {
        this.stage.close();
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
    }

    private static /* synthetic */ void lambda$initialize$1(Property lastCoordinates, SCS2JavaFXMessager messager, MessagerAPIFactory.Topic trackCoordsTopic, DoubleProperty[] coords, Property frame) {
        YoTuple2DDefinition newCoordinates = CompositePropertyTools.toYoTuple2DDefinition(new Tuple2DProperty((Property<ReferenceFrame>)frame, coords));
        lastCoordinates.setValue((Object)newCoordinates);
        messager.submitMessage(trackCoordsTopic, newCoordinates);
    }

    private static /* synthetic */ void lambda$initialize$0(SCS2JavaFXMessager messager, MessagerAPIFactory.Topic trackCoordsTopic, Property lastCoordinates, ObservableValue o, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            messager.submitMessage(trackCoordsTopic, (YoTuple2DDefinition)lastCoordinates.getValue());
        } else {
            messager.submitMessage(trackCoordsTopic, null);
        }
    }
}

