/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.properties;

import java.lang.ref.WeakReference;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.Property;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoVariableProperty;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoLongProperty
extends LongPropertyBase
implements YoVariableProperty<YoLong, Number> {
    private final YoLong yoLong;
    private final Object bean;
    private final YoVariableChangedListener propertyUpdater = new YoLongPropertyUpdater(this);
    private LinkedYoLong linkedBuffer;

    public YoLongProperty(YoLong yoLong) {
        this(yoLong, null);
    }

    public YoLongProperty(YoLong yoLong, Object bean) {
        this.yoLong = yoLong;
        this.bean = bean;
        this.pullYoLongValue();
        yoLong.addListener(this.propertyUpdater);
    }

    public void setLinkedBuffer(LinkedYoLong linkedBuffer) {
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
        }
        this.linkedBuffer = linkedBuffer;
        if (linkedBuffer != null) {
            linkedBuffer.addUser((Object)this);
            this.pullYoLongValue();
        }
    }

    public LinkedYoLong getLinkedBuffer() {
        return this.linkedBuffer;
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.unbind();
        this.yoLong.removeListener(this.propertyUpdater);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
            this.pullYoLongValue();
        }
    }

    public void set(long newValue) {
        super.set(newValue);
        this.yoLong.set(newValue);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.push();
        }
    }

    private void pullYoLongValue() {
        super.set(this.yoLong.getValue());
    }

    public void bindLongProperty(Property<Long> property) {
        property.setValue((Object)this.getValue());
        MutableBoolean updatingControl = new MutableBoolean(false);
        MutableBoolean updatingThis = new MutableBoolean(false);
        this.addListener((o, oldValue, newValue) -> {
            if (updatingThis.isTrue()) {
                return;
            }
            updatingControl.setTrue();
            property.setValue((Object)newValue.longValue());
            updatingControl.setFalse();
        });
        property.addListener((o, oldValue, newValue) -> {
            if (updatingControl.isTrue()) {
                return;
            }
            updatingThis.setTrue();
            this.set((long)newValue);
            updatingThis.setFalse();
        });
    }

    @Override
    public YoLong getYoVariable() {
        return this.yoLong;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.yoLong.getName();
    }

    private static class YoLongPropertyUpdater
    implements YoVariableChangedListener {
        private final WeakReference<YoLongProperty> propertyRef;

        public YoLongPropertyUpdater(YoLongProperty property) {
            this.propertyRef = new WeakReference<YoLongProperty>(property);
        }

        public void changed(YoVariable source) {
            YoLongProperty property = (YoLongProperty)this.propertyRef.get();
            if (property != null) {
                property.pullYoLongValue();
            }
        }
    }
}

