/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField.YoVariableTextField;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;

public class YoReferenceFrameTextField
extends YoVariableTextField<Property<ReferenceFrame>> {
    private final ReferenceFrameManager referenceFrameManager;

    public YoReferenceFrameTextField(TextField textField, ReferenceFrameManager referenceFrameManager) {
        this(textField, referenceFrameManager, null);
    }

    public YoReferenceFrameTextField(TextField textField, ReferenceFrameManager referenceFrameManager, ImageView validImageView) {
        super(textField, validImageView);
        this.referenceFrameManager = referenceFrameManager;
        textField.setText(referenceFrameManager.getWorldFrame().getName());
    }

    @Override
    protected boolean isTextValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        ReferenceFrame referenceFrame = this.referenceFrameManager.getReferenceFrameFromUniqueName(text);
        if (referenceFrame == null) {
            referenceFrame = this.referenceFrameManager.getReferenceFrameFromFullname(text);
        }
        return referenceFrame != null;
    }

    @Override
    protected String simplifyText(String text) {
        if (text == null) {
            return this.referenceFrameManager.getUniqueName(this.referenceFrameManager.getWorldFrame());
        }
        ReferenceFrame referenceFrame = this.referenceFrameManager.getReferenceFrameFromFullname(text);
        if (referenceFrame == null) {
            return null;
        }
        String uniqueName = this.referenceFrameManager.getUniqueName(referenceFrame);
        if (uniqueName != null && uniqueName.equals(text)) {
            return null;
        }
        return uniqueName;
    }

    @Override
    protected Callback<AutoCompletionBinding.ISuggestionRequest, Collection<String>> createSuggestions() {
        Collection<String> referenceFrameUniqueNames = this.referenceFrameManager.getReferenceFrameUniqueNames();
        return request -> {
            String userText = request.getUserText();
            if (userText.isEmpty()) {
                return referenceFrameUniqueNames;
            }
            String userTextLowerCase = userText.toLowerCase();
            return referenceFrameUniqueNames.stream().filter(v -> v.toLowerCase().contains(userTextLowerCase)).collect(Collectors.toList());
        };
    }

    @Override
    protected Property<ReferenceFrame> toSupplier(String text) {
        ReferenceFrame referenceFrame = this.referenceFrameManager.getReferenceFrameFromUniqueName(text);
        if (referenceFrame == null) {
            return null;
        }
        return new SimpleObjectProperty((Object)referenceFrame);
    }

    @Override
    protected List<YoComposite> retrieveYoCompositesFromDragboard(Dragboard dragboard) {
        LogTools.error((String)"Unsupported operation, implement me!");
        return null;
    }
}

